"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.9/js/components/Sidebar/Sidebar.es", ['module', 'exports', 'require', '../Form/FormSupport.es', 'dynamic-data-mapping-form-builder$classnames', 'frontend-taglib-clay$clay-button', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-dom', '../FieldTypeBox/FieldTypeBox.es', '../Form/FormRenderer.es', 'frontend-js-metal-web$metal-useragent', '../Form/Evaluator.es', 'frontend-taglib-clay$clay-dropdown', 'frontend-taglib-clay$clay-icon', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-events', '../../util/config.es', '../../util/fieldSupport.es', '../../util/visitors.es', '../../util/dom.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var FormSupport = _interopRequireWildcard(require("../Form/FormSupport.es"));

  var _classnames = _interopRequireDefault(require("dynamic-data-mapping-form-builder$classnames"));

  var _clayButton = _interopRequireDefault(require("frontend-taglib-clay$clay-button"));

  var _metalJsx = _interopRequireWildcard(require("frontend-js-metal-web$metal-jsx"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _FieldTypeBoxEs = _interopRequireDefault(require("../FieldTypeBox/FieldTypeBox.es"));

  var _FormRenderer = _interopRequireDefault(require("../Form/FormRenderer.es"));

  var _metalUseragent = _interopRequireDefault(require("frontend-js-metal-web$metal-useragent"));

  var _Evaluator = _interopRequireDefault(require("../Form/Evaluator.es"));

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _clayIcon = require("frontend-taglib-clay$clay-icon");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _config = require("../../util/config.es");

  var _fieldSupport = require("../../util/fieldSupport.es");

  var _visitors = require("../../util/visitors.es");

  var _dom = require("../../util/dom.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var EVALUATOR_URL = '/o/dynamic-data-mapping-form-context-provider/';
  var FormWithEvaluator = (0, _Evaluator.default)(_FormRenderer.default);
  /**
   * Sidebar is a tooling to mount forms.
   */

  var Sidebar =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Sidebar, _Component);

    function Sidebar() {
      _classCallCheck(this, Sidebar);

      return _possibleConstructorReturn(this, _getPrototypeOf(Sidebar).apply(this, arguments));
    }

    _createClass(Sidebar, [{
      key: "attached",
      value: function attached() {
        this._bindDragAndDrop();

        this._eventHandler.add(_metalDom.default.on(document, 'mousedown', this._handleDocumentMouseDown, true));
      }
    }, {
      key: "changeFieldType",
      value: function changeFieldType(type) {
        var _this$props = this.props,
            defaultLanguageId = _this$props.defaultLanguageId,
            editingLanguageId = _this$props.editingLanguageId,
            fieldTypes = _this$props.fieldTypes,
            focusedField = _this$props.focusedField;
        var newFieldType = fieldTypes.find(function (_ref) {
          var name = _ref.name;
          return name === type;
        });

        var newSettingsContext = _objectSpread({}, newFieldType.settingsContext, {
          pages: (0, _fieldSupport.normalizeSettingsContextPages)(newFieldType.settingsContext.pages, editingLanguageId, newFieldType, focusedField.fieldName)
        });

        var settingsContext = focusedField.settingsContext;

        if (type !== focusedField.type) {
          settingsContext = this._mergeFieldTypeSettings(settingsContext, newSettingsContext);
        }

        this.emit('focusedFieldUpdated', _objectSpread({}, focusedField, newFieldType, (0, _fieldSupport.getFieldProperties)(settingsContext, defaultLanguageId, editingLanguageId), {
          settingsContext: settingsContext,
          type: newFieldType.name
        }));
        this.refs.evaluableForm.evaluate();
      }
    }, {
      key: "close",
      value: function close() {
        this.setState({
          open: false
        });
      }
    }, {
      key: "created",
      value: function created() {
        this._eventHandler = new _metalEvents.EventHandler();

        var transitionEnd = this._getTransitionEndEvent();

        this.supportsTransitionEnd = transitionEnd !== false;
        this.transitionEnd = transitionEnd || 'transitionend';
        this._handleChangeFieldTypeItemClicked = this._handleChangeFieldTypeItemClicked.bind(this);
        this._handleCloseButtonClicked = this._handleCloseButtonClicked.bind(this);
        this._handleDocumentMouseDown = this._handleDocumentMouseDown.bind(this);
        this._handleDragEnded = this._handleDragEnded.bind(this);
        this._handleDragStarted = this._handleDragStarted.bind(this);
        this._handleEvaluatorChanged = this._handleEvaluatorChanged.bind(this);
        this._handleFieldSettingsClicked = this._handleFieldSettingsClicked.bind(this);
        this._handlePreviousButtonClicked = this._handlePreviousButtonClicked.bind(this);
        this._handleSettingsFieldBlurred = this._handleSettingsFieldBlurred.bind(this);
        this._handleSettingsFieldEdited = this._handleSettingsFieldEdited.bind(this);
        this._handleTabItemClicked = this._handleTabItemClicked.bind(this);
        this._renderFieldTypeDropdownLabel = this._renderFieldTypeDropdownLabel.bind(this);
      }
    }, {
      key: "disposeDragAndDrop",
      value: function disposeDragAndDrop() {
        if (this._dragAndDrop) {
          this._dragAndDrop.dispose();
        }
      }
    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(Sidebar.prototype), "disposeInternal", this).call(this);

        this._eventHandler.removeAllListeners();

        this.disposeDragAndDrop();
        this.emit('fieldBlurred');
      }
    }, {
      key: "getFormContext",
      value: function getFormContext() {
        var _this = this;

        var _this$props2 = this.props,
            defaultLanguageId = _this$props2.defaultLanguageId,
            editingLanguageId = _this$props2.editingLanguageId,
            focusedField = _this$props2.focusedField;
        var settingsContext = focusedField.settingsContext;
        var visitor = new _visitors.PagesVisitor(settingsContext.pages);
        return _objectSpread({}, settingsContext, {
          pages: visitor.mapFields(function (field) {
            return _objectSpread({}, field, {
              defaultLanguageId: defaultLanguageId,
              editingLanguageId: editingLanguageId,
              readOnly: _this.isFieldReadOnly(field)
            });
          })
        });
      }
    }, {
      key: "isActionsDisabled",
      value: function isActionsDisabled() {
        var _this$props3 = this.props,
            defaultLanguageId = _this$props3.defaultLanguageId,
            editingLanguageId = _this$props3.editingLanguageId;
        return defaultLanguageId !== editingLanguageId;
      }
    }, {
      key: "isChangeFieldTypeEnabled",
      value: function isChangeFieldTypeEnabled() {
        return !this.isActionsDisabled();
      }
    }, {
      key: "isFieldReadOnly",
      value: function isFieldReadOnly(_ref2) {
        var localizable = _ref2.localizable,
            type = _ref2.type;
        var _this$props4 = this.props,
            defaultLanguageId = _this$props4.defaultLanguageId,
            editingLanguageId = _this$props4.editingLanguageId;
        return defaultLanguageId !== editingLanguageId && (!localizable || type === 'validation');
      }
    }, {
      key: "open",
      value: function open() {
        var _this2 = this;

        var transitionEnd = this.transitionEnd;

        _metalDom.default.once(this.refs.container, transitionEnd, function () {
          if (_this2._isEditMode()) {
            var firstInput = _this2.element.querySelector('input');

            if (firstInput && document.activeElement !== firstInput) {
              firstInput.focus();
              (0, _dom.selectText)(firstInput);
            }
          }
        });

        this.setState({
          activeTab: 0,
          open: true
        });
        this.refreshDragAndDrop();
      }
    }, {
      key: "refreshDragAndDrop",
      value: function refreshDragAndDrop() {
        this._dragAndDrop.setState({
          targets: _metalUseragent.default.isIE ? this._dragAndDrop.setterTargetsFn_('.ddm-target') : '.ddm-target'
        });
      }
    }, {
      key: "render",
      value: function render() {
        var _this$state = this.state,
            activeTab = _this$state.activeTab,
            open = _this$state.open;
        var _this$props5 = this.props,
            editingLanguageId = _this$props5.editingLanguageId,
            focusedField = _this$props5.focusedField,
            spritemap = _this$props5.spritemap;
        var layoutRenderEvents = {
          evaluated: this._handleEvaluatorChanged,
          fieldBlurred: this._handleSettingsFieldBlurred,
          fieldEdited: this._handleSettingsFieldEdited
        };

        var editMode = this._isEditMode();

        var styles = (0, _classnames.default)('sidebar-container', {
          open: open
        });
        IncrementalDOM.elementOpen("div", null, null, "class", styles, "ref", "container");
        IncrementalDOM.elementOpen("div", null, null, "class", "sidebar sidebar-light");
        IncrementalDOM.elementOpen("nav", null, null, "class", "component-tbar tbar");
        IncrementalDOM.elementOpen("div", null, null, "class", "container-fluid");
        iDOMHelpers.renderArbitrary(this._renderTopBar());
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("nav");
        IncrementalDOM.elementOpen("nav", null, null, "class", "component-navigation-bar navbar navigation-bar navbar-collapse-absolute navbar-expand-md navbar-underline");
        IncrementalDOM.elementOpen("a", null, null, "aria-controls", "sidebarLightCollapse00", "aria-expanded", "false", "aria-label", "Toggle Navigation", "class", "collapsed navbar-toggler navbar-toggler-link", "data-toggle", "collapse", "href", "#sidebarLightCollapse00", "role", "button");
        IncrementalDOM.elementOpen("span", null, null, "class", "navbar-text-truncate");
        IncrementalDOM.text("Details");
        IncrementalDOM.elementClose("span");
        IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-caret-bottom");
        IncrementalDOM.elementVoid("use", null, null, "xlink:href", "".concat(spritemap, "#caret-bottom"));
        IncrementalDOM.elementClose("svg");
        IncrementalDOM.elementClose("a");
        IncrementalDOM.elementOpen("div", null, null, "class", "collapse navbar-collapse", "id", "sidebarLightCollapse00");
        IncrementalDOM.elementOpen("ul", null, null, "class", "nav navbar-nav", "role", "tablist");
        iDOMHelpers.renderArbitrary(this._renderNavItems());
        IncrementalDOM.elementClose("ul");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("nav");
        IncrementalDOM.elementOpen("div", null, null, "class", "ddm-sidebar-body");
        iDOMHelpers.renderArbitrary(!editMode && activeTab == 0 && this._renderFieldTypeGroups());
        iDOMHelpers.renderArbitrary(!editMode && activeTab == 1 && this._renderElementSets());
        iDOMHelpers.renderArbitrary(editMode && (IncrementalDOM.elementOpen("div", null, null, "class", "sidebar-body ddm-field-settings"), (IncrementalDOM.elementOpen("div", null, null, "class", "tab-content"), IncrementalDOM.elementVoid(FormWithEvaluator, null, null, "activePage", activeTab, "editingLanguageId", editingLanguageId, "events", layoutRenderEvents, "fieldType", focusedField.type, "formContext", this.getFormContext(), "spritemap", spritemap, "url", EVALUATOR_URL, "editable", true, "paginationMode", "tabbed", "ref", "evaluableForm"), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("div")));
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("div");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "syncEditingLanguageId",
      value: function syncEditingLanguageId() {
        var evaluableForm = this.refs.evaluableForm;

        if (evaluableForm) {
          evaluableForm.evaluate();
        }
      }
    }, {
      key: "syncVisible",
      value: function syncVisible(visible) {
        if (!visible) {
          this.emit('fieldBlurred');
        }
      }
    }, {
      key: "_bindDragAndDrop",
      value: function _bindDragAndDrop() {
        this._dragAndDrop = new _metalDragDrop.DragDrop({
          dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
          sources: '.ddm-drag-item',
          targets: '.ddm-target',
          useShim: false
        });

        this._eventHandler.add(this._dragAndDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDragEnded), this._dragAndDrop.on(_metalDragDrop.Drag.Events.START, this._handleDragStarted));
      }
    }, {
      key: "_cancelFieldChanges",
      value: function _cancelFieldChanges(indexes) {
        this.emit('fieldChangesCanceled', indexes);
      }
    }, {
      key: "_deleteField",
      value: function _deleteField(indexes) {
        this.emit('fieldDeleted', {
          indexes: indexes
        });
      }
    }, {
      key: "_dropdownFieldTypesValueFn",
      value: function _dropdownFieldTypesValueFn() {
        var fieldTypes = this.props.fieldTypes;
        return fieldTypes.filter(function (_ref3) {
          var system = _ref3.system;
          return !system;
        }).map(function (fieldType) {
          return _objectSpread({}, fieldType, {
            type: 'item'
          });
        });
      }
    }, {
      key: "_duplicateField",
      value: function _duplicateField(indexes) {
        this.emit('fieldDuplicated', {
          indexes: indexes
        });
      }
    }, {
      key: "_fieldTypesGroupValueFn",
      value: function _fieldTypesGroupValueFn() {
        var fieldTypes = this.props.fieldTypes;
        var group = {
          basic: {
            fields: [],
            label: Liferay.Language.get('field-types-basic-elements')
          },
          customized: {
            fields: [],
            label: Liferay.Language.get('field-types-customized-elements')
          }
        };
        return fieldTypes.reduce(function (prev, next) {
          if (next.group && !next.system) {
            prev[next.group].fields.push(next);
          }

          return prev;
        }, group);
      }
    }, {
      key: "_getTransitionEndEvent",
      value: function _getTransitionEndEvent() {
        var el = document.createElement('metalClayTransitionEnd');
        var transitionEndEvents = {
          MozTransition: 'transitionend',
          OTransition: 'oTransitionEnd otransitionend',
          transition: 'transitionend',
          WebkitTransition: 'webkitTransitionEnd'
        };
        var eventName = false;

        for (var name in transitionEndEvents) {
          if (el.style[name] !== undefined) {
            eventName = transitionEndEvents[name];
            break;
          }
        }

        return eventName;
      }
    }, {
      key: "_handleChangeFieldTypeItemClicked",
      value: function _handleChangeFieldTypeItemClicked(_ref4) {
        var data = _ref4.data;
        var newFieldType = data.item.name;
        this.changeFieldType(newFieldType);
      }
    }, {
      key: "_handleCloseButtonClicked",
      value: function _handleCloseButtonClicked() {
        this.close();
      }
    }, {
      key: "_handleDocumentMouseDown",
      value: function _handleDocumentMouseDown(_ref5) {
        var _this3 = this;

        var target = _ref5.target;
        var transitionEnd = this.transitionEnd;
        var open = this.state.open;

        if (this._isCloseButton(target) || open && !this._isSidebarElement(target) && !this._isTranslationItem(target)) {
          this.close();

          _metalDom.default.once(this.refs.container, transitionEnd, function () {
            return _this3.emit('fieldBlurred');
          });

          if (!this._isModalElement(target)) {
            setTimeout(function () {
              return _this3.emit('fieldBlurred');
            }, 500);
          }
        }
      }
    }, {
      key: "_handleDragEnded",
      value: function _handleDragEnded(data, event) {
        event.preventDefault();

        if (!data.target) {
          return;
        }

        var fieldTypes = this.props.fieldTypes;
        var fieldSetId = data.source.dataset.fieldSetId;
        var target = FormSupport.getIndexes(data.target.parentElement);

        if (fieldSetId) {
          this.emit('fieldSetAdded', {
            data: data,
            fieldSetId: fieldSetId,
            target: target
          });
        } else {
          var fieldType = fieldTypes.find(function (_ref6) {
            var name = _ref6.name;
            return name === data.source.dataset.fieldTypeName;
          });
          this.emit('fieldAdded', {
            data: data,
            fieldType: _objectSpread({}, fieldType, {
              editable: true
            }),
            target: target
          });
        }
      }
    }, {
      key: "_handleDragStarted",
      value: function _handleDragStarted() {
        this.refreshDragAndDrop();
        this.close();
      }
    }, {
      key: "_handleEvaluatorChanged",
      value: function _handleEvaluatorChanged(pages) {
        var focusedField = this.props.focusedField;
        this.emit('focusedFieldUpdated', _objectSpread({}, focusedField, {
          settingsContext: _objectSpread({}, focusedField.settingsContext, {
            pages: pages
          })
        }));
      }
    }, {
      key: "_handleFieldSettingsClicked",
      value: function _handleFieldSettingsClicked(_ref7) {
        var item = _ref7.data.item;
        var _this$props$focusedFi = this.props.focusedField,
            columnIndex = _this$props$focusedFi.columnIndex,
            pageIndex = _this$props$focusedFi.pageIndex,
            rowIndex = _this$props$focusedFi.rowIndex;
        var settingsItem = item.settingsItem;
        var indexes = {
          columnIndex: columnIndex,
          pageIndex: pageIndex,
          rowIndex: rowIndex
        };

        if (!item.disabled) {
          if (settingsItem === 'duplicate-field') {
            this._duplicateField(indexes);
          } else if (settingsItem === 'delete-field') {
            this._deleteField(indexes);
          } else if (settingsItem === 'cancel-field-changes') {
            this._cancelFieldChanges(indexes);
          }
        }
      }
    }, {
      key: "_handlePreviousButtonClicked",
      value: function _handlePreviousButtonClicked() {
        var _this4 = this;

        var transitionEnd = this.transitionEnd;
        this.close();

        _metalDom.default.once(this.refs.container, transitionEnd, function () {
          _this4.emit('fieldBlurred');

          _this4.open();
        });
      }
    }, {
      key: "_handleSettingsFieldBlurred",
      value: function _handleSettingsFieldBlurred(event) {
        this.emit('settingsFieldBlurred', event);
      }
    }, {
      key: "_handleSettingsFieldEdited",
      value: function _handleSettingsFieldEdited(event) {
        this.emit('settingsFieldEdited', event);
      }
    }, {
      key: "_handleTabItemClicked",
      value: function _handleTabItemClicked(event) {
        var target = event.target;

        var _dom$closest = _metalDom.default.closest(target, '.nav-item'),
            index = _dom$closest.dataset.index;

        event.preventDefault();
        this.setState({
          activeTab: parseInt(index, 10)
        });
      }
    }, {
      key: "_hasRuleExpression",
      value: function _hasRuleExpression(fieldName) {
        var rules = this.props.rules;
        var visitor = new _visitors.RulesVisitor(rules);
        return visitor.containsFieldExpression(fieldName);
      }
    }, {
      key: "_isCloseButton",
      value: function _isCloseButton(node) {
        var closeButton = this.refs.closeButton;
        return closeButton.contains(node);
      }
    }, {
      key: "_isEditMode",
      value: function _isEditMode() {
        var focusedField = this.props.focusedField;
        return !(Object.keys(focusedField).length === 0 && focusedField.constructor === Object);
      }
    }, {
      key: "_isModalElement",
      value: function _isModalElement(node) {
        return _metalDom.default.closest(node, '.modal');
      }
    }, {
      key: "_isSettingsElement",
      value: function _isSettingsElement(target) {
        var fieldSettingsActions = this.refs.fieldSettingsActions;
        var dropdownPortal;

        if (fieldSettingsActions) {
          var dropdown = fieldSettingsActions.refs.dropdown;
          var portal = dropdown.refs.portal;
          dropdownPortal = portal.element.contains(target);
        }

        return dropdownPortal;
      }
    }, {
      key: "_isSidebarElement",
      value: function _isSidebarElement(node) {
        var element = this.element;

        var alloyEditorToolbarNode = _metalDom.default.closest(node, '.ae-ui');

        var fieldColumnNode = _metalDom.default.closest(node, '.col-ddm');

        var fieldTypesDropdownNode = _metalDom.default.closest(node, '.dropdown-menu');

        return alloyEditorToolbarNode || fieldTypesDropdownNode || fieldColumnNode || element.contains(node) || this._isSettingsElement(node);
      }
    }, {
      key: "_isTranslationItem",
      value: function _isTranslationItem(node) {
        return !!_metalDom.default.closest(node, '.lfr-translationmanager');
      }
    }, {
      key: "_mergeFieldTypeSettings",
      value: function _mergeFieldTypeSettings(oldSettingsContext, newSettingsContext) {
        var newVisitor = new _visitors.PagesVisitor(newSettingsContext.pages);
        var oldVisitor = new _visitors.PagesVisitor(oldSettingsContext.pages);
        var excludedFields = ['indexType', 'type', 'validation'];

        var getPreviousField = function getPreviousField(_ref8) {
          var fieldName = _ref8.fieldName,
              type = _ref8.type,
              value = _ref8.value;
          var field;
          oldVisitor.findField(function (oldField) {
            if (excludedFields.indexOf(fieldName) === -1 && oldField.fieldName === fieldName && oldField.type === type) {
              field = oldField;
            }

            return field;
          });
          return field;
        };

        return _objectSpread({}, newSettingsContext, {
          pages: newVisitor.mapFields(function (newField) {
            var previousField = getPreviousField(newField);

            if (previousField) {
              var multiple = newField.multiple,
                  visible = newField.visible;

              for (var prop in newField) {
                if (previousField.hasOwnProperty(prop)) {
                  newField[prop] = previousField[prop];
                }
              }

              newField.multiple = multiple;
              newField.visible = visible;

              if (newField.fieldName === 'predefinedValue') {
                delete newField.value;
              }
            }

            return newField;
          })
        });
      }
    }, {
      key: "_openValueFn",
      value: function _openValueFn() {
        var open = this.props.open;
        return open;
      }
    }, {
      key: "_renderElementSets",
      value: function _renderElementSets() {
        var fieldSets = this.props.fieldSets;
        var groups = Object.keys(fieldSets);
        var elementSetsArea = '';

        if (groups.length > 0) {
          elementSetsArea = this._renderElementSetsGroups(groups);
        } else {
          elementSetsArea = this._renderEmptyElementSets();
        }

        return elementSetsArea;
      }
    }, {
      key: "_renderElementSetsGroups",
      value: function _renderElementSetsGroups(groups) {
        var _this$props6 = this.props,
            fieldSets = _this$props6.fieldSets,
            spritemap = _this$props6.spritemap;
        IncrementalDOM.elementOpen("div", null, null, "aria-orientation", "vertical", "class", "ddm-field-types-panel panel-group", "id", "accordion03", "role", "tablist");
        iDOMHelpers.renderArbitrary(groups.map(function (key) {
          return iDOMHelpers.jsxWrapper(function (_ddmFieldTypes$co, _ddmFieldTypes$con, _key, _fieldSets$key$id, _fieldSets$key$name, _fieldType_$concat, _fieldType_$concat2, _lexiconIconLexicon, _$concat$concat, _fieldSets$key$name2) {
            IncrementalDOM.elementOpen("div", _key, ["class", "panel-collapse show", "key", _key, "role", "tabpanel"], "aria-labelledby", _ddmFieldTypes$co, "id", _ddmFieldTypes$con);
            IncrementalDOM.elementOpen("div", null, null, "class", "panel-body p-0 m-0 list-group");
            IncrementalDOM.elementOpen("div", _fieldType_$concat, ["class", "ddm-drag-item list-group-item list-group-item-flex", "key", _fieldType_$concat], "data-field-set-id", _fieldSets$key$id, "data-field-set-name", _fieldSets$key$name, "ref", _fieldType_$concat2);
            IncrementalDOM.elementOpen("div", null, null, "class", "autofit-col");
            IncrementalDOM.elementOpen("span", null, null, "class", "sticker sticker-secondary");
            IncrementalDOM.elementOpen("span", null, null, "class", "inline-item");
            IncrementalDOM.elementOpen("svg", null, null, "class", _lexiconIconLexicon, "aria-hidden", "true");
            IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat$concat);
            IncrementalDOM.elementClose("svg");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementOpen("div", null, null, "class", "autofit-col autofit-col-expand");
            IncrementalDOM.elementOpen("h4", null, null, "class", "list-group-title text-truncate");
            IncrementalDOM.elementOpen("span");
            iDOMHelpers.renderArbitrary(_fieldSets$key$name2);
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("h4");
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementClose("div");
            return IncrementalDOM.elementClose("div");
          }, ["#ddm-field-types-".concat(key, "-header"), "ddm-field-types-".concat(key, "-body"), key, fieldSets[key].id, fieldSets[key].name, "fieldType_".concat(fieldSets[key].name), "fieldType_".concat(fieldSets[key].name), "lexicon-icon lexicon-icon-".concat(fieldSets[key].icon), "".concat(spritemap, "#").concat(fieldSets[key].icon), fieldSets[key].name]);
        }));
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_renderEmptyElementSets",
      value: function _renderEmptyElementSets() {
        IncrementalDOM.elementOpen("div", null, null, "class", "list-group-body  list-group");
        IncrementalDOM.elementOpen("div", null, null, "class", "main-content-body");
        IncrementalDOM.elementOpen("div", null, null, "class", "text-center text-muted");
        IncrementalDOM.elementOpen("p", null, null, "class", "text-default");
        iDOMHelpers.renderArbitrary(Liferay.Language.get('there-are-no-element-sets-yet'));
        IncrementalDOM.elementClose("p");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("div");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_renderFieldTypeDropdownLabel",
      value: function _renderFieldTypeDropdownLabel() {
        var _this$props7 = this.props,
            fieldTypes = _this$props7.fieldTypes,
            focusedField = _this$props7.focusedField,
            spritemap = _this$props7.spritemap;

        var _fieldTypes$find = fieldTypes.find(function (_ref9) {
          var name = _ref9.name;
          return name === focusedField.type;
        }),
            icon = _fieldTypes$find.icon,
            label = _fieldTypes$find.label;

        IncrementalDOM.elementOpen(_metalJsx.Fragment);
        IncrementalDOM.elementVoid(_clayIcon.ClayIcon, null, null, "spritemap", spritemap, "symbol", icon, "elementClasses", 'inline-item inline-item-before');
        iDOMHelpers.renderArbitrary(label);
        IncrementalDOM.elementVoid(_clayIcon.ClayIcon, null, null, "spritemap", spritemap, "elementClasses", 'inline-item inline-item-after', "symbol", 'caret-bottom');
        return IncrementalDOM.elementClose(_metalJsx.Fragment);
      }
    }, {
      key: "_renderFieldTypeGroups",
      value: function _renderFieldTypeGroups() {
        var spritemap = this.props.spritemap;
        var fieldTypesGroup = this.state.fieldTypesGroup;
        var group = Object.keys(fieldTypesGroup);
        IncrementalDOM.elementOpen("div", null, null, "aria-orientation", "vertical", "class", "ddm-field-types-panel panel-group", "id", "accordion03", "role", "tablist");
        iDOMHelpers.renderArbitrary(group.map(function (key, index) {
          return iDOMHelpers.jsxWrapper(function (_fieldsGroup$concat, _ddmFieldTypes$co2, _ddmFieldTypes$con2, _fieldTypesGroup$key$, _$concat, _$concat2, _ddmFieldTypes$co3, _ddmFieldTypes$con3, _fieldTypesGroup$key$2) {
            IncrementalDOM.elementOpen("div", _fieldsGroup$concat, ["class", "panel panel-secondary", "key", _fieldsGroup$concat]);
            IncrementalDOM.elementOpen("a", null, null, "href", _ddmFieldTypes$co2, "id", _ddmFieldTypes$con2, "aria-controls", "collapseTwo", "aria-expanded", "true", "class", "collapse-icon panel-header panel-header-link", "data-parent", "#accordion03", "data-toggle", "collapse", "role", "tab");
            IncrementalDOM.elementOpen("span", null, null, "class", "panel-title");
            iDOMHelpers.renderArbitrary(_fieldTypesGroup$key$);
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementOpen("span", null, null, "class", "collapse-icon-closed");
            IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-angle-right");
            IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat);
            IncrementalDOM.elementClose("svg");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementOpen("span", null, null, "class", "collapse-icon-open");
            IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-angle-down");
            IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat2);
            IncrementalDOM.elementClose("svg");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("a");
            IncrementalDOM.elementOpen("div", null, null, "aria-labelledby", _ddmFieldTypes$co3, "id", _ddmFieldTypes$con3, "class", "panel-collapse show", "role", "tabpanel");
            IncrementalDOM.elementOpen("div", null, null, "class", "panel-body p-0 m-0 list-group");
            iDOMHelpers.renderArbitrary(_fieldTypesGroup$key$2);
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementClose("div");
            return IncrementalDOM.elementClose("div");
          }, ["fields-group-".concat(key, "-").concat(index), "#ddm-field-types-".concat(key, "-body"), "ddm-field-types-".concat(key, "-header"), fieldTypesGroup[key].label, "".concat(spritemap, "#angle-right"), "".concat(spritemap, "#angle-down"), "#ddm-field-types-".concat(key, "-header"), "ddm-field-types-".concat(key, "-body"), fieldTypesGroup[key].fields.map(function (fieldType) {
            return iDOMHelpers.jsxWrapper(function (_fieldType, _fieldType$name, _spritemap) {
              return IncrementalDOM.elementVoid(_FieldTypeBoxEs.default, _fieldType$name, ["key", _fieldType$name], "fieldType", _fieldType, "spritemap", _spritemap);
            }, [fieldType, fieldType.name, spritemap]);
          })]);
        }));
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_renderNavItems",
      value: function _renderNavItems() {
        var _this5 = this;

        var _this$state2 = this.state,
            activeTab = _this$state2.activeTab,
            tabs = _this$state2.tabs;
        return tabs[this._isEditMode() ? 'edit' : 'add'].items.map(function (name, index) {
          var _tab$concat;

          var style = (0, _classnames.default)('nav-link', {
            active: index === activeTab
          });
          IncrementalDOM.elementOpen("li", _tab$concat = "tab".concat(index), ["class", "nav-item", "key", _tab$concat], "data-index", index, "data-onclick", _this5._handleTabItemClicked, "ref", "tab".concat(index));
          IncrementalDOM.elementOpen("a", null, null, "class", style, "aria-controls", "sidebarLightDetails", "data-toggle", "tab", "href", "javascript:;", "role", "tab");
          IncrementalDOM.elementOpen("span", null, null, "class", "navbar-text-truncate");
          iDOMHelpers.renderArbitrary(name);
          IncrementalDOM.elementClose("span");
          IncrementalDOM.elementClose("a");
          return IncrementalDOM.elementClose("li");
        });
      }
    }, {
      key: "_renderTopBar",
      value: function _renderTopBar() {
        var _this$props8 = this.props,
            fieldTypes = _this$props8.fieldTypes,
            focusedField = _this$props8.focusedField,
            spritemap = _this$props8.spritemap;

        var editMode = this._isEditMode();

        var fieldActions = [{
          disabled: this.isActionsDisabled(),
          label: Liferay.Language.get('duplicate-field'),
          settingsItem: 'duplicate-field'
        }, {
          disabled: this.isActionsDisabled(),
          label: Liferay.Language.get('remove-field'),
          settingsItem: 'delete-field'
        }, {
          label: Liferay.Language.get('cancel-field-changes'),
          settingsItem: 'cancel-field-changes'
        }];
        var focusedFieldType = fieldTypes.find(function (_ref10) {
          var name = _ref10.name;
          return name === focusedField.type;
        });
        var previousButtonEvents = {
          click: this._handlePreviousButtonClicked
        };
        IncrementalDOM.elementOpen("ul", null, null, "class", "tbar-nav");
        iDOMHelpers.renderArbitrary(!editMode && (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item tbar-item-expand text-left"), (IncrementalDOM.elementOpen("div", null, null, "class", "tbar-section"), (IncrementalDOM.elementOpen("span", null, null, "class", "text-truncate-inline"), (IncrementalDOM.elementOpen("span", null, null, "class", "text-truncate"), iDOMHelpers.renderArbitrary(Liferay.Language.get('add-elements')), IncrementalDOM.elementClose("span")), IncrementalDOM.elementClose("span")), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("li")));
        iDOMHelpers.renderArbitrary(editMode && (IncrementalDOM.elementOpen(_metalJsx.Fragment), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item"), IncrementalDOM.elementVoid(_clayButton.default, null, null, "disabled", this.isActionsDisabled(), "events", previousButtonEvents, "spritemap", spritemap, "icon", "angle-left", "ref", "previousButton", "size", "sm", "style", "secondary"), IncrementalDOM.elementClose("li")), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item ddm-fieldtypes-dropdown tbar-item-expand text-left"), (IncrementalDOM.elementOpen("div"), IncrementalDOM.elementVoid(_clayDropdown.ClayDropdownBase, null, null, "disabled", !this.isChangeFieldTypeEnabled(), "events", {
          itemClicked: this._handleChangeFieldTypeItemClicked
        }, "icon", focusedFieldType.icon, "items", this.state.dropdownFieldTypes, "label", this._renderFieldTypeDropdownLabel, "spritemap", spritemap, "itemsIconAlignment", 'left', "style", 'secondary', "triggerClasses", 'nav-link btn-sm'), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("li")), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item"), IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "events", {
          itemClicked: this._handleFieldSettingsClicked
        }, "items", fieldActions, "spritemap", spritemap, "ref", "fieldSettingsActions", "triggerClasses", 'component-action'), IncrementalDOM.elementClose("li")), IncrementalDOM.elementClose(_metalJsx.Fragment)));
        IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item");
        IncrementalDOM.elementOpen("a", null, null, "data-onclick", this._handleCloseButtonClicked, "class", "component-action sidebar-close", "href", "#1", "ref", "closeButton", "role", "button");
        IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-times");
        IncrementalDOM.elementVoid("use", null, null, "xlink:href", "".concat(spritemap, "#times"));
        IncrementalDOM.elementClose("svg");
        IncrementalDOM.elementClose("a");
        IncrementalDOM.elementClose("li");
        return IncrementalDOM.elementClose("ul");
      }
    }]);

    return Sidebar;
  }(_metalJsx.default);

  _defineProperty(Sidebar, "STATE", {
    /**
     * @default 0
     * @instance
     * @memberof Sidebar
     * @type {?number}
     */
    activeTab: _metalState.Config.number().value(0).internal(),

    /**
     * @default _dropdownFieldTypesValueFn
     * @instance
     * @memberof Sidebar
     * @type {?array}
     */
    dropdownFieldTypes: _metalState.Config.array().valueFn('_dropdownFieldTypesValueFn'),

    /**
     * @instance
     * @memberof Sidebar
     * @type {array}
     */
    fieldTypesGroup: _metalState.Config.object().valueFn('_fieldTypesGroupValueFn'),

    /**
     * @default false
     * @instance
     * @memberof Sidebar
     * @type {?bool}
     */
    open: _metalState.Config.bool().valueFn('_openValueFn'),

    /**
     * @default object
     * @instance
     * @memberof Sidebar
     * @type {?object}
     */
    tabs: _metalState.Config.object().value({
      add: {
        items: [Liferay.Language.get('elements'), Liferay.Language.get('element-sets')]
      },
      edit: {
        items: [Liferay.Language.get('basic'), Liferay.Language.get('properties')]
      }
    }).internal()
  });

  _defineProperty(Sidebar, "PROPS", {
    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?string}
     */
    defaultLanguageId: _metalState.Config.string(),

    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?string}
     */
    editingLanguageId: _metalState.Config.string(),

    /**
     * @default []
     * @instance
     * @memberof Sidebar
     * @type {?(array|undefined)}
     */
    fieldTypes: _metalState.Config.array().value([]),

    /**
     * @default {}
     * @instance
     * @memberof Sidebar
     * @type {?object}
     */
    focusedField: _config.focusedFieldStructure.value({}),

    /**
     * @default false
     * @instance
     * @memberof Sidebar
     * @type {?bool}
     */
    open: _metalState.Config.bool().value(false),

    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string().required()
  });

  var _default = Sidebar;
  exports.default = _default;
  //# sourceMappingURL=Sidebar.es.js.map
});
//# sourceMappingURL=Sidebar.es.js.map