"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.9/js/components/RuleList/RuleList.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', './RuleList.soy', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-events', '../LayoutProvider/util/fields.es', '../../util/pageSupport.es', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-dropdown");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _RuleListSoy = _interopRequireDefault(require("./RuleList.soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _fields = require("../LayoutProvider/util/fields.es");

  var _pageSupport = require("../../util/pageSupport.es");

  var _visitors = require("../../util/visitors.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * RuleList.
   * @extends Component
   */
  var RuleList =
  /*#__PURE__*/
  function (_Component) {
    _inherits(RuleList, _Component);

    function RuleList() {
      _classCallCheck(this, RuleList);

      return _possibleConstructorReturn(this, _getPrototypeOf(RuleList).apply(this, arguments));
    }

    _createClass(RuleList, [{
      key: "attached",
      value: function attached() {
        this._eventHandler = new _metalEvents.EventHandler();

        this._eventHandler.add(_metalDom.default.on(document, 'mouseup', this._handleDocumentMouseUp.bind(this), true));
      }
    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(RuleList.prototype), "disposeInternal", this).call(this);

        this._eventHandler.removeAllListeners();
      }
    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(states) {
        var _this = this;

        var pages = this.pages;

        var rules = this._setDataProviderNames(states);

        return _objectSpread({}, states, {
          rules: rules.map(function (rule) {
            var logicalOperator;

            if (rule['logical-operator']) {
              logicalOperator = rule['logical-operator'].toLowerCase();
            } else if (rule.logicalOperator) {
              logicalOperator = rule.logicalOperator.toLowerCase();
            }

            return _objectSpread({}, rule, {
              actions: rule.actions.map(function (action) {
                var newAction = '';

                if (action.action === 'auto-fill') {
                  var _action = action,
                      inputs = _action.inputs,
                      outputs = _action.outputs;
                  var inputLabel = Object.values(inputs).map(function (input) {
                    return _this._getFieldLabel(input);
                  });
                  var outputLabel = Object.values(outputs).map(function (output) {
                    return _this._getFieldLabel(output);
                  });
                  action = _objectSpread({}, action, {
                    inputLabel: inputLabel,
                    outputLabel: outputLabel
                  });
                }

                var fieldLabel = _this._getFieldLabel(action.target);

                if (action.action == 'jump-to-page') {
                  var fieldTarget = (parseInt(action.target, 10) + 1).toString();

                  if (action.label) {
                    fieldLabel = action.label;
                  } else {
                    var maxPageIndexRes = (0, _pageSupport.maxPageIndex)(rule.conditions, pages);
                    var pageOptionsList = (0, _pageSupport.pageOptions)(pages, maxPageIndexRes);
                    var selectedPage = pageOptionsList.find(function (option) {
                      return option.value == fieldTarget;
                    });
                    fieldLabel = selectedPage.label;
                  }

                  newAction = _objectSpread({}, action, {
                    label: fieldLabel,
                    target: fieldTarget
                  });
                } else {
                  newAction = _objectSpread({}, action, {
                    label: fieldLabel,
                    target: fieldLabel
                  });
                }

                return newAction;
              }),
              conditions: rule.conditions.map(function (condition) {
                if (condition.operands.length < 2 && condition.operands[0].type === 'list') {
                  condition.operands = [{
                    label: 'user',
                    repeatable: false,
                    type: 'user',
                    value: 'user'
                  }, _objectSpread({}, condition.operands[0], {
                    label: condition.operands[0].value
                  })];
                }

                return _objectSpread({}, condition, {
                  operands: condition.operands.map(function (operand, index) {
                    var label = _this._getOperandLabel(condition.operands, index);

                    return _objectSpread({}, operand, {
                      label: label,
                      value: label
                    });
                  })
                });
              }),
              logicalOperator: logicalOperator
            });
          }),
          rulesCardOptions: this._getRulesCardOptions()
        });
      }
    }, {
      key: "_getDataProviderName",
      value: function _getDataProviderName(id) {
        var dataProvider = this.dataProvider;
        return dataProvider.find(function (data) {
          return data.uuid == id;
        }).label;
      }
    }, {
      key: "_getFieldLabel",
      value: function _getFieldLabel(fieldName) {
        var pages = this.pages;
        return (0, _fields.getFieldProperty)(pages, fieldName, 'label');
      }
    }, {
      key: "_getFieldType",
      value: function _getFieldType(fieldName) {
        var pages = this.pages;
        return (0, _fields.getFieldProperty)(pages, fieldName, 'type');
      }
    }, {
      key: "_getOperandLabel",
      value: function _getOperandLabel(operands, index) {
        var label = '';
        var operand = operands[index];

        if (operand.type === 'field') {
          label = this._getFieldLabel(operand.value);
        } else if (operand.type === 'user') {
          label = Liferay.Language.get('user');
        } else if (operand.type !== 'field') {
          var fieldType = this._getFieldType(operands[0].value);

          if (fieldType == 'select' || fieldType === 'radio') {
            label = this._getOptionLabel(operands[0].value, operand.value);
          } else {
            label = operand.value;
          }
        } else {
          label = operand.value;
        }

        return label;
      }
    }, {
      key: "_getOptionLabel",
      value: function _getOptionLabel(fieldName, optionValue) {
        var pages = this.pages;
        var fieldLabel = null;

        if (pages && optionValue) {
          var visitor = new _visitors.PagesVisitor(pages);
          visitor.findField(function (field) {
            var found = false;

            if (field.fieldName === fieldName && field.options) {
              field.options.some(function (option) {
                if (option.value == optionValue) {
                  fieldLabel = option.label;
                  found = true;
                }

                return found;
              });
            }

            return found;
          });
        }

        return fieldLabel;
      }
    }, {
      key: "_getRulesCardOptions",
      value: function _getRulesCardOptions() {
        var rulesCardOptions = [{
          'label': Liferay.Language.get('edit'),
          'settingsItem': 'edit'
        }, {
          'label': Liferay.Language.get('delete'),
          'settingsItem': 'delete'
        }];
        return rulesCardOptions;
      }
    }, {
      key: "_handleDocumentMouseUp",
      value: function _handleDocumentMouseUp(_ref) {
        var target = _ref.target;

        var dropdownSettings = _metalDom.default.closest(target, '.ddm-rule-list-settings');

        if (dropdownSettings) {
          return;
        }

        this.setState({
          dropdownExpandedIndex: -1
        });
      }
    }, {
      key: "_handleDropdownClicked",
      value: function _handleDropdownClicked(event) {
        event.preventDefault();
        var dropdownExpandedIndex = this.dropdownExpandedIndex;

        var ruleNode = _metalDom.default.closest(event.delegateTarget, '.component-action');

        var ruleIndex = parseInt(ruleNode.dataset.ruleIndex, 10);

        if (ruleIndex === dropdownExpandedIndex) {
          ruleIndex = -1;
        }

        this.setState({
          dropdownExpandedIndex: ruleIndex
        });
      }
    }, {
      key: "_handleRuleCardClicked",
      value: function _handleRuleCardClicked(_ref2) {
        var data = _ref2.data,
            target = _ref2.target;
        var cardElement = target.element.closest('[data-card-id]');
        var cardId = parseInt(cardElement.getAttribute('data-card-id'), 10);

        if (data.item.settingsItem == 'edit') {
          this.emit('ruleEdited', {
            ruleId: cardId
          });
        } else if (data.item.settingsItem == 'delete') {
          this.emit('ruleDeleted', {
            ruleId: cardId
          });
        }
      }
    }, {
      key: "_setDataProviderNames",
      value: function _setDataProviderNames(states) {
        var _this2 = this;

        var rules = states.rules;

        if (this.dataProvider) {
          for (var rule = 0; rule < rules.length; rule++) {
            var actions = rules[rule].actions;
            actions.forEach(function (action) {
              if (action.action === 'auto-fill') {
                var dataProviderName = _this2._getDataProviderName(action.ddmDataProviderInstanceUUID);

                action.dataProviderName = dataProviderName;
              }
            });
          }
        }

        return rules;
      }
    }]);

    return RuleList;
  }(_metalComponent.default);

  _defineProperty(RuleList, "STATE", {
    dataProvider: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string(),
      name: _metalState.Config.string(),
      uuid: _metalState.Config.string()
    })),
    dropdownExpandedIndex: _metalState.Config.number().internal(),
    pages: _metalState.Config.array().required(),
    roles: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string(),
      name: _metalState.Config.string()
    })).value([]),

    /**
     * @default 0
     * @instance
     * @memberof RuleList
     * @type {?array}
     */
    rules: _metalState.Config.arrayOf(_metalState.Config.shapeOf(_defineProperty({
      actions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        action: _metalState.Config.string(),
        ddmDataProviderInstanceUUID: _metalState.Config.string(),
        expression: _metalState.Config.string(),
        inputs: _metalState.Config.object(),
        label: _metalState.Config.string(),
        outputs: _metalState.Config.object(),
        target: _metalState.Config.string()
      })),
      conditions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        operands: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
          label: _metalState.Config.string(),
          repeatable: _metalState.Config.bool(),
          type: _metalState.Config.string(),
          value: _metalState.Config.string()
        })),
        operator: _metalState.Config.string()
      }))
    }, 'logical-operator', _metalState.Config.string()))).value([]),

    /**
     * @default undefined
     * @instance
     * @memberof RuleList
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * @default strings
     * @instance
     * @memberof RuleList
     * @type {!object}
     */
    strings: _metalState.Config.object().value({
      'belongs-to': Liferay.Language.get('belongs-to'),
      'calculate-field': Liferay.Language.get('calculate-field-x-as-x'),
      contains: Liferay.Language.get('contains'),
      'equals-to': Liferay.Language.get('is-equal-to'),
      'greater-than': Liferay.Language.get('is-greater-than'),
      'greater-than-equals': Liferay.Language.get('is-greater-than-or-equal-to'),
      'is-empty': Liferay.Language.get('is-empty'),
      'less-than': Liferay.Language.get('is-less-than'),
      'less-than-equals': Liferay.Language.get('is-less-than-or-equal-to'),
      'not-contains': Liferay.Language.get('does-not-contain'),
      'not-equals-to': Liferay.Language.get('is-not-equal-to'),
      'not-is-empty': Liferay.Language.get('is-not-empty')
    })
  });

  _metalSoy.default.register(RuleList, _RuleListSoy.default);

  var _default = RuleList;
  exports.default = _default;
  //# sourceMappingURL=RuleList.es.js.map
});
//# sourceMappingURL=RuleList.es.js.map