"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.9/js/components/LayoutProvider/util/fields.es", ['module', 'exports', 'require', '../../Form/FormSupport.es', '../../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.normalizeFieldName = normalizeFieldName;
  exports.updateFieldValidationProperty = exports.getField = exports.getFieldProperty = exports.getFieldValue = exports.checkInvalidFieldNameCharacter = exports.generateFieldName = void 0;

  var _FormSupport = require("../../Form/FormSupport.es");

  var _visitors = require("../../../util/visitors.es");

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var generateFieldName = function generateFieldName(pages, desiredName) {
    var currentName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var counter = 0;
    var name = normalizeFieldName(desiredName);
    var existingField = (0, _FormSupport.findFieldByName)(pages, name);

    while (existingField && existingField.fieldName !== currentName) {
      if (counter > 0) {
        name = normalizeFieldName(desiredName) + counter;
      }

      existingField = (0, _FormSupport.findFieldByName)(pages, name);
      counter++;
    }

    return normalizeFieldName(name);
  };

  exports.generateFieldName = generateFieldName;

  var checkInvalidFieldNameCharacter = function checkInvalidFieldNameCharacter(character) {
    return (/[\\~`!@#$%^&*(){}[\];:"'<,.>?/\-+=|]/g.test(character)
    );
  };

  exports.checkInvalidFieldNameCharacter = checkInvalidFieldNameCharacter;

  function normalizeFieldName(fieldName) {
    var nextUpperCase = false;
    var normalizedFieldName = '';
    fieldName = fieldName.trim();

    for (var i = 0; i < fieldName.length; i++) {
      var item = fieldName[i];

      if (item === ' ') {
        nextUpperCase = true;
        continue;
      } else if (checkInvalidFieldNameCharacter(item)) {
        continue;
      }

      if (nextUpperCase) {
        item = item.toUpperCase();
        nextUpperCase = false;
      }

      normalizedFieldName += item;
    }

    if (/^\d/.test(normalizedFieldName)) {
      normalizedFieldName = "_".concat(normalizedFieldName);
    }

    return normalizedFieldName;
  }

  var getFieldValue = function getFieldValue(pages, fieldName) {
    return getFieldProperty(pages, fieldName, 'value');
  };

  exports.getFieldValue = getFieldValue;

  var getFieldProperty = function getFieldProperty(pages, fieldName, propertyName) {
    var visitor = new _visitors.PagesVisitor(pages);
    var propertyValue;
    visitor.mapFields(function (field) {
      if (field.fieldName === fieldName) {
        propertyValue = field[propertyName];
      }
    });
    return propertyValue;
  };

  exports.getFieldProperty = getFieldProperty;

  var getField = function getField(pages, fieldName) {
    var visitor = new _visitors.PagesVisitor(pages);
    var field;
    visitor.mapFields(function (currentField) {
      if (currentField.fieldName === fieldName) {
        field = currentField;
      }
    });
    return field;
  };

  exports.getField = getField;

  var updateFieldValidationProperty = function updateFieldValidationProperty(pages, fieldName, propertyName, propertyValue) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapFields(function (field) {
      if (field.fieldName === 'validation' && field.value) {
        var expression = field.value.expression;

        if (propertyName === 'fieldName' && expression) {
          expression = expression.replace(fieldName, propertyValue);
        }

        field = _objectSpread({}, field, {
          validation: _objectSpread({}, field.validation, _defineProperty({}, propertyName, propertyValue)),
          value: _objectSpread({}, field.value, {
            expression: expression
          })
        });
      }

      return field;
    });
  };

  exports.updateFieldValidationProperty = updateFieldValidationProperty;
  //# sourceMappingURL=fields.es.js.map
});
//# sourceMappingURL=fields.es.js.map