"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.9/js/components/Form/Evaluator.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../util/fetch.es', 'frontend-js-metal-web$metal-debounce', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _fetch = require("../../util/fetch.es");

  var _metalDebounce = require("frontend-js-metal-web$metal-debounce");

  var _visitors = require("../../util/visitors.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var WithEvaluator = function WithEvaluator(ChildComponent) {
    /**
     * FormRenderer.
     * @extends Component
     */
    var Evaluator =
    /*#__PURE__*/
    function (_Component) {
      _inherits(Evaluator, _Component);

      function Evaluator() {
        _classCallCheck(this, Evaluator);

        return _possibleConstructorReturn(this, _getPrototypeOf(Evaluator).apply(this, arguments));
      }

      _createClass(Evaluator, [{
        key: "attached",
        value: function attached() {
          this.evaluate();
        }
      }, {
        key: "created",
        value: function created() {
          this.evaluate = (0, _metalDebounce.debounce)(this.evaluate.bind(this), 300);
        }
      }, {
        key: "evaluate",
        value: function evaluate(fieldInstance) {
          var _this = this;

          if (!this.isDisposed()) {
            var _this$props = this.props,
                editingLanguageId = _this$props.editingLanguageId,
                formContext = _this$props.formContext,
                url = _this$props.url;
            var pages = this.state.pages;
            var fieldName;

            if (fieldInstance && !fieldInstance.isDisposed()) {
              fieldName = fieldInstance.fieldName;
            }

            (0, _fetch.makeFetch)({
              body: (0, _fetch.convertToSearchParams)({
                languageId: editingLanguageId,
                p_auth: Liferay.authToken,
                serializedFormContext: JSON.stringify(formContext),
                trigger: fieldName
              }),
              url: url
            }).then(function (newPages) {
              var mergedPages = _this._mergePages(pages, newPages);

              if (!_this.isDisposed()) {
                _this.emit('evaluated', mergedPages);
              }
            });
          }
        }
      }, {
        key: "render",
        value: function render() {
          var pages = this.state.pages;
          var _this$props2 = this.props,
              editingLanguageId = _this$props2.editingLanguageId,
              events = _this$props2.events;
          IncrementalDOM.elementOpenStart(ChildComponent);
          iDOMHelpers.forOwn(this.props, iDOMHelpers.attr);
          IncrementalDOM.attr("editingLanguageId", editingLanguageId);
          IncrementalDOM.attr("events", _objectSpread({}, events, {
            fieldEdited: this._handleFieldEdited.bind(this)
          }));
          IncrementalDOM.attr("pages", pages);
          IncrementalDOM.elementOpenEnd(ChildComponent);
          return IncrementalDOM.elementClose(ChildComponent);
        }
      }, {
        key: "willReceiveProps",
        value: function willReceiveProps(props) {
          var formContext = props.formContext;

          if (formContext && Object.keys(formContext.newVal).length) {
            this.setState({
              pages: formContext.newVal.pages
            });
          }
        }
      }, {
        key: "_handleFieldEdited",
        value: function _handleFieldEdited(event) {
          var fieldInstance = event.fieldInstance;
          var evaluable = fieldInstance.evaluable;

          if (evaluable) {
            this.evaluate(fieldInstance);
          }

          this.emit('fieldEdited', event);
        }
      }, {
        key: "_mergeFieldOptions",
        value: function _mergeFieldOptions(field, newField) {
          var newValue = _objectSpread({}, newField.value);

          var _loop = function _loop(languageId) {
            newValue = _objectSpread({}, newValue, _defineProperty({}, languageId, newValue[languageId].map(function (option) {
              var existingOption = field.value[languageId].find(function (_ref) {
                var value = _ref.value;
                return value === option.value;
              });
              return _objectSpread({}, option, {
                edited: existingOption && existingOption.edited
              });
            })));
          };

          for (var languageId in newValue) {
            _loop(languageId);
          }

          return newValue;
        }
      }, {
        key: "_mergePages",
        value: function _mergePages(sourcePages, newPages) {
          var _this2 = this;

          var _this$props3 = this.props,
              defaultLanguageId = _this$props3.defaultLanguageId,
              editingLanguageId = _this$props3.editingLanguageId;
          var visitor = new _visitors.PagesVisitor(sourcePages);
          return visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
            var newField = _objectSpread({}, field, newPages[pageIndex].rows[rowIndex].columns[columnIndex].fields[fieldIndex], {
              defaultLanguageId: defaultLanguageId,
              editingLanguageId: editingLanguageId
            });

            if (newField.fieldName === 'name') {
              newField = _objectSpread({}, newField, {
                visible: true
              });
            }

            if (newField.type === 'options') {
              newField = _objectSpread({}, newField, {
                value: _this2._mergeFieldOptions(field, newField)
              });
            }

            if (field.localizable) {
              newField = _objectSpread({}, newField, {
                localizedValue: _objectSpread({}, field.localizedValue, newField.localizedValue || {})
              });
            }

            return newField;
          });
        }
      }, {
        key: "_pagesValueFn",
        value: function _pagesValueFn() {
          var formContext = this.props.formContext;
          return formContext.pages;
        }
      }]);

      return Evaluator;
    }(_metalJsx.default);

    _defineProperty(Evaluator, "PROPS", {
      /**
       * @default
       * @instance
       * @memberof FormBuilder
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default undefined
       * @memberof Evaluator
       * @type {string}
       * @required
       */
      defaultLanguageId: _metalState.Config.string(),
      editable: _metalState.Config.bool().value(false),

      /**
       * @default undefined
       * @memberof Evaluator
       * @type {string}
       * @required
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @memberof Evaluator
       * @type {string}
       * @required
       */
      fieldType: _metalState.Config.string().required(),

      /**
       * @default undefined
       * @memberof Evaluator
       * @type {object}
       * @required
       */
      formContext: _metalState.Config.object().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      paginationMode: _metalState.Config.string().required(),

      /**
       * @default undefined
       * @instance
       * @memberof FormRenderer
       * @type {!string}
       */
      spritemap: _metalState.Config.string().required(),

      /**
       * @default undefined
       * @memberof Evaluator
       * @type {string}
       * @required
       */
      url: _metalState.Config.string()
    });

    _defineProperty(Evaluator, "STATE", {
      pages: _metalState.Config.array().valueFn('_pagesValueFn')
    });

    return Evaluator;
  };

  var _default = WithEvaluator;
  exports.default = _default;
  //# sourceMappingURL=Evaluator.es.js.map
});
//# sourceMappingURL=Evaluator.es.js.map