/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter.model;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSON;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author Marcellus Tavares
 */
public class DDMFormRule {

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof DDMFormRule)) {
			return false;
		}

		DDMFormRule ddmFormRule = (DDMFormRule)obj;

		if (Objects.equals(
				_ddmFormRuleActions, ddmFormRule._ddmFormRuleActions) &&
			Objects.equals(
				_ddmFormRuleConditions, ddmFormRule._ddmFormRuleConditions) &&
			Objects.equals(_logicalOperator, ddmFormRule._logicalOperator)) {

			return true;
		}

		return false;
	}

	@JSON(name = "actions")
	public List<DDMFormRuleAction> getDDMFormRuleActions() {
		return _ddmFormRuleActions;
	}

	@JSON(name = "conditions")
	public List<DDMFormRuleCondition> getDDMFormRuleConditions() {
		return _ddmFormRuleConditions;
	}

	@JSON(name = "logical-operator")
	public String getLogicalOperator() {
		return _logicalOperator;
	}

	@Override
	public int hashCode() {
		int hash = HashUtil.hash(0, _ddmFormRuleActions);

		hash = HashUtil.hash(hash, _ddmFormRuleConditions);

		return HashUtil.hash(hash, _logicalOperator);
	}

	public void setDDMFormRuleActions(
		List<DDMFormRuleAction> ddmFormRuleActions) {

		_ddmFormRuleActions = ddmFormRuleActions;
	}

	public void setDDMFormRuleConditions(
		List<DDMFormRuleCondition> ddmFormRuleConditions) {

		_ddmFormRuleConditions = ddmFormRuleConditions;
	}

	public void setLogicalOperator(String logicalOperator) {
		_logicalOperator = logicalOperator;
	}

	private List<DDMFormRuleAction> _ddmFormRuleActions = new ArrayList<>();
	private List<DDMFormRuleCondition> _ddmFormRuleConditions =
		new ArrayList<>();
	private String _logicalOperator = "AND";

}