/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {Config} from 'metal-state';

export const pageStructure = Config.shapeOf({
	description: Config.string(),
	rows: Config.arrayOf(
		Config.shapeOf({
			columns: Config.arrayOf(
				Config.shapeOf({
					fields: Config.array(),
					size: Config.number()
				})
			)
		})
	),
	title: Config.string()
});

export const focusedFieldStructure = Config.shapeOf({
	columnIndex: Config.number(),
	name: Config.string().required(),
	pageIndex: Config.number(),
	rowIndex: Config.number()
});

export const ruleStructure = Config.shapeOf({
	actions: Config.arrayOf(
		Config.shapeOf({
			action: Config.string(),
			label: Config.string(),
			target: Config.string()
		})
	),
	conditions: Config.arrayOf(
		Config.shapeOf({
			operands: Config.arrayOf(
				Config.shapeOf({
					label: Config.string(),
					repeatable: Config.bool(),
					type: Config.string(),
					value: Config.string()
				})
			),
			operator: Config.string()
		})
	),
	logicalOperator: Config.string()
});
