Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.70/js/components/LayoutProvider/handlers/languageIdDeletedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleLanguageIdDeleted = void 0;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var deleteLanguageId = function deleteLanguageId(languageId, pages) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapFields(function (field) {
      var localizedValue = field.localizedValue;

      var newLocalizedValue = _objectSpread({}, localizedValue);

      delete newLocalizedValue[languageId];
      return _objectSpread({}, field, {
        localizedValue: newLocalizedValue
      });
    });
  };

  var handleLanguageIdDeleted = function handleLanguageIdDeleted(focusedField, pages, languageId) {
    if (focusedField.settingsContext) {
      focusedField = _objectSpread({}, focusedField, {
        settingsContext: _objectSpread({}, focusedField.settingsContext, {
          pages: deleteLanguageId(languageId, focusedField.settingsContext.pages)
        })
      });
    }

    var visitor = new _visitors.PagesVisitor(pages);
    pages = visitor.mapPages(function (page) {
      var localizedDescription = page.localizedDescription,
          localizedTitle = page.localizedTitle;
      delete localizedDescription[languageId];
      delete localizedTitle[languageId];
      return _objectSpread({}, page, {
        localizedDescription: localizedDescription,
        localizedTitle: localizedTitle
      });
    });
    visitor.setPages(pages);
    pages = visitor.mapFields(function (field) {
      var settingsContext = field.settingsContext;
      return _objectSpread({}, field, {
        settingsContext: _objectSpread({}, settingsContext, {
          pages: deleteLanguageId(languageId, settingsContext.pages)
        })
      });
    });
    return {
      focusedField: focusedField,
      pages: pages
    };
  };

  exports.handleLanguageIdDeleted = handleLanguageIdDeleted;
  var _default = handleLanguageIdDeleted;
  exports["default"] = _default;
  //# sourceMappingURL=languageIdDeletedHandler.es.js.map
});
//# sourceMappingURL=languageIdDeletedHandler.es.js.map