/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import Component from 'metal-component';
import Soy from 'metal-soy';
import {Config} from 'metal-state';

import {setValue} from '../../util/i18n.es';
import templates from './SuccessPage.soy';

class SuccessPage extends Component {
	prepareStateForRender(state) {
		const {editingLanguageId, successPageSettings} = this;
		const {body, title} = successPageSettings;

		return {
			...state,
			body: (body && body[editingLanguageId]) || '',
			title: (title && title[editingLanguageId]) || ''
		};
	}

	shouldUpdate(changes) {
		const {editingLanguageId} = changes;

		return (
			editingLanguageId &&
			editingLanguageId.newVal !== editingLanguageId.prevVal
		);
	}

	_handleSuccessPageUpdated(event) {
		const {dispatch, store} = this.context;
		const {editingLanguageId} = store.props;
		const {delegateTarget} = event;
		const {
			dataset: {setting},
			value
		} = delegateTarget;
		const {successPageSettings} = this;

		dispatch(
			'successPageChanged',
			setValue(successPageSettings, editingLanguageId, setting, value)
		);
	}
}

SuccessPage.STATE = {
	editingLanguageId: Config.string(),

	/**
	 * @instance
	 * @memberof SuccessPage
	 * @type {?object}
	 */

	successPageSettings: Config.object().value({
		body: {},
		title: {}
	})
};

Soy.register(SuccessPage, templates);

export default SuccessPage;
