Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.53/js/components/Sidebar/Sidebar.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-dropdown', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-modal', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/containers/Form/Form.es', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../util/config.es', '../../util/dom.es', '../../util/fieldSupport.es', '../FieldTypeBox/FieldTypeBox.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _clayButton = _interopRequireDefault(require("frontend-taglib-clay$clay-button"));

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _clayIcon = require("frontend-taglib-clay$clay-icon");

  var _clayModal = _interopRequireDefault(require("frontend-taglib-clay$clay-modal"));

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _Form = _interopRequireDefault(require("dynamic-data-mapping-form-renderer/js/containers/Form/Form.es"));

  var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _metalJsx = _interopRequireWildcard(require("frontend-js-metal-web$metal-jsx"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _config = require("../../util/config.es");

  var _dom = require("../../util/dom.es");

  var _fieldSupport = require("../../util/fieldSupport.es");

  var _FieldTypeBox = _interopRequireDefault(require("../FieldTypeBox/FieldTypeBox.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Sidebar is a tooling to mount forms.
   */
  var Sidebar = /*#__PURE__*/function (_Component) {
    _inherits(Sidebar, _Component);

    function Sidebar() {
      _classCallCheck(this, Sidebar);

      return _possibleConstructorReturn(this, _getPrototypeOf(Sidebar).apply(this, arguments));
    }

    _createClass(Sidebar, [{
      key: "attached",
      value: function attached() {
        this._bindDragAndDrop();

        this._eventHandler.add(_metalDom["default"].on(document, 'mousedown', this._handleDocumentMouseDown, true));
      }
    }, {
      key: "changeFieldType",
      value: function changeFieldType(type) {
        var _this$props = this.props,
            defaultLanguageId = _this$props.defaultLanguageId,
            editingLanguageId = _this$props.editingLanguageId,
            fieldTypes = _this$props.fieldTypes,
            focusedField = _this$props.focusedField;
        var dispatch = this.context.dispatch;
        var newFieldType = fieldTypes.find(function (_ref) {
          var name = _ref.name;
          return name === type;
        });

        var newSettingsContext = _objectSpread({}, newFieldType.settingsContext, {
          pages: (0, _fieldSupport.normalizeSettingsContextPages)(newFieldType.settingsContext.pages, editingLanguageId, newFieldType, focusedField.fieldName)
        });

        var settingsContext = focusedField.settingsContext;

        if (type !== focusedField.type) {
          settingsContext = this._mergeFieldTypeSettings(settingsContext, newSettingsContext);
        }

        dispatch('focusedFieldUpdated', _objectSpread({}, focusedField, {}, newFieldType, {}, (0, _fieldSupport.getFieldProperties)(settingsContext, defaultLanguageId, editingLanguageId), {
          settingsContext: settingsContext,
          type: newFieldType.name
        }));
      }
    }, {
      key: "close",
      value: function close() {
        this.setState({
          open: false
        });
      }
    }, {
      key: "created",
      value: function created() {
        this._eventHandler = new _metalEvents.EventHandler();

        var transitionEnd = this._getTransitionEndEvent();

        this.supportsTransitionEnd = transitionEnd !== false;
        this.transitionEnd = transitionEnd || 'transitionend';
        this._handleChangeFieldTypeItemClicked = this._handleChangeFieldTypeItemClicked.bind(this);
        this._handleCloseButtonClicked = this._handleCloseButtonClicked.bind(this);
        this._handleDocumentMouseDown = this._handleDocumentMouseDown.bind(this);
        this._handleDragEnded = this._handleDragEnded.bind(this);
        this._handleDragStarted = this._handleDragStarted.bind(this);
        this._handleEvaluatorChanged = this._handleEvaluatorChanged.bind(this);
        this._handleFieldSettingsClicked = this._handleFieldSettingsClicked.bind(this);
        this._handlePreviousButtonClicked = this._handlePreviousButtonClicked.bind(this);
        this._handleSettingsFieldBlurred = this._handleSettingsFieldBlurred.bind(this);
        this._handleSettingsFieldEdited = this._handleSettingsFieldEdited.bind(this);
        this._handleSettingsFormAttached = this._handleSettingsFormAttached.bind(this);
        this._handleTabItemClicked = this._handleTabItemClicked.bind(this);
        this._renderFieldTypeDropdownLabel = this._renderFieldTypeDropdownLabel.bind(this);
      }
    }, {
      key: "disposeDragAndDrop",
      value: function disposeDragAndDrop() {
        if (this._dragAndDrop) {
          this._dragAndDrop.dispose();
        }
      }
    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(Sidebar.prototype), "disposeInternal", this).call(this);

        this._eventHandler.removeAllListeners();

        this.disposeDragAndDrop();
      }
    }, {
      key: "getSettingsFormContext",
      value: function getSettingsFormContext() {
        var _this = this;

        var _this$props2 = this.props,
            defaultLanguageId = _this$props2.defaultLanguageId,
            editingLanguageId = _this$props2.editingLanguageId,
            focusedField = _this$props2.focusedField;
        var settingsContext = focusedField.settingsContext;
        var visitor = new _visitors.PagesVisitor(settingsContext.pages);
        return _objectSpread({}, settingsContext, {
          pages: visitor.mapFields(function (field) {
            return _objectSpread({}, field, {
              defaultLanguageId: defaultLanguageId,
              editingLanguageId: editingLanguageId,
              readOnly: _this.isFieldReadOnly(field)
            });
          })
        });
      }
    }, {
      key: "isActionsDisabled",
      value: function isActionsDisabled() {
        var _this$props3 = this.props,
            defaultLanguageId = _this$props3.defaultLanguageId,
            editingLanguageId = _this$props3.editingLanguageId;
        return defaultLanguageId !== editingLanguageId;
      }
    }, {
      key: "isChangeFieldTypeEnabled",
      value: function isChangeFieldTypeEnabled() {
        return !this.isActionsDisabled();
      }
    }, {
      key: "isFieldReadOnly",
      value: function isFieldReadOnly(_ref2) {
        var localizable = _ref2.localizable,
            type = _ref2.type;
        var _this$props4 = this.props,
            defaultLanguageId = _this$props4.defaultLanguageId,
            editingLanguageId = _this$props4.editingLanguageId;

        if (type === 'validation') {
          return false;
        }

        return defaultLanguageId !== editingLanguageId && !localizable;
      }
    }, {
      key: "open",
      value: function open() {
        var _this2 = this;

        var container = this.refs.container;
        var open = this.state.open;
        var transitionEnd = this.transitionEnd;

        if (open) {
          return;
        }

        _metalDom["default"].once(container, transitionEnd, function () {
          if (_this2._isEditMode()) {
            var firstInput = _this2.element.querySelector('input');

            if (firstInput && !container.contains(document.activeElement)) {
              firstInput.focus();
              (0, _dom.selectText)(firstInput);
            }
          }
        });

        this.setState({
          activeTab: 0,
          open: true
        });
        this.refreshDragAndDrop();
      }
    }, {
      key: "refreshDragAndDrop",
      value: function refreshDragAndDrop() {
        this._dragAndDrop.setState({
          targets: Liferay.Browser.isIe() ? this._dragAndDrop.setterTargetsFn_('.ddm-target') : '.ddm-target'
        });
      }
    }, {
      key: "render",
      value: function render() {
        var _this$state = this.state,
            activeTab = _this$state.activeTab,
            open = _this$state.open;
        var spritemap = this.props.spritemap;

        var editMode = this._isEditMode();

        var styles = (0, _classnames["default"])('sidebar-container', {
          open: open
        });
        IncrementalDOM.elementOpen("div");
        IncrementalDOM.elementOpen("div", null, null, "class", styles, "ref", "container");
        IncrementalDOM.elementOpen("div", null, null, "class", "sidebar sidebar-light");
        IncrementalDOM.elementOpen("nav", null, null, "class", "component-tbar tbar");
        IncrementalDOM.elementOpen("div", null, null, "class", "container-fluid");
        iDOMHelpers.renderArbitrary(this._renderTopBar());
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("nav");
        IncrementalDOM.elementOpen("nav", null, null, "class", "component-navigation-bar navbar navigation-bar navbar-collapse-absolute navbar-expand-md navbar-underline");
        IncrementalDOM.elementOpen("a", null, null, "aria-controls", "sidebarLightCollapse00", "aria-expanded", "false", "aria-label", "Toggle Navigation", "class", "collapsed navbar-toggler navbar-toggler-link", "data-toggle", "collapse", "href", "#sidebarLightCollapse00", "role", "button");
        IncrementalDOM.elementOpen("span", null, null, "class", "navbar-text-truncate");
        IncrementalDOM.text("Details");
        IncrementalDOM.elementClose("span");
        IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-caret-bottom");
        IncrementalDOM.elementVoid("use", null, null, "xlink:href", "".concat(spritemap, "#caret-bottom"));
        IncrementalDOM.elementClose("svg");
        IncrementalDOM.elementClose("a");
        IncrementalDOM.elementOpen("div", null, null, "class", "collapse navbar-collapse", "id", "sidebarLightCollapse00");
        IncrementalDOM.elementOpen("ul", null, null, "class", "nav navbar-nav", "role", "tablist");
        iDOMHelpers.renderArbitrary(this._renderNavItems());
        IncrementalDOM.elementClose("ul");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("nav");
        IncrementalDOM.elementOpen("div", null, null, "class", "ddm-sidebar-body");
        iDOMHelpers.renderArbitrary(!editMode && activeTab == 0 && this._renderFieldTypeGroups());
        iDOMHelpers.renderArbitrary(!editMode && activeTab == 1 && this._renderElementSets());
        iDOMHelpers.renderArbitrary(editMode && (IncrementalDOM.elementOpen("div", null, null, "class", "sidebar-body ddm-field-settings"), (IncrementalDOM.elementOpen("div", null, null, "class", "tab-content"), (IncrementalDOM.elementOpen("form"), iDOMHelpers.renderArbitrary(this._renderSettingsForm()), IncrementalDOM.elementClose("form")), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("div")));
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementVoid(_clayModal["default"], null, null, "body", Liferay.Language.get('are-you-sure-you-want-to-cancel'), "events", {
          clickButton: this._handleCancelChangesModalButtonClicked.bind(this)
        }, "footerButtons", [{
          alignment: 'right',
          label: Liferay.Language.get('dismiss'),
          style: 'primary',
          type: 'close'
        }, {
          alignment: 'right',
          label: Liferay.Language.get('yes-cancel'),
          style: 'primary',
          type: 'button'
        }], "spritemap", spritemap, "title", Liferay.Language.get('cancel-field-changes-question'), "ref", "cancelChangesModal", "size", "sm");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "syncEditingLanguageId",
      value: function syncEditingLanguageId() {
        var dispatch = this.context.dispatch;
        var evaluableForm = this.refs.evaluableForm;
        var focusedField = this.props.focusedField;

        if (evaluableForm) {
          evaluableForm.evaluate().then(function (pages) {
            dispatch('focusedFieldUpdated', _objectSpread({}, focusedField, {
              settingsContext: _objectSpread({}, focusedField.settingsContext, {
                pages: pages
              })
            }));
          })["catch"](function (error) {
            return dispatch('evaluationError', error);
          });
        }
      }
    }, {
      key: "syncVisible",
      value: function syncVisible(visible) {
        if (!visible) {
          this.dispatchFieldBlurred();
        }
      }
    }, {
      key: "_bindDragAndDrop",
      value: function _bindDragAndDrop() {
        this._dragAndDrop = new _metalDragDrop.DragDrop({
          container: document.body,
          dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
          sources: '.ddm-drag-item',
          targets: '.ddm-target',
          useShim: false
        });

        this._eventHandler.add(this._dragAndDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDragEnded), this._dragAndDrop.on(_metalDragDrop.Drag.Events.START, this._handleDragStarted));
      }
    }, {
      key: "_cancelFieldChanges",
      value: function _cancelFieldChanges() {
        var cancelChangesModal = this.refs.cancelChangesModal;
        cancelChangesModal.show();
      }
    }, {
      key: "_deleteField",
      value: function _deleteField(indexes) {
        var dispatch = this.context.dispatch;
        dispatch('fieldDeleted', {
          indexes: indexes
        });
      }
    }, {
      key: "dispatchFieldBlurred",
      value: function dispatchFieldBlurred() {
        var dispatch = this.context.dispatch;

        if (!this.isDisposed()) {
          dispatch('sidebarFieldBlurred');
        }
      }
    }, {
      key: "_dropdownFieldTypesValueFn",
      value: function _dropdownFieldTypesValueFn() {
        var fieldTypes = this.props.fieldTypes;
        return fieldTypes.filter(function (_ref3) {
          var system = _ref3.system;
          return !system;
        }).map(function (fieldType) {
          return _objectSpread({}, fieldType, {
            type: 'item'
          });
        });
      }
    }, {
      key: "_duplicateField",
      value: function _duplicateField(indexes) {
        var dispatch = this.context.dispatch;
        dispatch('fieldDuplicated', {
          indexes: indexes
        });
      }
    }, {
      key: "_fetchFieldSet",
      value: function _fetchFieldSet(fieldSetId) {
        var _this$props5 = this.props,
            editingLanguageId = _this$props5.editingLanguageId,
            fieldSetDefinitionURL = _this$props5.fieldSetDefinitionURL,
            groupId = _this$props5.groupId,
            portletNamespace = _this$props5.portletNamespace;
        return (0, _fetch.makeFetch)({
          method: 'GET',
          url: "".concat(fieldSetDefinitionURL, "?ddmStructureId=").concat(fieldSetId, "&languageId=").concat(editingLanguageId, "&portletNamespace=").concat(portletNamespace, "&scopeGroupId=").concat(groupId)
        }).then(function (_ref4) {
          var pages = _ref4.pages;
          return pages;
        })["catch"](function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "_fieldTypesGroupValueFn",
      value: function _fieldTypesGroupValueFn() {
        var fieldTypes = this.props.fieldTypes;
        var group = {
          basic: {
            fields: [],
            label: Liferay.Language.get('field-types-basic-elements')
          },
          customized: {
            fields: [],
            label: Liferay.Language.get('field-types-customized-elements')
          }
        };
        return fieldTypes.reduce(function (prev, next) {
          if (next.group && !next.system) {
            prev[next.group].fields.push(next);
          }

          return prev;
        }, group);
      }
    }, {
      key: "_getTabItems",
      value: function _getTabItems() {
        if (!this._isEditMode()) {
          return this.state.tabs;
        }

        var focusedField = this.props.focusedField;
        var settingsContext = focusedField.settingsContext;
        return settingsContext.pages.map(function (_ref5) {
          var title = _ref5.title;
          return title;
        });
      }
    }, {
      key: "_getTransitionEndEvent",
      value: function _getTransitionEndEvent() {
        var el = document.createElement('metalClayTransitionEnd');
        var transitionEndEvents = {
          MozTransition: 'transitionend',
          OTransition: 'oTransitionEnd otransitionend',
          WebkitTransition: 'webkitTransitionEnd',
          transition: 'transitionend'
        };
        var eventName = false;
        Object.keys(transitionEndEvents).some(function (name) {
          if (el.style[name] !== undefined) {
            eventName = transitionEndEvents[name];
            return true;
          }
        });
        return eventName;
      }
    }, {
      key: "_handleCancelChangesModalButtonClicked",
      value: function _handleCancelChangesModalButtonClicked(event) {
        var dispatch = this.context.dispatch;
        var target = event.target;
        var cancelChangesModal = this.refs.cancelChangesModal;
        event.stopPropagation();

        if (this._isOutsideModal(target)) {
          this.close();
        }

        cancelChangesModal.emit('hide');

        if (!event.target.classList.contains('close-modal')) {
          dispatch('fieldChangesCanceled', {});
        }
      }
    }, {
      key: "_handleChangeFieldTypeItemClicked",
      value: function _handleChangeFieldTypeItemClicked(_ref6) {
        var data = _ref6.data;
        var newFieldType = data.item.name;
        this.changeFieldType(newFieldType);
      }
    }, {
      key: "_handleCloseButtonClicked",
      value: function _handleCloseButtonClicked() {
        this.close();
      }
    }, {
      key: "_handleDocumentMouseDown",
      value: function _handleDocumentMouseDown(_ref7) {
        var _this3 = this;

        var target = _ref7.target;
        var transitionEnd = this.transitionEnd;
        var open = this.state.open;

        if (this._isCloseButton(target) || open && !this._isSidebarElement(target) && !this._isTranslationItem(target)) {
          this.close();

          _metalDom["default"].once(this.refs.container, transitionEnd, function () {
            return _this3.dispatchFieldBlurred();
          });

          if (!this._isModalElement(target)) {
            setTimeout(function () {
              return _this3.dispatchFieldBlurred();
            }, 500);
          }
        }
      }
    }, {
      key: "_handleDragEnded",
      value: function _handleDragEnded(data, event) {
        var dispatch = this.context.dispatch;
        event.preventDefault();

        if (!data.target) {
          return;
        }

        var fieldTypes = this.props.fieldTypes;
        var fieldSetId = data.source.dataset.fieldSetId;
        var indexes = FormSupport.getIndexes(data.target.parentElement);

        if (fieldSetId) {
          this._fetchFieldSet(fieldSetId).then(function (pages) {
            dispatch('fieldSetAdded', {
              data: data,
              fieldSetId: fieldSetId,
              fieldSetPages: pages,
              indexes: indexes
            });
          });
        } else {
          var fieldType = fieldTypes.find(function (_ref8) {
            var name = _ref8.name;
            return name === data.source.dataset.fieldTypeName;
          });
          var addedToPlaceholder = data.target.parentElement.parentElement.classList.contains('placeholder');
          dispatch('fieldAdded', {
            addedToPlaceholder: addedToPlaceholder,
            data: data,
            fieldType: _objectSpread({}, fieldType, {
              editable: true
            }),
            indexes: indexes
          });
        }
      }
    }, {
      key: "_handleDragStarted",
      value: function _handleDragStarted() {
        this.refreshDragAndDrop();
        this.close();
      }
    }, {
      key: "_handleEvaluatorChanged",
      value: function _handleEvaluatorChanged(pages) {
        var dispatch = this.context.dispatch;
        var focusedField = this.props.focusedField;
        dispatch('focusedFieldUpdated', _objectSpread({}, focusedField, {
          settingsContext: _objectSpread({}, focusedField.settingsContext, {
            pages: pages
          })
        }));
      }
    }, {
      key: "_handleFieldSettingsClicked",
      value: function _handleFieldSettingsClicked(_ref9) {
        var item = _ref9.data.item;
        var _this$props$focusedFi = this.props.focusedField,
            columnIndex = _this$props$focusedFi.columnIndex,
            pageIndex = _this$props$focusedFi.pageIndex,
            rowIndex = _this$props$focusedFi.rowIndex;
        var settingsItem = item.settingsItem;
        var indexes = {
          columnIndex: columnIndex,
          pageIndex: pageIndex,
          rowIndex: rowIndex
        };

        if (!item.disabled) {
          if (settingsItem === 'duplicate-field') {
            this._duplicateField(indexes);
          } else if (settingsItem === 'delete-field') {
            this._deleteField(indexes);
          } else if (settingsItem === 'cancel-field-changes') {
            this._cancelFieldChanges(indexes);
          }
        }
      }
    }, {
      key: "_handlePreviousButtonClicked",
      value: function _handlePreviousButtonClicked() {
        var _this4 = this;

        var transitionEnd = this.transitionEnd;
        this.close();

        _metalDom["default"].once(this.refs.container, transitionEnd, function () {
          _this4.dispatchFieldBlurred();

          _this4.open();
        });
      }
    }, {
      key: "_handleSettingsFieldBlurred",
      value: function _handleSettingsFieldBlurred(_ref10) {
        var fieldInstance = _ref10.fieldInstance,
            value = _ref10.value;
        var dispatch = this.context.dispatch;
        var editingLanguageId = this.props.editingLanguageId;
        var fieldName = fieldInstance.fieldName;
        dispatch('fieldBlurred', {
          editingLanguageId: editingLanguageId,
          propertyName: fieldName,
          propertyValue: value
        });
      }
    }, {
      key: "_handleSettingsFieldEdited",
      value: function _handleSettingsFieldEdited(_ref11) {
        var fieldInstance = _ref11.fieldInstance,
            value = _ref11.value;

        if (fieldInstance && !fieldInstance.isDisposed()) {
          var editingLanguageId = this.props.editingLanguageId;
          var fieldName = fieldInstance.fieldName;
          var dispatch = this.context.dispatch;
          dispatch('fieldEdited', {
            editingLanguageId: editingLanguageId,
            propertyName: fieldName,
            propertyValue: value
          });
        }
      }
    }, {
      key: "_handleSettingsFormAttached",
      value: function _handleSettingsFormAttached() {
        this.refs.evaluableForm.evaluate();
      }
    }, {
      key: "_handleTabItemClicked",
      value: function _handleTabItemClicked(event) {
        var target = event.target;

        var _dom$closest = _metalDom["default"].closest(target, '.nav-item'),
            index = _dom$closest.dataset.index;

        event.preventDefault();
        this.setState({
          activeTab: parseInt(index, 10)
        });
      }
    }, {
      key: "_isCloseButton",
      value: function _isCloseButton(node) {
        var closeButton = this.refs.closeButton;
        return closeButton.contains(node);
      }
    }, {
      key: "_isEditMode",
      value: function _isEditMode() {
        var focusedField = this.props.focusedField;
        return Object.keys(focusedField).length > 0;
      }
    }, {
      key: "_isModalElement",
      value: function _isModalElement(node) {
        return _metalDom["default"].closest(node, '.modal');
      }
    }, {
      key: "_isOutsideModal",
      value: function _isOutsideModal(node) {
        return !_metalDom["default"].closest(node, '.close-modal');
      }
    }, {
      key: "_isSettingsElement",
      value: function _isSettingsElement(target) {
        var fieldSettingsActions = this.refs.fieldSettingsActions;
        var dropdownPortal;

        if (fieldSettingsActions) {
          var dropdown = fieldSettingsActions.refs.dropdown;
          var portal = dropdown.refs.portal;
          dropdownPortal = portal.element.contains(target);
        }

        return dropdownPortal;
      }
    }, {
      key: "_isSidebarElement",
      value: function _isSidebarElement(node) {
        var element = this.element;

        var alloyEditorToolbarNode = _metalDom["default"].closest(node, '.ae-ui');

        var fieldColumnNode = _metalDom["default"].closest(node, '.col-ddm');

        var fieldTypesDropdownNode = _metalDom["default"].closest(node, '.dropdown-menu');

        return alloyEditorToolbarNode || fieldTypesDropdownNode || fieldColumnNode || element.contains(node) || this._isSettingsElement(node);
      }
    }, {
      key: "_isTranslationItem",
      value: function _isTranslationItem(node) {
        return !!_metalDom["default"].closest(node, '.lfr-translationmanager');
      }
    }, {
      key: "_mergeFieldTypeSettings",
      value: function _mergeFieldTypeSettings(oldSettingsContext, newSettingsContext) {
        var _this5 = this;

        var newVisitor = new _visitors.PagesVisitor(newSettingsContext.pages);
        var oldVisitor = new _visitors.PagesVisitor(oldSettingsContext.pages);
        var excludedFields = ['indexType', 'readOnly', 'type', 'validation'];

        var getPreviousField = function getPreviousField(_ref12) {
          var fieldName = _ref12.fieldName,
              type = _ref12.type;
          var field;
          oldVisitor.findField(function (oldField) {
            if (excludedFields.indexOf(fieldName) === -1 && oldField.fieldName === fieldName && oldField.type === type) {
              field = oldField;
            }

            return field;
          });
          return field;
        };

        return _objectSpread({}, newSettingsContext, {
          pages: newVisitor.mapFields(function (newField) {
            var previousField = getPreviousField(newField);

            if (previousField) {
              newField.value = previousField.value;

              if (newField.localizable && previousField.localizable) {
                newField.localizedValue = _objectSpread({}, previousField.localizedValue);
              }
            }

            if (newField.fieldName == 'predefinedValue') {
              delete newField.value;
              newField.localizedValue = {};

              if (newField.options) {
                newField.options = _this5._getPredefinedOptions(newVisitor);
              }
            }

            return newField;
          })
        });
      }
    }, {
      key: "_getPredefinedOptions",
      value: function _getPredefinedOptions(visitor) {
        var options = visitor.findField(function (field) {
          return field.fieldName == 'options';
        });

        if (options) {
          var locale = options.locale;
          return options.value[locale];
        }

        return options;
      }
    }, {
      key: "_renderElementSets",
      value: function _renderElementSets() {
        var fieldSets = this.props.fieldSets;
        var groups = Object.keys(fieldSets);
        var elementSetsArea = '';

        if (groups.length > 0) {
          elementSetsArea = this._renderElementSetsGroups(groups);
        } else {
          elementSetsArea = this._renderEmptyElementSets();
        }

        return elementSetsArea;
      }
    }, {
      key: "_renderElementSetsGroups",
      value: function _renderElementSetsGroups(groups) {
        var _this$props6 = this.props,
            fieldSets = _this$props6.fieldSets,
            spritemap = _this$props6.spritemap;
        IncrementalDOM.elementOpen("div", null, null, "aria-orientation", "vertical", "class", "ddm-field-types-panel panel-group", "id", "accordion03", "role", "tablist");
        iDOMHelpers.renderArbitrary(groups.map(function (key) {
          return iDOMHelpers.jsxWrapper(function (_ddmFieldTypes$co, _ddmFieldTypes$con, _key, _fieldSets$key$id, _fieldSets$key$name, _fieldType_$concat, _fieldType_$concat2, _lexiconIconLexicon, _$concat$concat, _fieldSets$key$name2) {
            IncrementalDOM.elementOpen("div", _key, ["class", "panel-collapse show", "key", _key, "role", "tabpanel"], "aria-labelledby", _ddmFieldTypes$co, "id", _ddmFieldTypes$con);
            IncrementalDOM.elementOpen("div", null, null, "class", "panel-body p-0 m-0 list-group");
            IncrementalDOM.elementOpen("div", _fieldType_$concat, ["class", "ddm-drag-item list-group-item list-group-item-flex", "key", _fieldType_$concat], "data-field-set-id", _fieldSets$key$id, "data-field-set-name", _fieldSets$key$name, "ref", _fieldType_$concat2);
            IncrementalDOM.elementOpen("div", null, null, "class", "autofit-col");
            IncrementalDOM.elementOpen("span", null, null, "class", "sticker sticker-secondary");
            IncrementalDOM.elementOpen("span", null, null, "class", "inline-item");
            IncrementalDOM.elementOpen("svg", null, null, "class", _lexiconIconLexicon, "aria-hidden", "true");
            IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat$concat);
            IncrementalDOM.elementClose("svg");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementOpen("div", null, null, "class", "autofit-col autofit-col-expand");
            IncrementalDOM.elementOpen("h4", null, null, "class", "list-group-title text-truncate");
            IncrementalDOM.elementOpen("span");
            iDOMHelpers.renderArbitrary(_fieldSets$key$name2);
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("h4");
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementClose("div");
            return IncrementalDOM.elementClose("div");
          }, ["#ddm-field-types-".concat(key, "-header"), "ddm-field-types-".concat(key, "-body"), key, fieldSets[key].id, fieldSets[key].name, "fieldType_".concat(fieldSets[key].name), "fieldType_".concat(fieldSets[key].name), "lexicon-icon lexicon-icon-".concat(fieldSets[key].icon), "".concat(spritemap, "#").concat(fieldSets[key].icon), fieldSets[key].name]);
        }));
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_renderEmptyElementSets",
      value: function _renderEmptyElementSets() {
        IncrementalDOM.elementOpen("div", null, null, "class", "list-group-body  list-group");
        IncrementalDOM.elementOpen("div", null, null, "class", "main-content-body");
        IncrementalDOM.elementOpen("div", null, null, "class", "text-center text-muted");
        IncrementalDOM.elementOpen("p", null, null, "class", "text-default");
        iDOMHelpers.renderArbitrary(Liferay.Language.get('there-are-no-element-sets-yet'));
        IncrementalDOM.elementClose("p");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("div");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_renderFieldTypeDropdownLabel",
      value: function _renderFieldTypeDropdownLabel() {
        var _this$props7 = this.props,
            fieldTypes = _this$props7.fieldTypes,
            focusedField = _this$props7.focusedField,
            spritemap = _this$props7.spritemap;

        var _fieldTypes$find = fieldTypes.find(function (_ref13) {
          var name = _ref13.name;
          return name === focusedField.type;
        }),
            icon = _fieldTypes$find.icon,
            label = _fieldTypes$find.label;

        IncrementalDOM.elementOpen(_metalJsx.Fragment);
        IncrementalDOM.elementVoid(_clayIcon.ClayIcon, null, null, "spritemap", spritemap, "symbol", icon, "elementClasses", 'inline-item inline-item-before');
        iDOMHelpers.renderArbitrary(label);
        IncrementalDOM.elementVoid(_clayIcon.ClayIcon, null, null, "spritemap", spritemap, "elementClasses", 'inline-item inline-item-after', "symbol", 'caret-bottom');
        return IncrementalDOM.elementClose(_metalJsx.Fragment);
      }
    }, {
      key: "_renderFieldTypeGroups",
      value: function _renderFieldTypeGroups() {
        var spritemap = this.props.spritemap;
        var fieldTypesGroup = this.state.fieldTypesGroup;
        var group = Object.keys(fieldTypesGroup);
        IncrementalDOM.elementOpen("div", null, null, "aria-orientation", "vertical", "class", "ddm-field-types-panel panel-group", "id", "accordion03", "role", "tablist");
        iDOMHelpers.renderArbitrary(group.map(function (key, index) {
          return iDOMHelpers.jsxWrapper(function (_fieldsGroup$concat, _ddmFieldTypes$co2, _ddmFieldTypes$con2, _fieldTypesGroup$key$, _$concat, _$concat2, _ddmFieldTypes$co3, _ddmFieldTypes$con3, _fieldTypesGroup$key$2) {
            IncrementalDOM.elementOpen("div", _fieldsGroup$concat, ["class", "panel panel-secondary", "key", _fieldsGroup$concat]);
            IncrementalDOM.elementOpen("a", null, null, "href", _ddmFieldTypes$co2, "id", _ddmFieldTypes$con2, "aria-controls", "collapseTwo", "aria-expanded", "true", "class", "collapse-icon panel-header panel-header-link", "data-parent", "#accordion03", "data-toggle", "collapse", "role", "tab");
            IncrementalDOM.elementOpen("span", null, null, "class", "panel-title");
            iDOMHelpers.renderArbitrary(_fieldTypesGroup$key$);
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementOpen("span", null, null, "class", "collapse-icon-closed");
            IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-angle-right");
            IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat);
            IncrementalDOM.elementClose("svg");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementOpen("span", null, null, "class", "collapse-icon-open");
            IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-angle-down");
            IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat2);
            IncrementalDOM.elementClose("svg");
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("a");
            IncrementalDOM.elementOpen("div", null, null, "aria-labelledby", _ddmFieldTypes$co3, "id", _ddmFieldTypes$con3, "class", "panel-collapse show", "role", "tabpanel");
            IncrementalDOM.elementOpen("div", null, null, "class", "panel-body p-0 m-0 list-group");
            iDOMHelpers.renderArbitrary(_fieldTypesGroup$key$2);
            IncrementalDOM.elementClose("div");
            IncrementalDOM.elementClose("div");
            return IncrementalDOM.elementClose("div");
          }, ["fields-group-".concat(key, "-").concat(index), "#ddm-field-types-".concat(key, "-body"), "ddm-field-types-".concat(key, "-header"), fieldTypesGroup[key].label, "".concat(spritemap, "#angle-right"), "".concat(spritemap, "#angle-down"), "#ddm-field-types-".concat(key, "-header"), "ddm-field-types-".concat(key, "-body"), fieldTypesGroup[key].fields.map(function (fieldType) {
            return iDOMHelpers.jsxWrapper(function (_fieldType, _fieldType$name, _spritemap) {
              return IncrementalDOM.elementVoid(_FieldTypeBox["default"], _fieldType$name, ["key", _fieldType$name], "fieldType", _fieldType, "spritemap", _spritemap);
            }, [fieldType, fieldType.name, spritemap]);
          })]);
        }));
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_renderNavItems",
      value: function _renderNavItems() {
        var _this6 = this;

        var activeTab = this.state.activeTab;
        return this._getTabItems().map(function (name, index) {
          var _tab$concat;

          var style = (0, _classnames["default"])('nav-link', {
            active: index === activeTab
          });
          IncrementalDOM.elementOpen("li", _tab$concat = "tab".concat(index), ["class", "nav-item", "key", _tab$concat], "data-index", index, "data-onclick", _this6._handleTabItemClicked, "ref", "tab".concat(index));
          IncrementalDOM.elementOpen("a", null, null, "class", style, "aria-controls", "sidebarLightDetails", "data-toggle", "tab", "href", "javascript:;", "role", "tab");
          IncrementalDOM.elementOpen("span", null, null, "class", "navbar-text-truncate");
          iDOMHelpers.renderArbitrary(name);
          IncrementalDOM.elementClose("span");
          IncrementalDOM.elementClose("a");
          return IncrementalDOM.elementClose("li");
        });
      }
    }, {
      key: "_renderSettingsForm",
      value: function _renderSettingsForm() {
        var activeTab = this.state.activeTab;
        var _this$props8 = this.props,
            defaultLanguageId = _this$props8.defaultLanguageId,
            editingLanguageId = _this$props8.editingLanguageId,
            portletNamespace = _this$props8.portletNamespace,
            spritemap = _this$props8.spritemap;

        var _this$getSettingsForm = this.getSettingsFormContext(),
            pages = _this$getSettingsForm.pages,
            rules = _this$getSettingsForm.rules;

        return IncrementalDOM.elementVoid(_Form["default"], null, null, "activePage", activeTab, "defaultLanguageId", defaultLanguageId, "editingLanguageId", editingLanguageId, "events", {
          attached: this._handleSettingsFormAttached,
          evaluated: this._handleEvaluatorChanged,
          fieldBlurred: this._handleSettingsFieldBlurred,
          fieldEdited: this._handleSettingsFieldEdited
        }, "pages", pages, "portletNamespace", portletNamespace, "rules", rules, "spritemap", spritemap, "editable", true, "paginationMode", "tabbed", "ref", "evaluableForm");
      }
    }, {
      key: "_renderTopBar",
      value: function _renderTopBar() {
        var _this$props9 = this.props,
            fieldTypes = _this$props9.fieldTypes,
            focusedField = _this$props9.focusedField,
            spritemap = _this$props9.spritemap;

        var editMode = this._isEditMode();

        var fieldActions = [{
          disabled: this.isActionsDisabled(),
          label: Liferay.Language.get('duplicate-field'),
          settingsItem: 'duplicate-field'
        }, {
          disabled: this.isActionsDisabled(),
          label: Liferay.Language.get('remove-field'),
          settingsItem: 'delete-field'
        }, {
          label: Liferay.Language.get('cancel-field-changes'),
          settingsItem: 'cancel-field-changes'
        }];
        var focusedFieldType = fieldTypes.find(function (_ref14) {
          var name = _ref14.name;
          return name === focusedField.type;
        });
        var previousButtonEvents = {
          click: this._handlePreviousButtonClicked
        };
        IncrementalDOM.elementOpen("ul", null, null, "class", "tbar-nav");
        iDOMHelpers.renderArbitrary(!editMode && (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item tbar-item-expand text-left"), (IncrementalDOM.elementOpen("div", null, null, "class", "tbar-section"), (IncrementalDOM.elementOpen("span", null, null, "class", "text-truncate-inline"), (IncrementalDOM.elementOpen("span", null, null, "class", "text-truncate"), iDOMHelpers.renderArbitrary(Liferay.Language.get('add-elements')), IncrementalDOM.elementClose("span")), IncrementalDOM.elementClose("span")), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("li")));
        iDOMHelpers.renderArbitrary(editMode && (IncrementalDOM.elementOpen(_metalJsx.Fragment), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item"), IncrementalDOM.elementVoid(_clayButton["default"], null, null, "disabled", this.isActionsDisabled(), "events", previousButtonEvents, "spritemap", spritemap, "icon", "angle-left", "ref", "previousButton", "size", "sm", "style", "secondary"), IncrementalDOM.elementClose("li")), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item ddm-fieldtypes-dropdown tbar-item-expand text-left"), (IncrementalDOM.elementOpen("div"), IncrementalDOM.elementVoid(_clayDropdown.ClayDropdownBase, null, null, "disabled", !this.isChangeFieldTypeEnabled(), "events", {
          itemClicked: this._handleChangeFieldTypeItemClicked
        }, "icon", focusedFieldType.icon, "items", this.state.dropdownFieldTypes, "label", this._renderFieldTypeDropdownLabel, "spritemap", spritemap, "itemsIconAlignment", 'left', "style", 'secondary', "triggerClasses", 'nav-link btn-sm'), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("li")), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item"), IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "events", {
          itemClicked: this._handleFieldSettingsClicked
        }, "items", fieldActions, "spritemap", spritemap, "ref", "fieldSettingsActions", "triggerClasses", 'component-action'), IncrementalDOM.elementClose("li")), IncrementalDOM.elementClose(_metalJsx.Fragment)));
        IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item");
        IncrementalDOM.elementOpen("a", null, null, "data-onclick", this._handleCloseButtonClicked, "class", "component-action sidebar-close", "href", "#1", "ref", "closeButton", "role", "button");
        IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-times");
        IncrementalDOM.elementVoid("use", null, null, "xlink:href", "".concat(spritemap, "#times"));
        IncrementalDOM.elementClose("svg");
        IncrementalDOM.elementClose("a");
        IncrementalDOM.elementClose("li");
        return IncrementalDOM.elementClose("ul");
      }
    }]);

    return Sidebar;
  }(_metalJsx["default"]);

  Sidebar.STATE = {
    /**
     * @default 0
     * @instance
     * @memberof Sidebar
     * @type {?number}
     */
    activeTab: _metalState.Config.number().value(0).internal(),

    /**
     * @default _dropdownFieldTypesValueFn
     * @instance
     * @memberof Sidebar
     * @type {?array}
     */
    dropdownFieldTypes: _metalState.Config.array().valueFn('_dropdownFieldTypesValueFn'),

    /**
     * @instance
     * @memberof Sidebar
     * @type {array}
     */
    fieldTypesGroup: _metalState.Config.object().valueFn('_fieldTypesGroupValueFn'),

    /**
     * @default false
     * @instance
     * @memberof Sidebar
     * @type {?bool}
     */
    open: _metalState.Config.bool().internal().value(false),

    /**
     * @default object
     * @instance
     * @memberof Sidebar
     * @type {?object}
     */
    tabs: _metalState.Config.object().value([Liferay.Language.get('elements'), Liferay.Language.get('element-sets')]).internal()
  };
  Sidebar.PROPS = {
    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?string}
     */
    defaultLanguageId: _metalState.Config.string(),

    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?string}
     */
    editingLanguageId: _metalState.Config.string(),

    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?string}
     */
    fieldSetDefinitionURL: _metalState.Config.string(),

    /**
     * @default []
     * @instance
     * @memberof Sidebar
     * @type {?(array|undefined)}
     */
    fieldSets: _metalState.Config.array().value([]),

    /**
     * @default []
     * @instance
     * @memberof Sidebar
     * @type {?(array|undefined)}
     */
    fieldTypes: _metalState.Config.array().value([]),

    /**
     * @default {}
     * @instance
     * @memberof Sidebar
     * @type {?object}
     */
    focusedField: _config.focusedFieldStructure.value({}),

    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?string}
     */
    portletNamespace: _metalState.Config.string(),

    /**
     * @default undefined
     * @instance
     * @memberof Sidebar
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string().required()
  };
  var _default = Sidebar;
  exports["default"] = _default;
  //# sourceMappingURL=Sidebar.es.js.map
});
//# sourceMappingURL=Sidebar.es.js.map