Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.47/js/components/RuleEditor/RuleEditor.es", ['module', 'exports', 'require', '../Calculator/Calculator.es', 'frontend-taglib-clay$clay-alert', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-modal', 'dynamic-data-mapping-form-renderer/js/components/PageRenderer/PageRenderer.es', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../util/pageSupport.es', '../LayoutProvider/util/fields.es', './RuleEditor.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("../Calculator/Calculator.es");

  require("frontend-taglib-clay$clay-alert");

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-modal");

  require("dynamic-data-mapping-form-renderer/js/components/PageRenderer/PageRenderer.es");

  var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _pageSupport = require("../../util/pageSupport.es");

  var _fields = require("../LayoutProvider/util/fields.es");

  var _RuleEditorSoy = _interopRequireDefault(require("./RuleEditor.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var fieldOptionStructure = _metalState.Config.shapeOf({
    dataType: _metalState.Config.string(),
    name: _metalState.Config.string(),
    options: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      label: _metalState.Config.string(),
      name: _metalState.Config.string(),
      value: _metalState.Config.string()
    })),
    type: _metalState.Config.string(),
    value: _metalState.Config.string()
  });
  /**
   * RuleEditor.
   * @extends Component
   */

  var RuleEditor =
  /*#__PURE__*/
  function (_Component) {
    _inherits(RuleEditor, _Component);

    function RuleEditor() {
      _classCallCheck(this, RuleEditor);

      return _possibleConstructorReturn(this, _getPrototypeOf(RuleEditor).apply(this, arguments));
    }

    _createClass(RuleEditor, [{
      key: "convertAutoFillDataToArray",
      value: function convertAutoFillDataToArray(action, type) {
        var _this = this;

        var data = action[type];
        var originalData = action["".concat(type, "Data")];
        return Object.keys(data).map(function (key, index) {
          var _originalData$index = originalData[index],
              label = _originalData$index.label,
              name = _originalData$index.name,
              required = _originalData$index.required,
              type = _originalData$index.type;

          var fieldsTypes = _this.getTypesByFieldType(type);

          var actionsFieldOptions = _this.getFieldsByTypes(_this.actionsFieldOptions, fieldsTypes);

          return {
            fieldOptions: actionsFieldOptions,
            label: label,
            name: name,
            required: required,
            type: type,
            value: data[key]
          };
        });
      }
    }, {
      key: "created",
      value: function created() {
        if (this.rule) {
          this._prepareRuleEditor();
        }

        this._fetchFunctionsURL();

        this._setDataProviderTarget();

        this._setActionsInputsOutputs();
      }
    }, {
      key: "disposed",
      value: function disposed() {
        this.setState({
          actions: [],
          conditions: [],
          logicalOperator: ''
        });
      }
    }, {
      key: "formatDataProviderInputParameter",
      value: function formatDataProviderInputParameter(actionParameters, parameters) {
        return parameters.reduce(function (result, _ref) {
          var name = _ref.name,
              value = _ref.value;
          return _objectSpread({}, result, _defineProperty({}, name, Object.keys(actionParameters).indexOf(name) !== -1 ? actionParameters[name] : value));
        }, {});
      }
    }, {
      key: "formatDataProviderOutputParameter",
      value: function formatDataProviderOutputParameter(actionParameters, parameters) {
        return parameters.reduce(function (result, _ref2) {
          var id = _ref2.id;
          return _objectSpread({}, result, _defineProperty({}, id, Object.keys(actionParameters).indexOf(id) !== -1 ? actionParameters[id] : undefined));
        }, {});
      }
    }, {
      key: "getDataProviderOptions",
      value: function getDataProviderOptions(id, index) {
        var _this2 = this;

        var promise;

        if (id) {
          promise = this._fetchDataProviderParameters(id, index).then(function (_ref3) {
            var inputs = _ref3.inputs,
                outputs = _ref3.outputs;
            var actions = _this2.actions;

            if (!_this2.isDisposed()) {
              actions = actions.map(function (action, currentIndex) {
                return index == currentIndex ? _objectSpread({}, action, {
                  ddmDataProviderInstanceUUID: _this2.dataProvider.find(function (data) {
                    return data.id == id;
                  }).uuid,
                  hasRequiredInputs: inputs.some(function (input) {
                    return input.required;
                  }),
                  inputs: _this2.formatDataProviderInputParameter(action.inputs, inputs),
                  inputsData: inputs,
                  outputs: _this2.formatDataProviderOutputParameter(action.outputs, outputs),
                  outputsData: outputs
                }) : action;
              });
            }

            return actions[index];
          })["catch"](function (error) {
            throw new Error(error);
          });
        } else {
          promise = Promise.resolve(this.actions[index]);
        }

        return promise;
      }
    }, {
      key: "getFieldOptions",
      value: function getFieldOptions(fieldName) {
        var options = [];
        var visitor = new _visitors.PagesVisitor(this.pages);
        var field = visitor.findField(function (field) {
          return field.fieldName === fieldName;
        });
        options = field ? field.options : [];
        return options;
      }
    }, {
      key: "getFieldsByTypes",
      value: function getFieldsByTypes(fields, types) {
        return fields.filter(function (field) {
          return types.some(function (fieldType) {
            return field.type == fieldType;
          });
        });
      }
    }, {
      key: "getTypesByFieldType",
      value: function getTypesByFieldType(fieldType) {
        var list = [];

        if (fieldType == 'list') {
          list = ['checkbox_multiple', 'radio', 'select'];
        } else if (fieldType == 'text') {
          list = ['checkbox_multiple', 'date', 'numeric', 'radio', 'select', 'text'];
        } else if (fieldType == 'number') {
          list = ['numeric'];
        }

        return list;
      }
    }, {
      key: "isValueOperand",
      value: function isValueOperand(_ref4) {
        var type = _ref4.type;
        return type !== 'field' && type !== 'user';
      }
    }, {
      key: "populateActionTargetValue",
      value: function populateActionTargetValue(id, index) {
        var actions = this.actions,
            pageOptions = this.pageOptions;
        var previousTarget = actions[index].target;
        actions[index].target = id;
        actions[index].label = id;

        if (actions[index].action == 'jump-to-page') {
          var selectedOption = pageOptions.find(function (option) {
            return option.value == id;
          });
          actions[index].label = selectedOption.label;
        }

        if (id === undefined) {
          actions[index].target = '';
        } else if (id === '') {
          actions[index].inputs = {};
          actions[index].outputs = {};
          actions[index].hasRequiredInputs = false;
        } else if (previousTarget !== id && actions[index].action == 'calculate') {
          actions[index].calculatorFields = this._updateCalculatorFields(this.actions[index], id);
        }

        this.setState({
          actions: actions
        });
      }
    }, {
      key: "populateDataProviderOptions",
      value: function populateDataProviderOptions(id, index) {
        var _this3 = this;

        var actions = this.actions;
        actions[index].target = id;
        actions[index].label = id;
        this.getDataProviderOptions(id, index).then(function (actionData) {
          if (!_this3.isDisposed()) {
            _this3.setState({
              actions: actions.map(function (action, currentIndex) {
                return index == currentIndex ? actionData : action;
              })
            });
          }
        })["catch"](function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var _this4 = this;

        var pages = this.pages;
        var actions = state.loadingDataProviderOptions ? [] : state.actions.map(function (action) {
          return _objectSpread({}, action, {
            inputs: action.inputs ? _this4.convertAutoFillDataToArray(action, 'inputs') : [],
            outputs: action.outputs ? _this4.convertAutoFillDataToArray(action, 'outputs') : []
          });
        });
        var conditions = state.conditions.map(function (condition) {
          var fieldName = condition.operands[0].value;
          var firstOperandOptions = [];
          var operators = [];

          if (fieldName) {
            var _this4$_getFieldTypeB = _this4._getFieldTypeByFieldName(fieldName),
                dataType = _this4$_getFieldTypeB.dataType;

            operators = _this4._getOperatorsByFieldType(dataType);
            firstOperandOptions = _this4.getFieldOptions(fieldName);
          }

          return _objectSpread({}, condition, {
            binaryOperator: _this4._isBinary(condition.operator),
            firstOperandOptions: firstOperandOptions,
            operands: condition.operands.map(function (operand, index) {
              if (index === 1 && _this4.isValueOperand(operand)) {
                operand = _objectSpread({}, operand, {
                  dataType: (0, _fields.getFieldProperty)(pages, condition.operands[0].value, 'dataType'),
                  type: (0, _fields.getFieldProperty)(pages, condition.operands[0].value, 'type')
                });
              }

              return operand;
            }),
            operators: operators
          });
        });
        var actionTypes = this.actionTypes;

        if (pages.length < 3) {
          actionTypes = this.actionTypes.filter(function (obj) {
            return obj.value !== 'jump-to-page';
          });
        }

        return _objectSpread({}, state, {
          actionTypes: actionTypes,
          actions: actions,
          conditions: conditions
        });
      }
    }, {
      key: "syncPages",
      value: function syncPages(pages) {
        var _this5 = this;

        var actions = this.actions;
        var conditions = this.conditions;
        var visitor = new _visitors.PagesVisitor(pages);
        conditions.forEach(function (condition, index) {
          var firstOperandFieldExists = false;
          var secondOperand = condition.operands[1];
          var secondOperandFieldExists = false;
          visitor.mapFields(function (_ref5) {
            var fieldName = _ref5.fieldName;

            if (condition.operands[0].value === fieldName) {
              firstOperandFieldExists = true;
            }

            if (secondOperand && secondOperand.value === fieldName) {
              secondOperandFieldExists = true;
            }
          });

          if (condition.operands[0].value === 'user') {
            firstOperandFieldExists = true;
          }

          if (!firstOperandFieldExists) {
            conditions = _this5._clearAllConditionFieldValues(index);
          }

          if (!secondOperandFieldExists && secondOperand && secondOperand.type == 'field') {
            conditions = _this5._clearSecondOperandValue(conditions, index);
          }
        });
        var maxPage = (0, _pageSupport.maxPageIndex)(conditions, pages);
        this.setState({
          actions: this._syncActions(actions),
          actionsFieldOptions: this._actionsFieldOptionsValueFn(),
          calculatorResultOptions: this._calculatorResultOptionsValueFn(),
          conditions: conditions,
          conditionsFieldOptions: this._conditionsFieldOptionsValueFn(['paragraph']),
          deletedFields: this._getDeletedFields(visitor),
          pageOptions: (0, _pageSupport.pageOptions)(pages, maxPage),
          roles: this._rolesValueFn()
        });
      }
    }, {
      key: "willUpdate",
      value: function willUpdate() {
        this.setState({
          invalidRule: !this._validateConditionsFilling() || !this._validateActionsFilling()
        });
      }
    }, {
      key: "_calculatorResultOptionsValueFn",
      value: function _calculatorResultOptionsValueFn() {
        var pages = this.pages;
        var fields = [];
        var visitor = new _visitors.PagesVisitor(pages);
        visitor.mapFields(function (field) {
          if (field.type == 'numeric') {
            fields.push(_objectSpread({}, field, {
              options: field.options ? field.options : [],
              value: field.fieldName
            }));
          }
        });
        return fields;
      }
    }, {
      key: "_clearAction",
      value: function _clearAction(index) {
        var actions = this.actions;
        return actions.map(function (action, currentIndex) {
          return currentIndex === index ? {
            action: '',
            calculatorFields: [],
            expression: '',
            inputs: {},
            label: '',
            outputs: {},
            target: ''
          } : action;
        });
      }
    }, {
      key: "_clearAllConditionFieldValues",
      value: function _clearAllConditionFieldValues(index) {
        var secondOperandSelectedList = this.secondOperandSelectedList;
        var conditions = this.conditions;
        conditions = this._clearFirstOperandValue(conditions, index);
        conditions = this._clearOperatorValue(conditions, index);
        conditions = this._clearSecondOperandValue(conditions, index);
        this.setState({
          conditions: conditions,
          secondOperandSelectedList: secondOperandSelectedList
        });
        return conditions;
      }
    }, {
      key: "_clearFirstOperandValue",
      value: function _clearFirstOperandValue(conditions, index) {
        if (conditions[index] && conditions[index].operands[0]) {
          conditions[index].operands[0].type = '';
          conditions[index].operands[0].value = '';
        }

        return conditions;
      }
    }, {
      key: "_clearOperatorValue",
      value: function _clearOperatorValue(conditions, index) {
        if (conditions[index]) {
          conditions[index].operator = '';
        }

        return conditions;
      }
    }, {
      key: "_clearSecondOperandValue",
      value: function _clearSecondOperandValue(conditions, index) {
        if (conditions[index] && conditions[index].operands[1]) {
          conditions[index].operands = [conditions[index].operands[0]];
        }

        return conditions;
      }
    }, {
      key: "_clearSelectedSecondOperand",
      value: function _clearSelectedSecondOperand(secondOperandSelectedList) {
        return secondOperandSelectedList;
      }
    }, {
      key: "_fetchDataProviderParameters",
      value: function _fetchDataProviderParameters(id) {
        var dataProviderInstanceParameterSettingsURL = this.dataProviderInstanceParameterSettingsURL;
        return (0, _fetch.makeFetch)({
          method: 'GET',
          url: "".concat(dataProviderInstanceParameterSettingsURL, "?ddmDataProviderInstanceId=").concat(id)
        })["catch"](function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "_fetchFunctionsURL",
      value: function _fetchFunctionsURL() {
        var _this6 = this;

        var functionsURL = this.functionsURL;
        (0, _fetch.makeFetch)({
          method: 'GET',
          url: functionsURL
        }).then(function (responseData) {
          if (!_this6.isDisposed()) {
            _this6.setState({
              calculatorFunctions: responseData
            });
          }
        })["catch"](function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "_actionsFieldOptionsValueFn",
      value: function _actionsFieldOptionsValueFn() {
        return this._getFieldOptions();
      }
    }, {
      key: "_conditionsFieldOptionsValueFn",
      value: function _conditionsFieldOptionsValueFn(omittedFieldsList) {
        return this._getFieldOptions(omittedFieldsList);
      }
    }, {
      key: "_getDeletedFields",
      value: function _getDeletedFields(visitor) {
        var existentFields = [];
        var actionsFieldOptions = this.actionsFieldOptions;
        var deletedFields = [];
        actionsFieldOptions.forEach(function (field) {
          visitor.mapFields(function (_ref6) {
            var fieldName = _ref6.fieldName;

            if (field.fieldName === fieldName) {
              existentFields.push(fieldName);
            }
          });
        });
        var oldFields = actionsFieldOptions.map(function (field) {
          return field.fieldName;
        });
        deletedFields = oldFields.filter(function (field) {
          return existentFields.indexOf(field) > -1 ? false : field;
        });
        return deletedFields;
      }
    }, {
      key: "_getFieldOptions",
      value: function _getFieldOptions() {
        var omittedFieldsList = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var pages = this.pages;
        var fields = [];
        var visitor = new _visitors.PagesVisitor(pages);
        visitor.mapFields(function (field) {
          if (omittedFieldsList.indexOf(field.type) < 0) {
            fields.push(_objectSpread({}, field, {
              options: field.options ? field.options : [],
              value: field.fieldName
            }));
          }
        });
        return fields;
      }
    }, {
      key: "_getFieldLabel",
      value: function _getFieldLabel(fieldName) {
        var pages = this.pages;
        var fieldLabel;

        if (pages) {
          for (var page = 0; page < pages.length; page++) {
            var rows = pages[page].rows;

            for (var row = 0; row < rows.length; row++) {
              var cols = rows[row].columns;

              for (var col = 0; col < cols.length; col++) {
                var fields = cols[col].fields;

                for (var field = 0; field < fields.length; field++) {
                  if (pages[page].rows[row].columns[col].fields[field].fieldName === fieldName) {
                    fieldLabel = pages[page].rows[row].columns[col].fields[field].label;
                    break;
                  }
                }
              }
            }
          }
        }

        return fieldLabel;
      }
    }, {
      key: "_getFieldTypeByFieldName",
      value: function _getFieldTypeByFieldName(fieldName) {
        var dataType = '';
        var repeatable = false;
        var type = '';

        if (fieldName === 'user') {
          dataType = 'user';
        } else {
          var selectedField = this.actionsFieldOptions.find(function (field) {
            return field.value === fieldName;
          });

          if (selectedField) {
            dataType = selectedField.dataType;
            repeatable = selectedField.repeatable;
            type = selectedField.type;
          }
        }

        return {
          dataType: dataType,
          repeatable: repeatable,
          type: type
        };
      }
    }, {
      key: "_getIndex",
      value: function _getIndex(fieldInstance, fieldClass) {
        var firstOperand = _metalDom["default"].closest(fieldInstance.element, fieldClass);

        return firstOperand.getAttribute("".concat(fieldClass.substring(1), "-index"));
      }
    }, {
      key: "_getOperatorsByFieldType",
      value: function _getOperatorsByFieldType(fieldType) {
        if (fieldType === 'integer' || fieldType === 'double') {
          fieldType = 'number';
        }

        if (!Object.hasOwnProperty.call(this.functionsMetadata, fieldType)) {
          fieldType = 'text';
        }

        return this.functionsMetadata[fieldType].map(function (metadata) {
          return _objectSpread({}, metadata, {
            value: metadata.name
          });
        });
      }
    }, {
      key: "_handleActionAdded",
      value: function _handleActionAdded() {
        var actions = this.actions;
        var newAction = {
          action: '',
          calculatorFields: [],
          expression: '',
          inputs: {},
          label: '',
          outputs: {},
          target: ''
        };

        if (actions.length == 0) {
          actions.push(newAction);
        }

        actions.push(newAction);
        this.setState({
          actions: actions,
          invalidRule: true
        });
      }
    }, {
      key: "_handleActionSelection",
      value: function _handleActionSelection(event) {
        var fieldInstance = event.fieldInstance,
            value = event.value;
        var index = parseInt(this._getIndex(fieldInstance, '.action-type'), 10);
        var actions = this.actions,
            conditions = this.conditions;

        var newActions = _toConsumableArray(actions);

        if (value && value.length > 0 && value[0]) {
          var fieldName = value[0];

          if (actions.length > 0) {
            var previousAction = actions[index].action;

            if (fieldName !== previousAction) {
              newActions = newActions.map(function (action, currentIndex) {
                return currentIndex === index ? _objectSpread({}, action, {
                  action: fieldName,
                  calculatorFields: [],
                  label: '',
                  source: conditions[0].operands[0].source,
                  target: ''
                }) : action;
              });
            }
          } else {
            newActions.push({
              action: fieldName
            });
          }
        } else {
          newActions = this._clearAction(index);
        }

        this.setState({
          actions: newActions
        });
      }
    }, {
      key: "_handleConditionAdded",
      value: function _handleConditionAdded() {
        var conditions = this.conditions;
        conditions.push({
          operands: [{
            type: '',
            value: ''
          }],
          operator: ''
        });
        this.setState({
          conditions: conditions
        });
      }
    }, {
      key: "_handleDataProviderInputEdited",
      value: function _handleDataProviderInputEdited(event) {
        var fieldInstance = event.fieldInstance,
            value = event.value;
        var actions = this.actions;

        var actionIndex = this._getIndex(fieldInstance, '.action');

        var inputIndex = this._getIndex(fieldInstance, '.container-input-field');

        var editedInput = Object.keys(actions[actionIndex].inputs)[inputIndex];
        actions[actionIndex].inputs[editedInput] = value[0];
        this.setState({
          actions: actions
        });
      }
    }, {
      key: "_handleDataProviderOutputEdited",
      value: function _handleDataProviderOutputEdited(event) {
        var fieldInstance = event.fieldInstance,
            value = event.value;

        var actionIndex = this._getIndex(fieldInstance, '.action');

        var outputIndex = this._getIndex(fieldInstance, '.container-output-field');

        var actions = this.actions;
        var editedOutput = Object.keys(actions[actionIndex].outputs)[outputIndex];
        actions[actionIndex].outputs[editedOutput] = value[0];
        this.setState({
          actions: actions
        });
      }
    }, {
      key: "_handleDeleteAction",
      value: function _handleDeleteAction(event) {
        var currentTarget = event.currentTarget;
        var index = currentTarget.getAttribute('data-index');
        this.refs.confirmationModalAction.show();
        this.setState({
          activeActionIndex: parseInt(index, 10)
        });
      }
    }, {
      key: "_handleDeleteCondition",
      value: function _handleDeleteCondition(event) {
        var currentTarget = event.currentTarget;
        var index = currentTarget.getAttribute('data-index');
        this.refs.confirmationModalCondition.show();
        this.setState({
          activeConditionIndex: parseInt(index, 10)
        });
      }
    }, {
      key: "_handleEditExpression",
      value: function _handleEditExpression(_ref7) {
        var expression = _ref7.expression,
            index = _ref7.index;
        var actions = this.actions;
        actions[index].expression = expression;
        this.setState({
          actions: actions
        });
      }
    }, {
      key: "_handleFirstOperandFieldEdited",
      value: function _handleFirstOperandFieldEdited(event) {
        var fieldInstance = event.fieldInstance,
            value = event.value;

        var index = this._getIndex(fieldInstance, '.condition-if');

        var actions = this.actions,
            pages = this.pages;
        var conditions = this.conditions;

        if (value && value.length > 0 && value[0]) {
          var fieldName = value[0];

          var _this$_getFieldTypeBy = this._getFieldTypeByFieldName(fieldName),
              dataType = _this$_getFieldTypeBy.dataType,
              repeatable = _this$_getFieldTypeBy.repeatable;

          var firstOperand = {
            label: this._getFieldLabel(fieldName),
            repeatable: repeatable,
            type: dataType == 'user' ? 'user' : 'field',
            value: fieldName
          };

          if (conditions.length === 0) {
            conditions.push({
              operands: [firstOperand]
            });
          } else {
            if (fieldName !== conditions[index].operands[0].value) {
              conditions[index].operator = '';

              this._clearSecondOperandValue(conditions, index);
            }

            conditions[index].operands[0] = firstOperand;
          }
        } else {
          conditions = this._clearAllConditionFieldValues(index);
        }

        var maxPageIndex;
        var visitor = new _visitors.PagesVisitor(pages);

        if (conditions[index].operands[0].value != '') {
          visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
            if (field.fieldName === conditions[index].operands[0].value) {
              maxPageIndex = pageIndex;
              conditions[index].operands[0].source = pageIndex;
            }
          });
        }

        if (actions && actions[0].action != '') {
          actions.map(function (action) {
            if (action.action == 'jump-to-page') {
              action.source = conditions[index].operands[0].source;
            }

            return {
              action: action
            };
          });
        }

        this.setState({
          actions: actions,
          conditions: conditions,
          pageOptions: (0, _pageSupport.pageOptions)(pages, maxPageIndex)
        });
      }
    }, {
      key: "_handleLogicalOperationChange",
      value: function _handleLogicalOperationChange(event) {
        var target = event.target;
        var value = target.dataset.value;

        if (value !== this.logicalOperator) {
          this.setState({
            logicalOperator: value
          });
        }
      }
    }, {
      key: "_handleModalButtonClicked",
      value: function _handleModalButtonClicked(event) {
        event.stopPropagation();

        if (!event.target.classList.contains('close-modal')) {
          var activeActionIndex = this.activeActionIndex;
          var activeConditionIndex = this.activeConditionIndex;
          var actions = this.actions,
              conditions = this.conditions;

          if (activeConditionIndex > -1) {
            conditions.splice(activeConditionIndex, 1);
          }

          if (activeActionIndex > -1) {
            actions.splice(activeActionIndex, 1);
          }

          if (this.refs.confirmationModalAction.visible) {
            this.refs.confirmationModalAction.emit('hide');
          }

          if (this.refs.confirmationModalCondition.visible) {
            this.refs.confirmationModalCondition.emit('hide');
          }

          this.setState({
            actions: actions,
            activeActionIndex: -1,
            activeConditionIndex: -1,
            conditions: conditions
          });
        }
      }
    }, {
      key: "_handleOperatorEdited",
      value: function _handleOperatorEdited(event) {
        var fieldInstance = event.fieldInstance,
            value = event.value;
        var conditions = this.conditions;
        var operatorValue = '';

        if (value && value.length > 0 && value[0]) {
          operatorValue = value[0];
        }

        var index = this._getIndex(fieldInstance, '.condition-operator');

        if (!operatorValue || !this._isBinary(operatorValue)) {
          conditions = this._clearSecondOperandValue(conditions, index);
          conditions[index].operator = operatorValue;
        } else {
          conditions[index].operator = operatorValue;
        }

        this.setState({
          conditions: conditions
        });
      }
    }, {
      key: "_handleRuleAdded",
      value: function _handleRuleAdded() {
        var _this$emit;

        var actions = this._removeActionInternalProperties();

        var conditions = this._removeConditionInternalProperties();

        var ruleEditedIndex = this.ruleEditedIndex;
        this.emit('ruleAdded', (_this$emit = {
          actions: actions,
          conditions: conditions
        }, _defineProperty(_this$emit, 'logical-operator', this.logicalOperator), _defineProperty(_this$emit, "ruleEditedIndex", ruleEditedIndex), _this$emit));
      }
    }, {
      key: "_handleRuleCancelled",
      value: function _handleRuleCancelled() {
        this.emit('ruleCancelled', {});
      }
    }, {
      key: "_handleSecondOperandFieldEdited",
      value: function _handleSecondOperandFieldEdited(event) {
        var conditions = this.conditions;
        var fieldInstance = event.fieldInstance,
            value = event.value;
        var fieldValue = '';

        if (value && _typeof(value) == 'object' && value[0]) {
          fieldValue = value[0];
        } else if (value && typeof value == 'string') {
          fieldValue = value;
        }

        var index;

        if (_metalDom["default"].closest(fieldInstance.element, '.condition-type-value')) {
          index = this._getIndex(fieldInstance, '.condition-type-value');
        }

        var secondOperand = conditions[index].operands[1];

        if (!secondOperand) {
          secondOperand = {
            dataType: fieldInstance.dataType,
            type: fieldInstance.type
          };
        }

        var userType = '';

        if (conditions[index].operands[0].type === 'user') {
          userType = conditions[index].operands[0].type;
        }

        conditions[index].operands[1] = _objectSpread({}, secondOperand, {
          dataType: fieldInstance.dataType,
          label: fieldValue,
          type: userType ? userType : fieldInstance.type,
          value: fieldValue
        });
        this.setState({
          conditions: conditions
        });
      }
    }, {
      key: "_handleSecondOperandTypeEdited",
      value: function _handleSecondOperandTypeEdited(event) {
        var conditions = this.conditions;
        var fieldInstance = event.fieldInstance,
            value = event.value;

        var index = this._getIndex(fieldInstance, '.condition-type');

        var operands = conditions[index].operands;
        var secondOperand = operands[1];
        var secondOperandType = 'field';
        var valueType = 'field';

        if (value[0] == 'value') {
          valueType = 'string';
          secondOperandType = this._getFieldTypeByFieldName(operands[0].value).dataType;
        }

        if (secondOperand && secondOperand.type === secondOperandType && value[0] !== '') {
          return;
        }

        if (value[0] == '') {
          conditions = this._clearSecondOperandValue(conditions, index);
        } else if (secondOperand && secondOperand.dataType != valueType) {
          conditions[index].operands[1].type = '';
          conditions[index].operands[1].value = '';
        }

        if (secondOperand) {
          secondOperand.type = secondOperandType;
        } else if (value[0] !== '') {
          conditions[index].operands.push({
            type: secondOperandType,
            value: ''
          });
        }

        this.setState({
          conditions: conditions
        });
      }
    }, {
      key: "_handleSecondOperandValueEdited",
      value: function _handleSecondOperandValueEdited(event) {
        var conditions = this.conditions;
        var fieldInstance = event.fieldInstance,
            value = event.value;

        var index = this._getIndex(fieldInstance, '.condition-type-value');

        var secondOperandValue = Array.isArray(value) ? value[0] : value;
        this.setState({
          conditions: conditions.map(function (condition, conditionIndex) {
            var operands = _toConsumableArray(condition.operands);

            if (index == conditionIndex) {
              operands[1] = _objectSpread({}, operands[1], {
                value: secondOperandValue
              });
            }

            return _objectSpread({}, condition, {
              operands: operands
            });
          })
        });
      }
    }, {
      key: "_handleTargetSelection",
      value: function _handleTargetSelection(event) {
        var fieldInstance = event.fieldInstance,
            value = event.value;
        var actions = this.actions;
        var id = value[0];

        var index = this._getIndex(fieldInstance, '.target-action');

        var previousTarget = actions[index].target;

        if (previousTarget !== id && actions[index].action == 'auto-fill') {
          this.populateDataProviderOptions(id, index);
        } else {
          this.populateActionTargetValue(id, index);
        }
      }
    }, {
      key: "_isBinary",
      value: function _isBinary(value) {
        return value === 'equals-to' || value === 'not-equals-to' || value === 'contains' || value === 'not-contains' || value === 'belongs-to' || value === 'greater-than' || value === 'greater-than-equals' || value === 'less-than' || value === 'less-than-equals';
      }
    }, {
      key: "_isFieldAction",
      value: function _isFieldAction(fieldName) {
        return fieldName == 'enable' || fieldName == 'show' || fieldName == 'require';
      }
    }, {
      key: "_prepareAutofillOutputs",
      value: function _prepareAutofillOutputs(action) {
        if (Array.isArray(action.outputs)) {
          action.outputs.forEach(function (output) {
            delete output.actionsFieldOptions;
            delete output.name;
            delete output.type;
          });
        }

        return action.outputs;
      }
    }, {
      key: "_prepareRuleEditor",
      value: function _prepareRuleEditor() {
        var rule = this.rule;
        var newRule = rule;
        var newActions = rule.actions.map(function (action) {
          var newAction = _objectSpread({}, action);

          if (action.action == 'jump-to-page') {
            newAction.target = (parseInt(action.target, 10) + 1).toString();
          }

          return newAction;
        });
        newActions = this._syncActions(newActions);
        newRule.actions = newActions;
        this.setState({
          actions: newActions,
          conditions: rule.conditions,
          logicalOperator: rule['logical-operator'],
          rule: newRule
        });
      }
    }, {
      key: "_removeActionInternalProperties",
      value: function _removeActionInternalProperties() {
        var actions = this.actions;
        return actions.map(function (action) {
          var actionType = action.action,
              ddmDataProviderInstanceUUID = action.ddmDataProviderInstanceUUID,
              expression = action.expression,
              inputs = action.inputs,
              label = action.label,
              outputs = action.outputs,
              source = action.source,
              target = action.target;
          var newAction = {
            action: actionType,
            label: label,
            target: target
          };

          if (actionType == 'auto-fill') {
            newAction = _objectSpread({}, newAction, {
              ddmDataProviderInstanceUUID: ddmDataProviderInstanceUUID,
              inputs: inputs,
              outputs: outputs
            });
          } else if (actionType == 'calculate') {
            newAction = _objectSpread({}, newAction, {
              expression: expression
            });
          } else if (actionType == 'jump-to-page') {
            newAction = _objectSpread({}, newAction, {
              source: "".concat(source),
              target: "".concat(parseInt(target, 10) - 1)
            });
          }

          return newAction;
        });
      }
    }, {
      key: "_removeConditionInternalProperties",
      value: function _removeConditionInternalProperties() {
        var conditions = this.conditions;
        conditions.forEach(function (condition) {
          if (condition.operands[0].type == 'user') {
            condition.operands[0].label = condition.operands[0].value;
            condition.operands[1].type = 'list';
          }

          if (condition.operands[1]) {
            condition.operands[1].label = condition.operands[1].value;
          }
        });
        return conditions;
      }
    }, {
      key: "_rolesValueFn",
      value: function _rolesValueFn() {
        var roles = this.roles;
        return roles.map(function (role) {
          return _objectSpread({}, role, {
            value: role.label
          });
        });
      }
    }, {
      key: "_setActions",
      value: function _setActions(actions) {
        if (actions.length == 0) {
          actions.push({
            action: '',
            calculatorFields: [],
            expression: '',
            hasRequiredInputs: false,
            inputs: {},
            label: '',
            outputs: {},
            target: ''
          });
        }

        return actions;
      }
    }, {
      key: "_setActionsInputsOutputs",
      value: function _setActionsInputsOutputs() {
        var _this7 = this;

        var rule = this.rule;

        if (rule) {
          this.setState({
            loadingDataProviderOptions: true
          });
          Promise.all(rule.actions.map(function (action, index) {
            var newAction = _objectSpread({}, action);

            if (action.ddmDataProviderInstanceUUID) {
              var _this7$dataProvider$f = _this7.dataProvider.find(function (dataProvider) {
                var dataProviderId;

                if (dataProvider.uuid === action.ddmDataProviderInstanceUUID) {
                  dataProviderId = dataProvider.id;
                }

                return dataProviderId;
              }),
                  id = _this7$dataProvider$f.id;

              newAction = _this7.getDataProviderOptions(id, index);
            }

            newAction.calculatorFields = _this7._updateCalculatorFields(newAction, newAction.target);
            return newAction;
          })).then(function (actions) {
            _this7.setState({
              actions: actions,
              loadingDataProviderOptions: false
            });
          })["catch"](function (error) {
            throw new Error(error);
          });
        }
      }
    }, {
      key: "_setConditions",
      value: function _setConditions(conditions) {
        if (conditions.length === 0) {
          conditions.push({
            operands: [{
              type: '',
              value: ''
            }],
            operator: ''
          });
        }

        return conditions;
      }
    }, {
      key: "_setDataProviderTarget",
      value: function _setDataProviderTarget() {
        var dataProvider = this.dataProvider,
            rule = this.rule;

        if (!rule) {
          return;
        }

        this.setState({
          actions: rule.actions.map(function (action) {
            if (action.action == 'auto-fill') {
              var _dataProvider$find = dataProvider.find(function (_ref8) {
                var uuid = _ref8.uuid;
                return uuid === action.ddmDataProviderInstanceUUID;
              }),
                  id = _dataProvider$find.id;

              action.target = id;
            }

            return action;
          })
        });
      }
    }, {
      key: "_syncActions",
      value: function _syncActions(actions) {
        var _this8 = this;

        var pages = this.pages;
        var visitor = new _visitors.PagesVisitor(pages);
        actions.forEach(function (action) {
          var targetFieldExists = false;
          visitor.mapFields(function (_ref9) {
            var fieldName = _ref9.fieldName;

            if (action.target === fieldName) {
              targetFieldExists = true;
            }
          });
          action.calculatorFields = _this8._updateCalculatorFields(action, action.target);

          if (action.action !== 'auto-fill' && action.action !== 'jump-to-page' && !targetFieldExists) {
            action.target = '';
          } else if (action.action == 'auto-fill') {
            action = _objectSpread({}, action, {
              calculatorFields: []
            });
          }
        });
        return actions;
      }
    }, {
      key: "_updateCalculatorFields",
      value: function _updateCalculatorFields(action, id) {
        var calculatorResultOptions = this.calculatorResultOptions;
        return calculatorResultOptions.reduce(function (prev, option) {
          return option.fieldName === id ? prev : [].concat(_toConsumableArray(prev), [_objectSpread({}, option, {
            title: option.fieldName,
            type: 'item'
          })]);
        }, []);
      }
    }, {
      key: "_validateActionsAutoFill",
      value: function _validateActionsAutoFill(autoFillActions, type) {
        return autoFillActions.every(function (action) {
          var parameterKeys = Object.keys(action[type]);
          var validation = parameterKeys.every(function (key) {
            return action[type][key];
          });

          if (type === 'inputs' && !parameterKeys.length) {
            validation = Object.keys(action.outputs).length;
          }

          return validation;
        });
      }
    }, {
      key: "_validateActionsCalculateFilling",
      value: function _validateActionsCalculateFilling(calculateActions) {
        var allFieldsFilled = true;
        calculateActions.forEach(function (_ref10) {
          var expression = _ref10.expression;

          if (expression && expression.length == 0) {
            allFieldsFilled = false;
          }
        });
        return allFieldsFilled;
      }
    }, {
      key: "_validateActionsFilling",
      value: function _validateActionsFilling() {
        var actions = this.actions;
        var allFieldsFilled = true;
        var autofillActions = actions.filter(function (action) {
          return action.action == 'auto-fill';
        });
        var calculateActions = actions.filter(function (action) {
          return action.action == 'calculate';
        });

        if (actions) {
          actions.forEach(function (currentAction) {
            var action = currentAction.action,
                target = currentAction.target;

            if (action == '') {
              allFieldsFilled = false;
            } else if (target == '') {
              allFieldsFilled = false;
            }
          });

          if (allFieldsFilled) {
            if (autofillActions && autofillActions.length > 0 && calculateActions && calculateActions.length > 0) {
              allFieldsFilled = this._validateInputOutputs(autofillActions) && this._validateActionsCalculateFilling(calculateActions);
            } else if (autofillActions && autofillActions.length > 0) {
              allFieldsFilled = this._validateActionsAutoFill(autofillActions, 'inputs') && this._validateActionsAutoFill(autofillActions, 'outputs');
            } else if (calculateActions && calculateActions.length > 0) {
              allFieldsFilled = this._validateActionsCalculateFilling(calculateActions);
            }
          }
        }

        return allFieldsFilled;
      }
    }, {
      key: "_validateConditionsFilling",
      value: function _validateConditionsFilling() {
        var conditions = this.conditions;

        for (var i = 0; i < conditions.length; i++) {
          var condition = conditions[i];
          var operands = condition.operands,
              operator = condition.operator;

          if (operands[0].value == '' || !operator) {
            return false;
          } else if (operator && this._isBinary(operator) && !(operands[1] && !!operands[1].value && operands[1].value != '')) {
            return false;
          }
        }

        return true;
      }
    }, {
      key: "_validateInputOutputs",
      value: function _validateInputOutputs(autofillActions) {
        return this._validateActionsAutoFill(autofillActions, 'inputs') && this._validateActionsAutoFill(autofillActions, 'outputs');
      }
    }]);

    return RuleEditor;
  }(_metalComponent["default"]);

  RuleEditor.STATE = {
    actionTypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      label: _metalState.Config.string(),
      value: _metalState.Config.string()
    })).internal().value([{
      label: Liferay.Language.get('show'),
      value: 'show'
    }, {
      label: Liferay.Language.get('enable'),
      value: 'enable'
    }, {
      label: Liferay.Language.get('require'),
      value: 'require'
    }, {
      label: Liferay.Language.get('autofill'),
      value: 'auto-fill'
    }, {
      label: Liferay.Language.get('calculate'),
      value: 'calculate'
    }, {
      label: Liferay.Language.get('jump-to-page'),
      value: 'jump-to-page'
    }]),
    actions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      action: _metalState.Config.string(),
      calculatorFields: _metalState.Config.arrayOf(fieldOptionStructure).value([]),
      expression: _metalState.Config.string(),
      hasRequiredInputs: _metalState.Config.bool(),
      inputs: _metalState.Config.object(),
      label: _metalState.Config.string(),
      outputs: _metalState.Config.object(),
      target: _metalState.Config.string()
    })).internal().setter('_setActions').value([]),
    actionsFieldOptions: _metalState.Config.arrayOf(fieldOptionStructure).internal().valueFn('_actionsFieldOptionsValueFn'),

    /**
     * Used for tracking which action we are currently focused on
     * when trying to delete an action.
     * @default 0
     * @instance
     * @memberof RuleEditor
     * @type {Number}
     */
    activeActionIndex: _metalState.Config.number().value(-1),

    /**
     * Used for tracking which condition we are currently focused on
     * when trying to delete a condition.
     * @default 0
     * @instance
     * @memberof RuleEditor
     * @type {Number}
     */
    activeConditionIndex: _metalState.Config.number().value(-1),
    calculatorFunctions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      label: _metalState.Config.string(),
      tooltip: _metalState.Config.string(),
      value: _metalState.Config.string()
    })).internal().value([]),
    calculatorResultOptions: _metalState.Config.arrayOf(fieldOptionStructure).internal().valueFn('_calculatorResultOptionsValueFn'),

    /**
     * @default 0
     * @instance
     * @memberof RuleEditor
     * @type {?array}
     */
    conditions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      operands: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        dataType: _metalState.Config.string(),
        label: _metalState.Config.string(),
        repeatable: _metalState.Config.bool(),
        type: _metalState.Config.string(),
        value: _metalState.Config.string()
      })),
      operator: _metalState.Config.string()
    })).internal().setter('_setConditions').value([]),
    conditionsFieldOptions: _metalState.Config.arrayOf(fieldOptionStructure).internal().valueFn('_conditionsFieldOptionsValueFn'),
    dataProvider: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string(),
      name: _metalState.Config.string(),
      uuid: _metalState.Config.string()
    })).internal(),
    dataProviderInstanceParameterSettingsURL: _metalState.Config.string().required(),
    dataProviderInstancesURL: _metalState.Config.string().required(),
    deletedFields: _metalState.Config.arrayOf(_metalState.Config.string()).value([]),
    fixedOptions: _metalState.Config.arrayOf(fieldOptionStructure).value([{
      dataType: 'user',
      label: Liferay.Language.get('user'),
      name: 'user',
      value: 'user'
    }]),
    functionsMetadata: _metalState.Config.shapeOf({
      number: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        parameterTypes: _metalState.Config.array(),
        returnType: _metalState.Config.string()
      })),
      text: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        parameterTypes: _metalState.Config.array(),
        returnType: _metalState.Config.string()
      })),
      user: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        parameterTypes: _metalState.Config.array(),
        returnType: _metalState.Config.string()
      }))
    }),
    functionsURL: _metalState.Config.string(),
    invalidRule: _metalState.Config.bool().value(true),
    loadingDataProviderOptions: _metalState.Config.bool(),
    logicalOperator: _metalState.Config.string().internal().value('or'),
    pageOptions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      dataType: _metalState.Config.string(),
      name: _metalState.Config.string(),
      options: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        value: _metalState.Config.string()
      })),
      type: _metalState.Config.string(),
      value: _metalState.Config.string()
    })).internal().value([]),
    pages: _metalState.Config.array().required(),
    readOnly: _metalState.Config.bool().value(false),
    roles: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string(),
      name: _metalState.Config.string()
    })).valueFn('_rolesValueFn'),

    /**
     * @default 0
     * @instance
     * @memberof RuleEditor
     * @type {?array}
     */
    rule: _metalState.Config.shapeOf(_defineProperty({
      actions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        action: _metalState.Config.string(),
        calculatorFields: _metalState.Config.arrayOf(fieldOptionStructure).value([]),
        ddmDataProviderInstanceUUID: _metalState.Config.string(),
        expression: _metalState.Config.string(),
        inputs: _metalState.Config.object(),
        label: _metalState.Config.string(),
        outputs: _metalState.Config.object(),
        target: _metalState.Config.string()
      })),
      conditions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        operands: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
          label: _metalState.Config.string(),
          repeatable: _metalState.Config.bool(),
          type: _metalState.Config.string(),
          value: _metalState.Config.string()
        })),
        operator: _metalState.Config.string()
      }))
    }, 'logical-operator', _metalState.Config.string())),
    ruleEditedIndex: _metalState.Config.number(),
    secondOperandList: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      name: _metalState.Config.string(),
      value: _metalState.Config.string()
    })).value([{
      value: Liferay.Language.get('value')
    }, {
      name: 'field',
      value: Liferay.Language.get('other-field')
    }]),

    /**
     * @default undefined
     * @instance
     * @memberof RuleEditor
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };

  _metalSoy["default"].register(RuleEditor, _RuleEditorSoy["default"]);

  var _default = RuleEditor;
  exports["default"] = _default;
  //# sourceMappingURL=RuleEditor.es.js.map
});
//# sourceMappingURL=RuleEditor.es.js.map