Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.47/js/components/RuleBuilder/RuleBuilder.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../components/RuleEditor/RuleEditor.es', '../../components/RuleList/RuleList.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.RuleBuilder = exports["default"] = void 0;

  var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _RuleEditor = _interopRequireDefault(require("../../components/RuleEditor/RuleEditor.es"));

  var _RuleList = _interopRequireDefault(require("../../components/RuleList/RuleList.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Builder.
   * @extends Component
   */
  var RuleBuilder =
  /*#__PURE__*/
  function (_Component) {
    _inherits(RuleBuilder, _Component);

    function RuleBuilder() {
      _classCallCheck(this, RuleBuilder);

      return _possibleConstructorReturn(this, _getPrototypeOf(RuleBuilder).apply(this, arguments));
    }

    _createClass(RuleBuilder, [{
      key: "created",
      value: function created() {
        this._fetchDataProvider();

        this._fetchRoles();
      }
    }, {
      key: "isViewMode",
      value: function isViewMode() {
        var mode = this.state.mode;
        return mode === 'view';
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            dataProviderInstanceParameterSettingsURL = _this$props.dataProviderInstanceParameterSettingsURL,
            dataProviderInstancesURL = _this$props.dataProviderInstancesURL,
            functionsMetadata = _this$props.functionsMetadata,
            functionsURL = _this$props.functionsURL,
            pages = _this$props.pages,
            spritemap = _this$props.spritemap;
        var _this$state = this.state,
            dataProvider = _this$state.dataProvider,
            index = _this$state.index,
            mode = _this$state.mode,
            roles = _this$state.roles,
            rules = _this$state.rules;
        IncrementalDOM.elementOpen("div", null, null, "class", "container");
        iDOMHelpers.renderArbitrary(mode === 'create' && IncrementalDOM.elementVoid(_RuleEditor["default"], 'create', ["key", 'create', "ref", "RuleEditor"], "actions", [], "conditions", [], "dataProvider", dataProvider, "dataProviderInstanceParameterSettingsURL", dataProviderInstanceParameterSettingsURL, "dataProviderInstancesURL", dataProviderInstancesURL, "events", {
          ruleAdded: this._handleRuleAdded.bind(this),
          ruleCancelled: this._handleRuleCancelled.bind(this),
          ruleDeleted: this._handleRuleDeleted.bind(this),
          ruleEdited: this._handleRuleEdited.bind(this)
        }, "functionsMetadata", functionsMetadata, "functionsURL", functionsURL, "pages", pages, "roles", roles, "spritemap", spritemap));
        iDOMHelpers.renderArbitrary(mode === 'edit' && IncrementalDOM.elementVoid(_RuleEditor["default"], 'edit', ["key", 'edit', "ref", "RuleEditor"], "dataProvider", dataProvider, "dataProviderInstanceParameterSettingsURL", dataProviderInstanceParameterSettingsURL, "dataProviderInstancesURL", dataProviderInstancesURL, "events", {
          ruleAdded: this._handleRuleSaved.bind(this),
          ruleCancelled: this._handleRuleCancelled.bind(this)
        }, "functionsMetadata", functionsMetadata, "functionsURL", functionsURL, "pages", pages, "roles", roles, "rule", rules[index], "ruleEditedIndex", index, "spritemap", spritemap));
        iDOMHelpers.renderArbitrary(mode === 'view' && IncrementalDOM.elementVoid(_RuleList["default"], null, null, "dataProvider", dataProvider, "events", {
          ruleAdded: this._handleRuleAdded.bind(this),
          ruleCancelled: this._handleRuleCancelled.bind(this),
          ruleDeleted: this._handleRuleDeleted.bind(this),
          ruleEdited: this._handleRuleEdited.bind(this)
        }, "pages", pages, "roles", roles, "rules", rules, "spritemap", spritemap, "ref", "RuleList"));
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "showRuleCreation",
      value: function showRuleCreation() {
        this.setState({
          mode: 'create'
        });
      }
    }, {
      key: "showRuleList",
      value: function showRuleList() {
        this.setState({
          mode: 'view'
        });
      }
    }, {
      key: "willReceiveProps",
      value: function willReceiveProps(_ref) {
        var rules = _ref.rules;

        if (rules && rules.newVal) {
          this.setState({
            rules: rules.newVal
          });
        }
      }
    }, {
      key: "_fetchDataProvider",
      value: function _fetchDataProvider() {
        var _this = this;

        var dataProviderInstancesURL = this.props.dataProviderInstancesURL;
        (0, _fetch.makeFetch)({
          method: 'GET',
          url: dataProviderInstancesURL
        }).then(function (responseData) {
          if (!_this.isDisposed()) {
            _this.setState({
              dataProvider: responseData.map(function (data) {
                return _objectSpread({}, data, {
                  label: data.name,
                  value: data.id
                });
              })
            });
          }
        })["catch"](function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "_fetchRoles",
      value: function _fetchRoles() {
        var _this2 = this;

        var rolesURL = this.props.rolesURL;
        (0, _fetch.makeFetch)({
          method: 'GET',
          url: rolesURL
        }).then(function (responseData) {
          if (!_this2.isDisposed()) {
            _this2.setState({
              roles: responseData.map(function (data) {
                return _objectSpread({}, data, {
                  label: data.name,
                  value: data.id
                });
              })
            });
          }
        })["catch"](function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "_handleRuleAdded",
      value: function _handleRuleAdded(event) {
        var dispatch = this.context.dispatch;
        dispatch('ruleAdded', event);
        this.showRuleList();
      }
    }, {
      key: "_handleRuleCancelled",
      value: function _handleRuleCancelled() {
        var _this3 = this;

        var dispatch = this.context.dispatch;
        var index = this.state.index;
        var rules = this.state.rules.map(function (rule, ruleIndex) {
          return index === ruleIndex ? _this3.state.originalRule : rule;
        });
        this.setState({
          mode: 'view',
          rules: rules
        });
        dispatch('ruleCancelled');
      }
    }, {
      key: "_handleRuleDeleted",
      value: function _handleRuleDeleted(_ref2) {
        var ruleId = _ref2.ruleId;
        var dispatch = this.context.dispatch;
        dispatch('ruleDeleted', {
          ruleId: ruleId
        });
      }
    }, {
      key: "_handleRuleEdited",
      value: function _handleRuleEdited(_ref3) {
        var ruleId = _ref3.ruleId;
        var rules = this.state.rules;
        ruleId = parseInt(ruleId, 10);
        this.setState({
          index: ruleId,
          mode: 'edit',
          originalRule: JSON.parse(JSON.stringify(rules[ruleId]))
        });
      }
    }, {
      key: "_handleRuleSaved",
      value: function _handleRuleSaved(event) {
        var dispatch = this.context.dispatch;
        dispatch('ruleSaved', _objectSpread({}, event, {
          ruleId: event.ruleEditedIndex
        }));
        this.showRuleList();
      }
    }, {
      key: "_setRulesValueFn",
      value: function _setRulesValueFn() {
        return this.props.rules;
      }
    }]);

    return RuleBuilder;
  }(_metalJsx["default"]);

  exports.RuleBuilder = RuleBuilder;
  RuleBuilder.PROPS = {
    dataProviderInstanceParameterSettingsURL: _metalState.Config.string().required(),
    dataProviderInstancesURL: _metalState.Config.string().required(),
    functionsMetadata: _metalState.Config.object({
      number: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        parameterTypes: _metalState.Config.array(),
        returnType: _metalState.Config.string()
      })),
      text: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        parameterTypes: _metalState.Config.array(),
        returnType: _metalState.Config.string()
      })),
      user: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        label: _metalState.Config.string(),
        name: _metalState.Config.string(),
        parameterTypes: _metalState.Config.array(),
        returnType: _metalState.Config.string()
      }))
    }),
    functionsURL: _metalState.Config.string().required(),
    pages: _metalState.Config.array().required(),
    rolesURL: _metalState.Config.string().required(),
    rules: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      actions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        action: _metalState.Config.string(),
        label: _metalState.Config.string(),
        target: _metalState.Config.string()
      })),
      conditions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        operands: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
          label: _metalState.Config.string(),
          repeatable: _metalState.Config.bool(),
          type: _metalState.Config.string(),
          value: _metalState.Config.string()
        })),
        operator: _metalState.Config.string()
      })),
      logicalOperator: _metalState.Config.string()
    })).value([]),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof Form
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };
  RuleBuilder.STATE = {
    dataProvider: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string(),
      name: _metalState.Config.string(),
      uuid: _metalState.Config.string()
    })).internal(),

    /**
     * @default
     * @instance
     * @memberof RuleBuilder
     *
     */
    index: _metalState.Config.number(),
    mode: _metalState.Config.oneOf(['view', 'edit', 'create']).value('view'),
    originalRule: _metalState.Config.object(),
    roles: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string(),
      name: _metalState.Config.string()
    })).internal(),
    rules: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      actions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        action: _metalState.Config.string(),
        label: _metalState.Config.string(),
        target: _metalState.Config.string()
      })),
      conditions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        operands: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
          label: _metalState.Config.string(),
          repeatable: _metalState.Config.bool(),
          type: _metalState.Config.string(),
          value: _metalState.Config.string()
        })),
        operator: _metalState.Config.string()
      })),
      logicalOperator: _metalState.Config.string()
    })).valueFn('_setRulesValueFn')
  };
  var _default = RuleBuilder;
  exports["default"] = _default;
  //# sourceMappingURL=RuleBuilder.es.js.map
});
//# sourceMappingURL=RuleBuilder.es.js.map