Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.46/js/util/pageSupport.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', './strings.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.pageOptions = pageOptions;
  exports.maxPageIndex = maxPageIndex;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _stringsEs = require("./strings.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function pageOptions(pages) {
    var maxPageIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var pageOptions = [];

    for (var pageIndex = maxPageIndex + 2; pageIndex <= pages.length; pageIndex++) {
      var pageTitle = "".concat(pageIndex, " ").concat((0, _stringsEs.sub)(Liferay.Language.get('untitled-page-x-of-x'), [pageIndex, pages.length]));

      if (pages[pageIndex - 1].title) {
        pageTitle = "".concat(pageIndex, " ").concat(pages[pageIndex - 1].title);
      }

      pageOptions.push({
        label: pageTitle,
        name: pageIndex.toString(),
        value: pageIndex.toString()
      });
    }

    return pageOptions;
  }

  function maxPageIndex(conditions, pages) {
    var pageIndexes = [];
    var visitor = new _visitors.PagesVisitor(pages);

    if (conditions.length && conditions[0].operands[0].value) {
      conditions.forEach(function (condition) {
        visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
          if (field.fieldName === condition.operands[0].value) {
            pageIndexes.push(pageIndex);
          }
        });
      });
    }

    var maxPageIndex = Math.max.apply(Math, pageIndexes);
    return isFinite(maxPageIndex) ? maxPageIndex : 0;
  }
  //# sourceMappingURL=pageSupport.es.js.map
});
//# sourceMappingURL=pageSupport.es.js.map