'use strict';

Liferay.Loader.define('dynamic-data-mapping-form-builder$object-hash@1.3.1/gulpfile', ['module', 'exports', 'require', 'dynamic-data-mapping-form-builder$gulp', 'dynamic-data-mapping-form-builder$gulp-jshint', 'dynamic-data-mapping-form-builder$gulp-exec', 'dynamic-data-mapping-form-builder$jshint-stylish', 'dynamic-data-mapping-form-builder$gulp-browserify', 'dynamic-data-mapping-form-builder$gulp-uglify', 'dynamic-data-mapping-form-builder$gulp-rename', 'dynamic-data-mapping-form-builder$karma', 'dynamic-data-mapping-form-builder$gulp-coveralls', 'dynamic-data-mapping-form-builder$gulp-istanbul', 'dynamic-data-mapping-form-builder$gulp-mocha'], function (module, exports, require) {
  var define = undefined;
  var gulp = require('dynamic-data-mapping-form-builder$gulp');
  var jshint = require('dynamic-data-mapping-form-builder$gulp-jshint');
  var exec = require('dynamic-data-mapping-form-builder$gulp-exec');
  var stylish = require('dynamic-data-mapping-form-builder$jshint-stylish');
  var browserify = require('dynamic-data-mapping-form-builder$gulp-browserify');
  var uglify = require('dynamic-data-mapping-form-builder$gulp-uglify');
  var rename = require('dynamic-data-mapping-form-builder$gulp-rename');
  var karma = require('dynamic-data-mapping-form-builder$karma');
  var coveralls = require('dynamic-data-mapping-form-builder$gulp-coveralls');
  var istanbul = require('dynamic-data-mapping-form-builder$gulp-istanbul');
  var mocha = require('dynamic-data-mapping-form-builder$gulp-mocha');

  var paths = {
    index: './index.js',
    tests: './test/**/*.js'
  };

  function preTest(src) {
    return gulp.src(src).pipe(istanbul()).pipe(istanbul.hookRequire());
  }

  function test(src) {
    return gulp.src(src).pipe(mocha()).pipe(istanbul.writeReports());
  }

  function testKarma(done) {
    new karma.Server({
      configFile: __dirname + '/karma.conf.js',
      singleRun: true
    }, done).start();
  }

  function lint(src) {
    return gulp.src(src).pipe(jshint('.jshintrc')).pipe(jshint.reporter(stylish));
  }

  gulp.task('dist', function () {
    gulp.src([paths.index]).pipe(browserify({
      insertGlobals: true,
      debug: true,
      standalone: 'objectHash'
    })).pipe(rename('object_hash.js')).pipe(uglify({ outSourceMap: true })).pipe(gulp.dest('./dist'));
    // tests
    gulp.src([paths.tests]).pipe(browserify()).pipe(rename('object_hash_test.js')).pipe(gulp.dest('./dist'));
  });

  gulp.task('pre-test', function () {
    preTest([paths.index]);
  });

  gulp.task('test', ['pre-test'], function () {
    test([paths.tests]);
  });

  gulp.task('karma', function () {
    testKarma();
  });

  gulp.task('coveralls', function () {
    gulp.src('coverage/**/lcov.info').pipe(coveralls());
  });

  gulp.task('lint', function () {
    return lint([paths.index]);
  });

  gulp.task('watch', function () {

    // watch and lint any files that are added or changed
    gulp.watch([paths.index, paths.tests], function (event) {
      if (event.type !== 'deleted') {
        lint([event.path]);
      }
    });

    // run the tests when something changes
    gulp.watch([paths.index, paths.tests], ['test', 'karma']);
  });

  gulp.task('default', ['watch']);
});
//# sourceMappingURL=gulpfile.js.map