"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.34/js/expressions/Tokenizer.es", ['module', 'exports', 'require', './Token.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _Token = _interopRequireDefault(require("./Token.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  var OPERATORS = ['*', '/', '+', '-'];
  /**
   * Tokenizer.
   * Transforms an expression into tokens and token into an expression
   */

  var Tokenizer =
  /*#__PURE__*/
  function () {
    function Tokenizer() {
      _classCallCheck(this, Tokenizer);
    }

    _createClass(Tokenizer, null, [{
      key: "stringifyTokens",
      value: function stringifyTokens(tokens) {
        return tokens.reduce(function (expression, token) {
          var value = token.value;

          if (token.type === _Token["default"].VARIABLE) {
            value = "[".concat(value, "]");
          }

          return expression + value;
        }, '');
      }
    }, {
      key: "tokenize",
      value: function tokenize(str) {
        var result = [];
        str = str.replace(/\s/g, '');
        var functionBuffer = [];
        var numberBuffer = [];
        var variableBuffer = [];

        var emptyNumberBuffer = function emptyNumberBuffer() {
          if (numberBuffer.length) {
            result.push(new _Token["default"](_Token["default"].LITERAL, numberBuffer.join('')));
            numberBuffer = [];
          }
        };

        var emptyFunctionBuffer = function emptyFunctionBuffer() {
          result.push(new _Token["default"](_Token["default"].FUNCTION, functionBuffer.join('')));
          functionBuffer = [];
        };

        var emptyVariableBuffer = function emptyVariableBuffer() {
          result.push(new _Token["default"](_Token["default"].VARIABLE, variableBuffer.join('')));
          variableBuffer = [];
        };

        var inputBuffer = str.split('');

        while (inputBuffer.length) {
          var _char = inputBuffer.shift();

          if (this.isDigit(_char)) {
            numberBuffer.push(_char);
          } else if (_char === '.') {
            numberBuffer.push(_char);
          } else if (this.isLeftBracket(_char)) {
            if (numberBuffer.length) {
              emptyNumberBuffer();
              result.push(new _Token["default"](_Token["default"].OPERATOR, '*'));
            }

            do {
              _char = inputBuffer.shift();

              if (this.isRightBracket(_char)) {
                emptyVariableBuffer();
                break;
              } else {
                variableBuffer.push(_char);
              }
            } while (inputBuffer.length);
          } else if (this.isLetter(_char)) {
            if (numberBuffer.length) {
              emptyNumberBuffer();
              result.push(new _Token["default"](_Token["default"].OPERATOR, '*'));
            }

            do {
              functionBuffer.push(_char);
              _char = inputBuffer.shift();
            } while (this.isLetter(_char));

            if (_char !== undefined) {
              inputBuffer.unshift(_char);
            }

            emptyFunctionBuffer();
          } else if (this.isOperator(_char)) {
            emptyNumberBuffer();
            result.push(new _Token["default"](_Token["default"].OPERATOR, _char));
          } else if (this.isLeftParenthesis(_char)) {
            if (numberBuffer.length) {
              emptyNumberBuffer();
              result.push(new _Token["default"](_Token["default"].OPERATOR, '*'));
            }

            result.push(new _Token["default"](_Token["default"].LEFT_PARENTHESIS, _char));
          } else if (this.isRightParenthesis(_char)) {
            emptyNumberBuffer();
            result.push(new _Token["default"](_Token["default"].RIGHT_PARENTHESIS, _char));
          } else {
            throw new Error("Unsupported character ".concat(_char));
          }
        }

        if (numberBuffer.length) {
          emptyNumberBuffer();
        }

        if (variableBuffer.length) {
          emptyVariableBuffer();
        }

        return result;
      }
    }, {
      key: "isDigit",
      value: function isDigit(_char2) {
        return _char2 !== undefined && /[0-9]/.test(_char2);
      }
    }, {
      key: "isLetter",
      value: function isLetter(_char3) {
        return _char3 !== undefined && /[a-zA-Z]/.test(_char3);
      }
    }, {
      key: "isLeftBracket",
      value: function isLeftBracket(_char4) {
        return _char4 === '[';
      }
    }, {
      key: "isRightBracket",
      value: function isRightBracket(_char5) {
        return _char5 === ']';
      }
    }, {
      key: "isLeftParenthesis",
      value: function isLeftParenthesis(_char6) {
        return _char6 === '(';
      }
    }, {
      key: "isRightParenthesis",
      value: function isRightParenthesis(_char7) {
        return _char7 === ')';
      }
    }, {
      key: "isOperator",
      value: function isOperator(_char8) {
        return OPERATORS.includes(_char8);
      }
    }]);

    return Tokenizer;
  }();

  var _default = Tokenizer;
  exports["default"] = _default;
  //# sourceMappingURL=Tokenizer.es.js.map
});
//# sourceMappingURL=Tokenizer.es.js.map