"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.34/js/components/LayoutProvider/util/focusedField.es", ['module', 'exports', 'require', './fields.es', 'dynamic-data-mapping-form-renderer/js/util/fields.es', './settings.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateFocusedField = exports.updateFocusedFieldOptions = exports.updateFocusedFieldProperty = exports.updateFocusedFieldLabel = exports.updateFocusedFieldDataType = exports.updateFocusedFieldName = void 0;

  var _fields = require("./fields.es");

  var _fields2 = require("dynamic-data-mapping-form-renderer/js/util/fields.es");

  var _settings = require("./settings.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var shouldAutoGenerateName = function shouldAutoGenerateName(defaultLanguageId, editingLanguageId, focusedField) {
    var fieldName = focusedField.fieldName,
        label = focusedField.label;
    return defaultLanguageId === editingLanguageId && fieldName.indexOf((0, _fields2.normalizeFieldName)(label)) === 0;
  };

  var updateFocusedFieldName = function updateFocusedFieldName(state, editingLanguageId, focusedField, value) {
    var _focusedField = focusedField,
        fieldName = _focusedField.fieldName,
        label = _focusedField.label;
    var normalizedFieldName = (0, _fields2.normalizeFieldName)(value);
    var pages = state.pages;
    var newFieldName;

    if (normalizedFieldName !== '') {
      newFieldName = (0, _fields.generateFieldName)(pages, value, fieldName);
    } else {
      newFieldName = (0, _fields.generateFieldName)(pages, label, fieldName);
    }

    if (newFieldName) {
      var _focusedField2 = focusedField,
          settingsContext = _focusedField2.settingsContext;
      settingsContext = _objectSpread({}, settingsContext, {
        pages: (0, _fields.updateFieldValidationProperty)(settingsContext.pages, fieldName, 'fieldName', newFieldName)
      });
      focusedField = _objectSpread({}, focusedField, {
        fieldName: newFieldName,
        settingsContext: (0, _settings.updateSettingsContextProperty)(editingLanguageId, settingsContext, 'name', newFieldName)
      });
    }

    return focusedField;
  };

  exports.updateFocusedFieldName = updateFocusedFieldName;

  var updateFocusedFieldDataType = function updateFocusedFieldDataType(editingLanguageId, focusedField, value) {
    var settingsContext = focusedField.settingsContext;
    settingsContext = _objectSpread({}, settingsContext, {
      pages: (0, _fields.updateFieldValidationProperty)(settingsContext.pages, focusedField.fieldName, 'dataType', value)
    });
    return _objectSpread({}, focusedField, {
      dataType: value,
      settingsContext: (0, _settings.updateSettingsContextProperty)(editingLanguageId, settingsContext, 'dataType', value)
    });
  };

  exports.updateFocusedFieldDataType = updateFocusedFieldDataType;

  var updateFocusedFieldLabel = function updateFocusedFieldLabel(state, defaultLanguageId, editingLanguageId, focusedField, value) {
    var fieldName = focusedField.fieldName,
        settingsContext = focusedField.settingsContext;

    if (shouldAutoGenerateName(defaultLanguageId, editingLanguageId, focusedField)) {
      var updates = updateFocusedFieldName(state, editingLanguageId, focusedField, value);
      fieldName = updates.fieldName;
      settingsContext = updates.settingsContext;
    }

    return _objectSpread({}, focusedField, {
      fieldName: fieldName,
      label: value,
      settingsContext: (0, _settings.updateSettingsContextProperty)(editingLanguageId, settingsContext, 'label', value)
    });
  };

  exports.updateFocusedFieldLabel = updateFocusedFieldLabel;

  var updateFocusedFieldProperty = function updateFocusedFieldProperty(editingLanguageId, focusedField, propertyName, propertyValue) {
    var _objectSpread2;

    return _objectSpread({}, focusedField, (_objectSpread2 = {}, _defineProperty(_objectSpread2, propertyName, propertyValue), _defineProperty(_objectSpread2, "settingsContext", (0, _settings.updateSettingsContextProperty)(editingLanguageId, focusedField.settingsContext, propertyName, propertyValue)), _objectSpread2));
  };

  exports.updateFocusedFieldProperty = updateFocusedFieldProperty;

  var updateFocusedFieldOptions = function updateFocusedFieldOptions(editingLanguageId, focusedField, value) {
    var options = value[editingLanguageId];
    return _objectSpread({}, focusedField, {
      options: options,
      settingsContext: (0, _settings.updateSettingsContextProperty)(editingLanguageId, focusedField.settingsContext, 'options', value)
    });
  };

  exports.updateFocusedFieldOptions = updateFocusedFieldOptions;

  var updateFocusedField = function updateFocusedField(state, defaultLanguageId, editingLanguageId, fieldName, value) {
    var focusedField = state.focusedField;

    if (fieldName === 'dataType') {
      focusedField = _objectSpread({}, focusedField, {}, updateFocusedFieldDataType(editingLanguageId, focusedField, value));
    } else if (fieldName === 'label') {
      focusedField = _objectSpread({}, focusedField, {}, updateFocusedFieldLabel(state, defaultLanguageId, editingLanguageId, focusedField, value));
    } else if (fieldName === 'name') {
      focusedField = _objectSpread({}, focusedField, {}, updateFocusedFieldName(state, editingLanguageId, focusedField, value));
    } else if (fieldName === 'options') {
      focusedField = _objectSpread({}, focusedField, {}, updateFocusedFieldOptions(editingLanguageId, focusedField, value));
    } else {
      focusedField = _objectSpread({}, focusedField, {}, updateFocusedFieldProperty(editingLanguageId, focusedField, fieldName, value));
    }

    return focusedField;
  };

  exports.updateFocusedField = updateFocusedField;
  //# sourceMappingURL=focusedField.es.js.map
});
//# sourceMappingURL=focusedField.es.js.map