"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.31/js/components/RuleBuilder/RulesSupport.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var clearTargetValue = function clearTargetValue(actions, index) {
    if (actions[index]) {
      actions[index].target = '';
    }

    return actions;
  };

  var clearFirstOperandValue = function clearFirstOperandValue(condition) {
    if (condition && condition.operands[0]) {
      condition.operands[0].type = '';
      condition.operands[0].value = '';
    }

    return condition;
  };

  var clearOperatorValue = function clearOperatorValue(condition) {
    if (condition) {
      condition.operator = '';
    }

    return condition;
  };

  var clearSecondOperandValue = function clearSecondOperandValue(condition) {
    if (condition && condition.operands[1]) {
      condition.operands[1].type = '';
      condition.operands[1].value = '';
    }

    return condition;
  };

  var clearAllConditionFieldValues = function clearAllConditionFieldValues(condition) {
    condition = clearFirstOperandValue(condition);
    condition = clearOperatorValue(condition);
    condition = clearSecondOperandValue(condition);
    return condition;
  };

  var syncActions = function syncActions(pages, actions) {
    var visitor = new _visitors.PagesVisitor(pages);
    actions.forEach(function (action, index) {
      var targetFieldExists = false;
      visitor.mapFields(function (_ref) {
        var fieldName = _ref.fieldName;

        if (action.target === fieldName) {
          targetFieldExists = true;
        }
      });

      if (!targetFieldExists) {
        actions = clearTargetValue(actions, index);
      }
    });
    return actions;
  };

  var _default = {
    clearAllConditionFieldValues: clearAllConditionFieldValues,
    clearFirstOperandValue: clearFirstOperandValue,
    clearOperatorValue: clearOperatorValue,
    clearSecondOperandValue: clearSecondOperandValue,
    clearTargetValue: clearTargetValue,
    syncActions: syncActions
  };
  exports.default = _default;
  //# sourceMappingURL=RulesSupport.es.js.map
});
//# sourceMappingURL=RulesSupport.es.js.map