'use strict';

Liferay.Loader.define('metal-dom@2.16.2/src/events', ['module', 'exports', 'require'], function (module, exports, require) {
	import { isServerSide } from 'metal';
	import { registerCustomEvent, contains } from './dom';
	import features from './features';

	/**
  * Register custom events for event delegation.
  */
	function registerEvents() {
		const mouseEventMap = {
			mouseenter: 'mouseover',
			mouseleave: 'mouseout',
			pointerenter: 'pointerover',
			pointerleave: 'pointerout'
		};
		Object.keys(mouseEventMap).forEach(function (eventName) {
			registerCustomEvent(eventName, {
				delegate: true,
				handler: function (callback, event) {
					const related = event.relatedTarget;
					const target = event.delegateTarget;
					// eslint-disable-next-line
					if (!related || related !== target && !contains(target, related)) {
						event.customType = eventName;
						return callback(event);
					}
				},
				originalEvent: mouseEventMap[eventName]
			});
		});

		const animationEventMap = {
			animation: 'animationend',
			transition: 'transitionend'
		};
		Object.keys(animationEventMap).forEach(function (eventType) {
			const eventName = animationEventMap[eventType];
			registerCustomEvent(eventName, {
				event: true,
				delegate: true,
				handler: function (callback, event) {
					event.customType = eventName;
					return callback(event);
				},
				originalEvent: features.checkAnimationEventName()[eventType]
			});
		});
	}

	if (!isServerSide()) {
		registerEvents();
	}
});
//# sourceMappingURL=events.js.map