'use strict';

Liferay.Loader.define("metal-dom@2.16.2/lib/globalEvalStyles", ['module', 'exports', 'require', 'metal', './dom'], function (module, exports, require) {
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require('metal');

	var _dom = require('./dom');

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	/**
  * Utility functions for running styles.
  */
	var globalEvalStyles = function () {
		function globalEvalStyles() {
			_classCallCheck(this, globalEvalStyles);
		}

		_createClass(globalEvalStyles, null, [{
			key: 'run',

			/**
    * Evaluates the given style.
    * @param {string} text
    * @param {function()=} appendFn Optional function to append the node
    *   into document.
    * @return {Element} style
    */
			value: function run(text, appendFn) {
				var style = document.createElement('style');
				style.innerHTML = text;
				if (appendFn) {
					appendFn(style);
				} else {
					document.head.appendChild(style);
				}
				return style;
			}

			/**
    * Evaluates the given style file.
    * @param {string} href The file's path.
    * @param {function()=} defaultFn Optional function to be called
    *   when the styles has been run.
    * @param {function()=} appendFn Optional function to append the node
    *   into document.
    * @return {Element} style
    */

		}, {
			key: 'runFile',
			value: function runFile(href, defaultFn, appendFn) {
				var link = document.createElement('link');
				link.rel = 'stylesheet';
				link.href = href;
				globalEvalStyles.runStyle(link, defaultFn, appendFn);
				return link;
			}

			/**
    * Evaluates the code referenced by the given style/link element.
    * @param {!Element} style
    * @param {function()=} defaultFn Optional function to be called
    *   when the script has been run.
    * @param {function()=} appendFn Optional function to append the node
    *   into document.
    *  @return {Element} style
    */

		}, {
			key: 'runStyle',
			value: function runStyle(style, defaultFn, appendFn) {
				var callback = function callback() {
					defaultFn && defaultFn();
				};
				if (style.rel && style.rel !== 'stylesheet') {
					_metal.async.nextTick(callback);
					return;
				}

				if (style.tagName === 'STYLE') {
					_metal.async.nextTick(callback);
				} else {
					(0, _dom.once)(style, 'load', callback);
					(0, _dom.once)(style, 'error', callback);
				}

				if (appendFn) {
					appendFn(style);
				} else {
					document.head.appendChild(style);
				}

				return style;
			}

			/**
    * Evaluates any style present in the given element.
    * @param {!Element} element
    * @param {function()=} defaultFn Optional function to be called when the
    *   style has been run.
    * @param {function()=} appendFn Optional function to append the node
    *   into document.
    */

		}, {
			key: 'runStylesInElement',
			value: function runStylesInElement(element, defaultFn, appendFn) {
				var styles = element.querySelectorAll('style,link');
				if (styles.length === 0 && defaultFn) {
					_metal.async.nextTick(defaultFn);
					return;
				}

				var loadCount = 0;
				var callback = function callback() {
					if (defaultFn && ++loadCount === styles.length) {
						_metal.async.nextTick(defaultFn);
					}
				};
				for (var i = 0; i < styles.length; i++) {
					globalEvalStyles.runStyle(styles[i], callback, appendFn);
				}
			}
		}]);

		return globalEvalStyles;
	}();

	exports.default = globalEvalStyles;
});
//# sourceMappingURL=globalEvalStyles.js.map