/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.CalculateDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer.DDMFormRuleActionSerializer;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer.DDMFormRuleSerializerContext;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CalculateDDMFormRuleActionSerializer
implements DDMFormRuleActionSerializer {
    private static final String _FUNCTION_CALL_BINARY_EXPRESSION_FORMAT = "%s('%s', %s)";
    private static final String _FUNCTION_CALL_UNARY_EXPRESSION_FORMAT = "%s('%s')";
    private final CalculateDDMFormRuleAction _calculateDDMFormRuleAction;

    public CalculateDDMFormRuleActionSerializer(CalculateDDMFormRuleAction calculateDDMFormRuleAction) {
        this._calculateDDMFormRuleAction = calculateDDMFormRuleAction;
    }

    @Override
    public String serialize(DDMFormRuleSerializerContext ddmFormRuleSerializerContext) {
        DDMForm ddmForm = (DDMForm)ddmFormRuleSerializerContext.getAttribute("form");
        Map ddmFormFieldMap = ddmForm.getDDMFormFieldsMap(true);
        String expression = this.removeBrackets(this._calculateDDMFormRuleAction.getExpression());
        Set keySet = ddmFormFieldMap.keySet();
        Stream<Object> ddmFormFieldStream = keySet.stream();
        ddmFormFieldStream = ddmFormFieldStream.filter(ddmFormField -> expression.contains((CharSequence)ddmFormField));
        Set<String> ddmFormFields = ddmFormFieldStream.collect(Collectors.toSet());
        String newExpression = expression;
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < expression.length(); ++i) {
            char token = expression.charAt(i);
            sb.append(token);
            String compareStr = sb.toString();
            boolean match = this.matchAnyField(compareStr, ddmFormFields);
            if (match) {
                if (start == Integer.MAX_VALUE) {
                    start = i;
                }
                if (i != expression.length() - 1) continue;
                end = expression.length();
                continue;
            }
            end = i;
            sb = new StringBuffer();
            if (end > start) {
                newExpression = this.replace(expression, newExpression, start, end);
            }
            start = Integer.MAX_VALUE;
            end = Integer.MIN_VALUE;
        }
        if (end > start) {
            newExpression = this.replace(expression, newExpression, start, end);
        }
        return String.format(_FUNCTION_CALL_BINARY_EXPRESSION_FORMAT, "calculate", this._calculateDDMFormRuleAction.getTarget(), newExpression);
    }

    protected boolean matchAnyField(String compareStr, Set<String> ddmFormFields) {
        for (String ddmFormField : ddmFormFields) {
            if (!ddmFormField.contains(compareStr)) continue;
            return true;
        }
        return false;
    }

    protected String removeBrackets(String expression) {
        return StringUtil.removeChars((String)expression, (char[])new char[]{'[', ']'});
    }

    protected String replace(String expression, String newExpression, int start, int end) {
        String matchFound = expression.substring(start, end);
        String matchReplacement = String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, "getValue", matchFound);
        return StringUtil.replaceFirst((String)newExpression, (String)matchFound, (String)matchReplacement, (int)start);
    }
}

