/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal.parser;

import com.liferay.dynamic.data.mapping.expression.internal.parser.generated.DDMExpressionBaseVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.parser.generated.DDMExpressionParser;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.spi.expression.DSLFunction;
import com.liferay.petra.sql.dsl.spi.expression.NullExpression;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DDMExpressionDSLExpressionVisitor
extends DDMExpressionBaseVisitor<Object> {
    private final Map<String, Object> _variables;

    public DDMExpressionDSLExpressionVisitor(Map<String, Object> variables) {
        this._variables = variables;
    }

    @Override
    public Object visitAdditionExpression(@NotNull DDMExpressionParser.AdditionExpressionContext additionExpressionContext) {
        Expression<?> expression1 = this._getExpression(this.visitChild(additionExpressionContext, 0));
        Expression<?> expression2 = this._getExpression(this.visitChild(additionExpressionContext, 2));
        return DSLFunctionFactoryUtil.add(expression1, expression2);
    }

    @Override
    public Object visitAndExpression(@NotNull DDMExpressionParser.AndExpressionContext andExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitAndExpression with and expression " + andExpressionContext.getText());
    }

    @Override
    public Object visitBooleanParenthesis(@NotNull DDMExpressionParser.BooleanParenthesisContext booleanParenthesisContext) {
        return this.visitChild(booleanParenthesisContext, 1);
    }

    @Override
    public Object visitDivisionExpression(@NotNull DDMExpressionParser.DivisionExpressionContext divisionExpressionContext) {
        Expression<?> expression1 = this._getExpression(this.visitChild(divisionExpressionContext, 0));
        Expression<?> expression2 = this._getExpression(this.visitChild(divisionExpressionContext, 2));
        return DSLFunctionFactoryUtil.caseWhenThen((Predicate)expression2.eq((Expression)new Scalar((Object)0)), (Expression)NullExpression.INSTANCE).whenThen(expression2.isNull(), (Expression)NullExpression.INSTANCE).elseEnd(DSLFunctionFactoryUtil.floatDivide(expression1, expression2));
    }

    @Override
    public Object visitEqualsExpression(@NotNull DDMExpressionParser.EqualsExpressionContext equalsExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitEqualsExpression with equals expression " + equalsExpressionContext.getText());
    }

    @Override
    public Object visitExpression(@NotNull DDMExpressionParser.ExpressionContext expressionContext) {
        DDMExpressionParser.LogicalOrExpressionContext logicalOrExpressionContext = expressionContext.logicalOrExpression();
        return logicalOrExpressionContext.accept(this);
    }

    @Override
    public Object visitFloatingPointLiteral(@NotNull DDMExpressionParser.FloatingPointLiteralContext floatingPointLiteralContext) {
        return new BigDecimal(floatingPointLiteralContext.getText());
    }

    @Override
    public Object visitFunctionCallExpression(@NotNull DDMExpressionParser.FunctionCallExpressionContext functionCallExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitFunctionCallExpression with function call expression " + functionCallExpressionContext.getText());
    }

    @Override
    public Object visitGreaterThanExpression(@NotNull DDMExpressionParser.GreaterThanExpressionContext greaterThanExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitGreaterThanExpression with greater than expression " + greaterThanExpressionContext.getText());
    }

    @Override
    public Object visitGreaterThanOrEqualsExpression(@NotNull DDMExpressionParser.GreaterThanOrEqualsExpressionContext greaterThanOrEqualsExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitGreaterThanOrEqualsExpression with greater than or equals expression " + greaterThanOrEqualsExpressionContext.getText());
    }

    @Override
    public Object visitIntegerLiteral(@NotNull DDMExpressionParser.IntegerLiteralContext integerLiteralContext) {
        return new BigDecimal(integerLiteralContext.getText());
    }

    @Override
    public Object visitLessThanExpression(@NotNull DDMExpressionParser.LessThanExpressionContext lessThanExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitLessThanExpression with less than expression " + lessThanExpressionContext.getText());
    }

    @Override
    public Object visitLessThanOrEqualsExpression(@NotNull DDMExpressionParser.LessThanOrEqualsExpressionContext lessThanOrEqualsExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitLessThanOrEqualsExpression with less than or equals expression " + lessThanOrEqualsExpressionContext.getText());
    }

    @Override
    public Object visitLogicalConstant(@NotNull DDMExpressionParser.LogicalConstantContext logicalConstantContext) {
        return Boolean.parseBoolean(logicalConstantContext.getText());
    }

    @Override
    public Object visitLogicalVariable(@NotNull DDMExpressionParser.LogicalVariableContext logicalVariableContext) {
        String variable = logicalVariableContext.getText();
        Object variableValue = this._variables.get(variable);
        if (variableValue == null && this._variables.size() > 1) {
            for (Map.Entry<String, Object> entry : this._variables.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!key.startsWith(variable) || value == null) continue;
                variableValue = value;
            }
        }
        if (variableValue == null) {
            throw new IllegalStateException(String.format("Variable \"%s\" not defined", variable));
        }
        return variableValue;
    }

    @Override
    public Object visitMinusExpression(@NotNull DDMExpressionParser.MinusExpressionContext minusExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitMinusExpression with minus expression " + minusExpressionContext.getText());
    }

    @Override
    public Object visitMultiplicationExpression(@NotNull DDMExpressionParser.MultiplicationExpressionContext multiplicationExpressionContext) {
        Expression<?> expression1 = this._getExpression(this.visitChild(multiplicationExpressionContext, 0));
        Expression<?> expression2 = this._getExpression(this.visitChild(multiplicationExpressionContext, 2));
        return DSLFunctionFactoryUtil.multiply(expression1, expression2);
    }

    @Override
    public Object visitNotEqualsExpression(@NotNull DDMExpressionParser.NotEqualsExpressionContext notEqualsExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitNotEqualsExpression with not equals expression " + notEqualsExpressionContext.getText());
    }

    @Override
    public Object visitNotExpression(@NotNull DDMExpressionParser.NotExpressionContext notExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitNotExpression with not expression " + notExpressionContext.getText());
    }

    @Override
    public Object visitNumericParenthesis(@NotNull DDMExpressionParser.NumericParenthesisContext numericParenthesisContext) {
        Expression<?> expression = this._getExpression(this.visitChild(numericParenthesisContext, 1));
        if (expression instanceof DSLFunction) {
            DSLFunction dslFunction = (DSLFunction)expression;
            return DSLFunctionFactoryUtil.withParentheses((Expression)dslFunction);
        }
        return expression;
    }

    @Override
    public Object visitNumericVariable(@NotNull DDMExpressionParser.NumericVariableContext numericVariableContext) {
        String variable = numericVariableContext.getText();
        Object variableValue = this._variables.get(variable);
        if (variableValue == null) {
            throw new IllegalStateException(String.format("Variable \"%s\" not defined", variable));
        }
        return variableValue;
    }

    @Override
    public Object visitOrExpression(@NotNull DDMExpressionParser.OrExpressionContext orExpressionContext) {
        throw new UnsupportedOperationException("Unsupported method visitOrExpression with or expression " + orExpressionContext.getText());
    }

    @Override
    public Object visitStringLiteral(@NotNull DDMExpressionParser.StringLiteralContext stringLiteralContext) {
        return StringUtil.unquote((String)stringLiteralContext.getText());
    }

    @Override
    public Object visitSubtractionExpression(@NotNull DDMExpressionParser.SubtractionExpressionContext subtractionExpressionContext) {
        Expression<?> expression1 = this._getExpression(this.visitChild(subtractionExpressionContext, 0));
        Expression<?> expression2 = this._getExpression(this.visitChild(subtractionExpressionContext, 2));
        return DSLFunctionFactoryUtil.subtract(expression1, expression2);
    }

    @Override
    public Object visitToFloatingPointArray(DDMExpressionParser.ToFloatingPointArrayContext toFloatingPointArrayContext) {
        return this._getBigDecimalArray(toFloatingPointArrayContext.FloatingPointLiteral());
    }

    @Override
    public Object visitToIntegerArray(DDMExpressionParser.ToIntegerArrayContext toIntegerArrayContext) {
        return this._getBigDecimalArray(toIntegerArrayContext.IntegerLiteral());
    }

    @Override
    public Object visitToStringArray(DDMExpressionParser.ToStringArrayContext toStringArrayContext) {
        List<TerminalNode> stringTerminalNodes = toStringArrayContext.STRING();
        String[] values = new String[stringTerminalNodes.size()];
        for (int i = 0; i < stringTerminalNodes.size(); ++i) {
            TerminalNode terminalNode = stringTerminalNodes.get(i);
            values[i] = StringUtil.unquote((String)terminalNode.getText());
        }
        return values;
    }

    protected <T> T visitChild(ParserRuleContext parserRuleContext, int childIndex) {
        ParseTree parseTree = parserRuleContext.getChild(childIndex);
        return (T)parseTree.accept(this);
    }

    private BigDecimal _getBigDecimal(Comparable<?> comparable) {
        if (comparable == null) {
            return BigDecimal.ZERO;
        }
        if (comparable instanceof BigDecimal) {
            return (BigDecimal)comparable;
        }
        String value = comparable.toString();
        if (Validator.isNull((String)value)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(value);
    }

    private BigDecimal[] _getBigDecimalArray(List<TerminalNode> terminalNodes) {
        BigDecimal[] values = new BigDecimal[terminalNodes.size()];
        for (int i = 0; i < terminalNodes.size(); ++i) {
            TerminalNode terminalNode = terminalNodes.get(i);
            values[i] = new BigDecimal(terminalNode.getText());
        }
        return values;
    }

    private Expression<?> _getExpression(Object object) {
        if (object instanceof BigDecimal) {
            object = this._getBigDecimal((Comparable)object);
        } else if (object instanceof Expression) {
            return (Expression)object;
        }
        return new Scalar(object);
    }
}

