/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandler;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionRegistry;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionEvaluatorVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionListener;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionModelVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionLexer;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionParser;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class DDMExpressionImpl<T>
implements DDMExpression<T> {
    private DDMExpressionActionHandler _ddmExpressionActionHandler;
    private DDMExpressionFieldAccessor _ddmExpressionFieldAccessor;
    private final Map<String, DDMExpressionFunctionFactory> _ddmExpressionFunctionFactories;
    private DDMExpressionObserver _ddmExpressionObserver;
    private DDMExpressionParameterAccessor _ddmExpressionParameterAccessor;
    private final DDMExpressionParser.ExpressionContext _expressionContext;
    private final Map<String, Object> _variables = new HashMap<String, Object>();

    public T evaluate() throws DDMExpressionException {
        try {
            DDMExpressionEvaluatorVisitor ddmExpressionEvaluatorVisitor = new DDMExpressionEvaluatorVisitor(this._ddmExpressionFunctionFactories, this._variables, this._ddmExpressionActionHandler, this._ddmExpressionFieldAccessor, this._ddmExpressionObserver, this._ddmExpressionParameterAccessor);
            return (T)this._expressionContext.accept(ddmExpressionEvaluatorVisitor);
        }
        catch (Exception exception) {
            throw new DDMExpressionException((Throwable)exception);
        }
    }

    public Expression getModel() {
        return this._expressionContext.accept(new DDMExpressionModelVisitor());
    }

    public void setVariable(String name, Object value) {
        if (value instanceof Number) {
            value = new BigDecimal(value.toString());
        }
        this._variables.put(name, value);
    }

    public void setVariables(Map<String, Object> variables) {
        this._variables.putAll(variables);
    }

    protected DDMExpressionImpl(DDMExpressionFunctionRegistry ddmExpressionFunctionRegistry, String expression) throws DDMExpressionException {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException();
        }
        DDMExpressionParser ddmExpressionParser = new DDMExpressionParser(new CommonTokenStream(new DDMExpressionLexer(new ANTLRInputStream(expression))));
        ddmExpressionParser.setErrorHandler(new BailErrorStrategy());
        try {
            this._expressionContext = ddmExpressionParser.expression();
        }
        catch (Exception exception) {
            throw new DDMExpressionException.InvalidSyntax((Throwable)exception);
        }
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        DDMExpressionListener ddmExpressionListener = new DDMExpressionListener();
        parseTreeWalker.walk(ddmExpressionListener, this._expressionContext);
        Set<String> ddmExpressionFunctionNames = ddmExpressionListener.getFunctionNames();
        this._ddmExpressionFunctionFactories = ddmExpressionFunctionRegistry.getDDMExpressionFunctionFactories(ddmExpressionFunctionNames);
        HashSet<String> undefinedDDMExpressionFunctionNames = new HashSet<String>(ddmExpressionFunctionNames);
        undefinedDDMExpressionFunctionNames.removeAll(this._ddmExpressionFunctionFactories.keySet());
        if (!undefinedDDMExpressionFunctionNames.isEmpty()) {
            throw new DDMExpressionException.FunctionNotDefined(undefinedDDMExpressionFunctionNames);
        }
        for (String variableName : ddmExpressionListener.getVariableNames()) {
            this._variables.put(variableName, null);
        }
    }

    protected Set<String> getExpressionVariableNames() {
        return this._variables.keySet();
    }

    protected void setDDMExpressionActionHandler(DDMExpressionActionHandler ddmExpressionActionHandler) {
        this._ddmExpressionActionHandler = ddmExpressionActionHandler;
    }

    protected void setDDMExpressionFieldAccessor(DDMExpressionFieldAccessor ddmExpressionFieldAccessor) {
        this._ddmExpressionFieldAccessor = ddmExpressionFieldAccessor;
    }

    protected void setDDMExpressionObserver(DDMExpressionObserver ddmExpressionObserver) {
        this._ddmExpressionObserver = ddmExpressionObserver;
    }

    protected void setDDMExpressionParameterAccessor(DDMExpressionParameterAccessor ddmExpressionParameterAccessor) {
        this._ddmExpressionParameterAccessor = ddmExpressionParameterAccessor;
    }
}

