/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandler;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionTracker;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionEvaluatorVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionListener;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionModelVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionLexer;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionParser;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class DDMExpressionImpl<T>
implements DDMExpression<T> {
    private DDMExpressionActionHandler _ddmExpressionActionHandler;
    private DDMExpressionFieldAccessor _ddmExpressionFieldAccessor;
    private final Set<String> _ddmExpressionFunctionNames;
    private DDMExpressionFunctionTracker _ddmExpressionFunctionTracker;
    private DDMExpressionObserver _ddmExpressionObserver;
    private DDMExpressionParameterAccessor _ddmExpressionParameterAccessor;
    private final DDMExpressionParser.ExpressionContext _expressionContext;
    private final String _expressionString;
    private final Map<String, Object> _variables = new HashMap<String, Object>();

    public T evaluate() throws DDMExpressionException {
        Map ddmExpressionFunctions = this._ddmExpressionFunctionTracker.getDDMExpressionFunctionFactories(this._ddmExpressionFunctionNames);
        try {
            HashSet<String> undefinedFunctionNames = new HashSet<String>(this._ddmExpressionFunctionNames);
            undefinedFunctionNames.removeAll(ddmExpressionFunctions.keySet());
            if (!undefinedFunctionNames.isEmpty()) {
                throw new DDMExpressionException.FunctionNotDefined(undefinedFunctionNames);
            }
            DDMExpressionEvaluatorVisitor ddmExpressionEvaluatorVisitor = new DDMExpressionEvaluatorVisitor(ddmExpressionFunctions, this._variables, this._ddmExpressionActionHandler, this._ddmExpressionFieldAccessor, this._ddmExpressionObserver, this._ddmExpressionParameterAccessor);
            return (T)this._expressionContext.accept(ddmExpressionEvaluatorVisitor);
        }
        catch (DDMExpressionException ddmee) {
            throw ddmee;
        }
        catch (Exception e) {
            throw new DDMExpressionException((Throwable)e);
        }
    }

    public Expression getModel() {
        DDMExpressionModelVisitor ddmExpressionModelVisitor = new DDMExpressionModelVisitor();
        return this._expressionContext.accept(ddmExpressionModelVisitor);
    }

    public void setVariable(String name, Object value) {
        if (value instanceof Number) {
            value = new BigDecimal(value.toString());
        }
        this._variables.put(name, value);
    }

    protected DDMExpressionImpl(String expressionString) throws DDMExpressionException {
        this._expressionString = expressionString;
        if (expressionString == null || expressionString.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ANTLRInputStream charStream = new ANTLRInputStream(this._expressionString);
        DDMExpressionLexer ddmExpressionLexer = new DDMExpressionLexer(charStream);
        DDMExpressionParser ddmExpressionParser = new DDMExpressionParser(new CommonTokenStream(ddmExpressionLexer));
        ddmExpressionParser.setErrorHandler(new BailErrorStrategy());
        try {
            this._expressionContext = ddmExpressionParser.expression();
        }
        catch (Exception e) {
            throw new DDMExpressionException.InvalidSyntax((Throwable)e);
        }
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        DDMExpressionListener ddmExpressionListener = new DDMExpressionListener();
        parseTreeWalker.walk(ddmExpressionListener, this._expressionContext);
        this._ddmExpressionFunctionNames = ddmExpressionListener.getFunctionNames();
        for (String variableName : ddmExpressionListener.getVariableNames()) {
            this._variables.put(variableName, null);
        }
    }

    protected Set<String> getExpressionVariableNames() {
        return this._variables.keySet();
    }

    protected void setDDMExpressionActionHandler(DDMExpressionActionHandler ddmExpressionActionHandler) {
        this._ddmExpressionActionHandler = ddmExpressionActionHandler;
    }

    protected void setDDMExpressionFieldAccessor(DDMExpressionFieldAccessor ddmExpressionFieldAccessor) {
        this._ddmExpressionFieldAccessor = ddmExpressionFieldAccessor;
    }

    protected void setDDMExpressionFunctionTracker(DDMExpressionFunctionTracker ddmExpressionFunctionTracker) {
        this._ddmExpressionFunctionTracker = ddmExpressionFunctionTracker;
    }

    protected void setDDMExpressionObserver(DDMExpressionObserver ddmExpressionObserver) {
        this._ddmExpressionObserver = ddmExpressionObserver;
    }

    protected void setDDMExpressionParameterAccessor(DDMExpressionParameterAccessor ddmExpressionParameterAccessor) {
        this._ddmExpressionParameterAccessor = ddmExpressionParameterAccessor;
    }
}

