/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal.helper;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.internal.pool.DDMExpressionFunctionPooledFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.osgi.service.component.ComponentFactory;

public class DDMExpressionFunctionTrackerHelper {
    protected Map<String, GenericObjectPool<DDMExpressionFunction>> ddmExpressionFunctionComponentFactoryMap = new ConcurrentHashMap<String, GenericObjectPool<DDMExpressionFunction>>();
    private static final Log _log = LogFactoryUtil.getLog(DDMExpressionFunctionTrackerHelper.class);

    public void addComponentFactory(ComponentFactory componentFactory) {
        GenericObjectPool<DDMExpressionFunction> ddmExpressionFunctionPool = this.createDDMExpressionFunctionPool(componentFactory);
        DDMExpressionFunction ddmExpressionFunction = this._getDDMExpressionFunction(ddmExpressionFunctionPool);
        this.ddmExpressionFunctionComponentFactoryMap.put(ddmExpressionFunction.getName(), ddmExpressionFunctionPool);
        this.ungetDDMExpressionFunction(ddmExpressionFunction);
    }

    public void clear() {
        Set<Map.Entry<String, GenericObjectPool<DDMExpressionFunction>>> entrySet = this.ddmExpressionFunctionComponentFactoryMap.entrySet();
        for (Map.Entry<String, GenericObjectPool<DDMExpressionFunction>> entry : entrySet) {
            GenericObjectPool<DDMExpressionFunction> ddmExpressionFunctionPool = entry.getValue();
            ddmExpressionFunctionPool.close();
        }
        this.ddmExpressionFunctionComponentFactoryMap.clear();
    }

    public DDMExpressionFunction getDDMExpressionFunction(String functionName) {
        GenericObjectPool<DDMExpressionFunction> ddmExpressionFunctionPool = this.ddmExpressionFunctionComponentFactoryMap.get(functionName);
        if (ddmExpressionFunctionPool == null) {
            return null;
        }
        return this._getDDMExpressionFunction(ddmExpressionFunctionPool);
    }

    public void removeComponentFactory(ComponentFactory componentFactory) {
        Set<Map.Entry<String, GenericObjectPool<DDMExpressionFunction>>> entrySet = this.ddmExpressionFunctionComponentFactoryMap.entrySet();
        for (Map.Entry<String, GenericObjectPool<DDMExpressionFunction>> entry : entrySet) {
            GenericObjectPool<DDMExpressionFunction> ddmExpressionFunctionPool = entry.getValue();
            DDMExpressionFunctionPooledFactory ddmExpressionFunctionPooledFactory = (DDMExpressionFunctionPooledFactory)ddmExpressionFunctionPool.getFactory();
            if (!Objects.equals(componentFactory, ddmExpressionFunctionPooledFactory.getComponentFactory())) continue;
            ddmExpressionFunctionPool.close();
            this.ddmExpressionFunctionComponentFactoryMap.remove(entry.getKey());
            break;
        }
    }

    public void ungetDDMExpressionFunction(DDMExpressionFunction ddmExpressionFunction) {
        GenericObjectPool<DDMExpressionFunction> ddmExpressionFunctionPool = this.ddmExpressionFunctionComponentFactoryMap.get(ddmExpressionFunction.getName());
        ddmExpressionFunctionPool.returnObject(ddmExpressionFunction);
    }

    protected GenericObjectPool<DDMExpressionFunction> createDDMExpressionFunctionPool(ComponentFactory componentFactory) {
        DDMExpressionFunctionPooledFactory ddmExpressionFunctionPooledFactory = new DDMExpressionFunctionPooledFactory(componentFactory);
        return new GenericObjectPool<DDMExpressionFunction>(ddmExpressionFunctionPooledFactory);
    }

    private DDMExpressionFunction _getDDMExpressionFunction(GenericObjectPool<DDMExpressionFunction> ddmExpressionFunctionPool) {
        try {
            if (ddmExpressionFunctionPool == null) {
                return null;
            }
            return ddmExpressionFunctionPool.borrowObject();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }
}

