/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionImpl;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMExpressionFactory.class})
public class DDMExpressionFactoryImpl
implements DDMExpressionFactory {
    private final Map<String, DDMExpressionFunction> _ddmExpressionFunctionMap = new ConcurrentHashMap<String, DDMExpressionFunction>();

    public DDMExpression<Boolean> createBooleanDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, Boolean.class);
    }

    public DDMExpression<Double> createDoubleDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, Double.class);
    }

    public DDMExpression<Float> createFloatDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, Float.class);
    }

    public DDMExpression<Integer> createIntegerDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, Integer.class);
    }

    public DDMExpression<Long> createLongDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, Long.class);
    }

    public DDMExpression<Number> createNumberDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, Number.class);
    }

    public DDMExpression<String> createStringDDMExpression(String expressionString) throws DDMExpressionException {
        return this.createDDMExpression(expressionString, String.class);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMExpressionFunction(DDMExpressionFunction ddmExpressionFunction, Map<String, Object> properties) {
        if (properties.containsKey("ddm.form.evaluator.function.name")) {
            String functionName = MapUtil.getString(properties, (String)"ddm.form.evaluator.function.name");
            this._ddmExpressionFunctionMap.putIfAbsent(functionName, ddmExpressionFunction);
        }
    }

    protected <T> DDMExpression<T> createDDMExpression(String expressionString, Class<T> expressionClass) throws DDMExpressionException {
        DDMExpressionImpl<T> ddmExpression = new DDMExpressionImpl<T>(expressionString, expressionClass);
        this.setDDMExpressionFunctions(ddmExpression);
        return ddmExpression;
    }

    protected void removeDDMExpressionFunction(DDMExpressionFunction ddmExpressionFunction, Map<String, Object> properties) {
        if (properties.containsKey("ddm.form.evaluator.function.name")) {
            String functionName = MapUtil.getString(properties, (String)"ddm.form.evaluator.function.name");
            this._ddmExpressionFunctionMap.remove(functionName);
        }
    }

    protected void setDDMExpressionFunctions(DDMExpression<?> ddmExpression) {
        for (Map.Entry<String, DDMExpressionFunction> entry : this._ddmExpressionFunctionMap.entrySet()) {
            ddmExpression.setDDMExpressionFunction(entry.getKey(), entry.getValue());
        }
    }
}

