/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionBaseVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionParser;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class DDMExpressionEvaluatorVisitor
extends DDMExpressionBaseVisitor<Object> {
    private final Map<String, DDMExpressionFunction> _functions = new HashMap<String, DDMExpressionFunction>();
    private final Map<String, Object> _variables = new HashMap<String, Object>();

    public void addFunctions(Map<String, DDMExpressionFunction> ddmExpressionFunctions) {
        this._functions.putAll(ddmExpressionFunctions);
    }

    public void addVariable(String name, Object value) {
        this._variables.put(name, value);
    }

    @Override
    public Object visitAdditionExpression(@NotNull DDMExpressionParser.AdditionExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() + r.doubleValue();
    }

    @Override
    public Object visitAndExpression(@NotNull DDMExpressionParser.AndExpressionContext context) {
        boolean l = (Boolean)this.visitChild(context, 0);
        boolean r = (Boolean)this.visitChild(context, 2);
        return l && r;
    }

    @Override
    public Object visitBooleanParenthesis(@NotNull DDMExpressionParser.BooleanParenthesisContext context) {
        return this.visitChild(context, 1);
    }

    @Override
    public Object visitDivisionExpression(@NotNull DDMExpressionParser.DivisionExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() / r.doubleValue();
    }

    @Override
    public Object visitEqualsExpression(@NotNull DDMExpressionParser.EqualsExpressionContext context) {
        Object l = this.visitChild(context, 0);
        Object r = this.visitChild(context, 2);
        return l.equals(r);
    }

    @Override
    public Object visitExpression(@NotNull DDMExpressionParser.ExpressionContext context) {
        DDMExpressionParser.LogicalOrExpressionContext logicalOrExpressionContext = context.logicalOrExpression();
        return logicalOrExpressionContext.accept(this);
    }

    @Override
    public Object visitFloatingPointLiteral(@NotNull DDMExpressionParser.FloatingPointLiteralContext context) {
        return GetterUtil.getDouble((String)context.getText());
    }

    @Override
    public Object visitFunctionCallExpression(@NotNull DDMExpressionParser.FunctionCallExpressionContext context) {
        String functionName = this.getFunctionName(context.functionName);
        DDMExpressionFunction ddmExpressionFunction = this._functions.get(functionName);
        if (ddmExpressionFunction == null) {
            throw new IllegalStateException(String.format("Function \"%s\" not defined", functionName));
        }
        Object[] params = this.getFunctionParameters(context.functionParameters());
        return ddmExpressionFunction.evaluate(params);
    }

    @Override
    public Object visitGreaterThanExpression(@NotNull DDMExpressionParser.GreaterThanExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() > r.doubleValue();
    }

    @Override
    public Object visitGreaterThanOrEqualsExpression(@NotNull DDMExpressionParser.GreaterThanOrEqualsExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() >= r.doubleValue();
    }

    @Override
    public Object visitIntegerLiteral(@NotNull DDMExpressionParser.IntegerLiteralContext context) {
        Long number = GetterUtil.getLong((String)context.getText());
        return ((Number)number).doubleValue();
    }

    @Override
    public Object visitLessThanExpression(@NotNull DDMExpressionParser.LessThanExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() < r.doubleValue();
    }

    @Override
    public Object visitLessThanOrEqualsExpression(@NotNull DDMExpressionParser.LessThanOrEqualsExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() <= r.doubleValue();
    }

    @Override
    public Object visitLogicalConstant(@NotNull DDMExpressionParser.LogicalConstantContext context) {
        String boleanString = StringUtil.toLowerCase((String)context.getText());
        return Boolean.parseBoolean(boleanString);
    }

    @Override
    public Object visitLogicalVariable(@NotNull DDMExpressionParser.LogicalVariableContext context) {
        String variable = context.getText();
        Object variableValue = this._variables.get(variable);
        if (variableValue == null) {
            throw new IllegalStateException(String.format("Variable \"%s\" not defined", variable));
        }
        return variableValue;
    }

    @Override
    public Object visitMinusExpression(@NotNull DDMExpressionParser.MinusExpressionContext context) {
        Number number = (Number)this.visitChild(context, 1);
        return -number.doubleValue();
    }

    @Override
    public Object visitMultiplicationExpression(@NotNull DDMExpressionParser.MultiplicationExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() * r.doubleValue();
    }

    @Override
    public Object visitNotEqualsExpression(@NotNull DDMExpressionParser.NotEqualsExpressionContext context) {
        Object r;
        Object l = this.visitChild(context, 0);
        return !l.equals(r = this.visitChild(context, 2));
    }

    @Override
    public Object visitNotExpression(@NotNull DDMExpressionParser.NotExpressionContext context) {
        boolean b = (Boolean)this.visitChild(context, 1);
        return !b;
    }

    @Override
    public Object visitNumericParenthesis(@NotNull DDMExpressionParser.NumericParenthesisContext context) {
        return this.visitChild(context, 1);
    }

    @Override
    public Object visitNumericVariable(@NotNull DDMExpressionParser.NumericVariableContext context) {
        String variable = context.getText();
        Object variableValue = this._variables.get(variable);
        if (variableValue == null) {
            throw new IllegalStateException(String.format("variable %s not defined", variable));
        }
        return variableValue;
    }

    @Override
    public Object visitOrExpression(@NotNull DDMExpressionParser.OrExpressionContext context) {
        boolean l = (Boolean)this.visitChild(context, 0);
        boolean r = (Boolean)this.visitChild(context, 2);
        return l || r;
    }

    @Override
    public Object visitStringLiteral(@NotNull DDMExpressionParser.StringLiteralContext context) {
        return StringUtil.unquote((String)context.getText());
    }

    @Override
    public Object visitSubtractionExpression(@NotNull DDMExpressionParser.SubtractionExpressionContext context) {
        Number l = (Number)this.visitChild(context, 0);
        Number r = (Number)this.visitChild(context, 2);
        return l.doubleValue() - r.doubleValue();
    }

    protected String getFunctionName(Token functionNameToken) {
        return functionNameToken.getText();
    }

    protected Object[] getFunctionParameters(DDMExpressionParser.FunctionParametersContext context) {
        if (context == null) {
            return new Object[0];
        }
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < context.getChildCount(); i += 2) {
            Object parameter = this.visitChild(context, i);
            parameters.add(parameter);
        }
        return parameters.toArray(new Object[0]);
    }

    protected <T> T visitChild(ParserRuleContext parserRuleContext, int childIndex) {
        ParseTree parseTree = parserRuleContext.getChild(childIndex);
        return (T)parseTree.accept(this);
    }
}

