/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.VariableDependencies;
import com.liferay.dynamic.data.mapping.expression.internal.TokenExtractor;
import com.liferay.dynamic.data.mapping.expression.internal.Variable;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DDMExpressionImpl<T>
implements DDMExpression<T> {
    private final Class<?> _expressionClass;
    private final String _expressionString;
    private MathContext _mathContext = MathContext.UNLIMITED;
    private final Map<String, Variable> _variables = new TreeMap<String, Variable>();
    private final Map<String, BigDecimal> _variableValues = new HashMap<String, BigDecimal>();

    public DDMExpressionImpl(String expressionString, Class<T> expressionClass) throws DDMExpressionException {
        TokenExtractor tokenExtractor = new TokenExtractor(expressionString);
        Map<String, String> variableMap = tokenExtractor.getVariableMap();
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            String variableName = entry.getKey();
            Variable variable = new Variable(variableName);
            this._variables.put(variableName, variable);
            String token = entry.getValue();
            if (token == null) continue;
            this.setStringVariableValue(variableName, token);
        }
        this._expressionString = tokenExtractor.getExpression();
        this._expressionClass = expressionClass;
    }

    @Override
    public T evaluate() throws DDMExpressionException {
        try {
            Expression expression = new Expression(this._expressionString);
            for (Map.Entry<String, Variable> entry : this._variables.entrySet()) {
                BigDecimal variableValue = this.getVariableValue(entry.getValue());
                expression.setVariable(entry.getKey(), variableValue);
            }
            BigDecimal result = this.evaluate(expression);
            return (T)this.toRetunType(result);
        }
        catch (Exception e) {
            throw new DDMExpressionException(e);
        }
    }

    @Override
    public Map<String, VariableDependencies> getVariableDependenciesMap() throws DDMExpressionException {
        HashMap<String, VariableDependencies> variableDependenciesMap = new HashMap<String, VariableDependencies>();
        List variables = ListUtil.fromCollection(this._variables.values());
        for (Variable variable : variables) {
            this.populateVariableDependenciesMap(variable, variableDependenciesMap);
        }
        return variableDependenciesMap;
    }

    @Override
    public void setBooleanVariableValue(String variableName, Boolean variableValue) {
        this.setVariableValue(variableName, this.encode(variableValue));
    }

    @Override
    public void setDoubleVariableValue(String variableName, Double variableValue) {
        this.setVariableValue(variableName, new BigDecimal(variableValue));
    }

    @Override
    public void setExpressionStringVariableValue(String variableName, String variableValue) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setExpressionString(variableValue);
    }

    @Override
    public void setFloatVariableValue(String variableName, Float variableValue) {
        this.setVariableValue(variableName, new BigDecimal(variableValue.floatValue()));
    }

    @Override
    public void setIntegerVariableValue(String variableName, Integer variableValue) {
        this.setVariableValue(variableName, new BigDecimal(variableValue));
    }

    @Override
    public void setLongVariableValue(String variableName, Long variableValue) {
        this.setVariableValue(variableName, new BigDecimal(variableValue));
    }

    @Override
    public void setMathContext(MathContext mathContext) {
        this._mathContext = mathContext;
    }

    @Override
    public void setStringVariableValue(String variableName, String variableValue) throws DDMExpressionException {
        Double doubleValue = this.parseDoubleValue(variableValue);
        if (doubleValue == null) {
            this.setVariableValue(variableName, this.encode(variableValue));
            return;
        }
        if (doubleValue.isNaN() || doubleValue.isInfinite()) {
            throw new DDMExpressionException.NumberExceedsSupportedRange();
        }
        this.setVariableValue(variableName, new BigDecimal(variableValue));
    }

    protected Boolean decodeBoolean(BigDecimal bigDecimal) {
        if (bigDecimal.equals(BigDecimal.ONE)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected String decodeString(BigDecimal bigDecimal) {
        if (bigDecimal.equals(BigDecimal.ZERO)) {
            return "";
        }
        BigInteger bigInteger = new BigInteger(bigDecimal.toString());
        return new String(bigInteger.toByteArray());
    }

    protected BigDecimal encode(Boolean variableValue) {
        if (variableValue.equals(Boolean.TRUE)) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }

    protected BigDecimal encode(String variableValue) {
        if (Validator.isNull((String)variableValue)) {
            return BigDecimal.ZERO;
        }
        BigInteger bigInteger = new BigInteger(variableValue.getBytes());
        return new BigDecimal(bigInteger);
    }

    protected BigDecimal evaluate(Expression expression) {
        this.setExpressionCustomFunctions(expression);
        this.setExpressionCustomOperators(expression);
        this.setExpressionMathContext(expression);
        return expression.eval();
    }

    protected Expression getExpression(String expressionString) throws DDMExpressionException {
        Expression expression = new Expression(expressionString);
        TokenExtractor tokenExtractor = new TokenExtractor(expressionString);
        Map<String, String> variableMap = tokenExtractor.getVariableMap();
        for (String key : variableMap.keySet()) {
            Variable variable = this._variables.get(key);
            if (variable == null) continue;
            BigDecimal variableValue = this.getVariableValue(variable);
            expression.setVariable(key, variableValue);
        }
        return expression;
    }

    protected Expression getExpression(Variable variable) throws DDMExpressionException {
        if (variable.getExpressionString() == null) {
            return null;
        }
        Expression expression = this.getExpression(variable.getExpressionString());
        return expression;
    }

    protected BigDecimal getVariableValue(Variable variable) throws DDMExpressionException {
        BigDecimal variableValue = this._variableValues.get(variable.getName());
        if (variableValue != null) {
            return variableValue;
        }
        Expression expression = this.getExpression(variable);
        if (expression == null) {
            return variable.getValue();
        }
        variableValue = this.evaluate(expression);
        this._variableValues.put(variable.getName(), variableValue);
        return variableValue;
    }

    protected boolean isStringBlank(BigDecimal ... bigDecimals) {
        for (BigDecimal bigDecimal : bigDecimals) {
            if (bigDecimal.equals(BigDecimal.ZERO)) continue;
            return false;
        }
        return true;
    }

    protected Double parseDoubleValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected VariableDependencies populateVariableDependenciesMap(Variable variable, Map<String, VariableDependencies> variableDependenciesMap) throws DDMExpressionException {
        VariableDependencies variableDependencies = variableDependenciesMap.get(variable.getName());
        if (variableDependencies != null) {
            return variableDependencies;
        }
        variableDependencies = new VariableDependencies(variable.getName());
        if (variable.getExpressionString() != null) {
            TokenExtractor tokensExtractor = new TokenExtractor(variable.getExpressionString());
            Map<String, String> variableMap = tokensExtractor.getVariableMap();
            Set<String> variableNames = variableMap.keySet();
            for (String variableName : variableNames) {
                if (!this._variables.containsKey(variableName)) {
                    Variable newVariable = new Variable(variableName);
                    this._variables.put(variableName, newVariable);
                    String token = variableMap.get(variableName);
                    if (token != null) {
                        this.setStringVariableValue(variableName, token);
                    }
                }
                VariableDependencies variableVariableDependencies = this.populateVariableDependenciesMap(this._variables.get(variableName), variableDependenciesMap);
                variableVariableDependencies.addAffectedVariable(variableDependencies.getVariableName());
                variableDependencies.addRequiredVariable(variableVariableDependencies.getVariableName());
            }
        }
        variableDependenciesMap.put(variable.getName(), variableDependencies);
        return variableDependencies;
    }

    protected void setExpressionCustomFunctions(Expression expression) {
        Expression expression2 = expression;
        expression2.getClass();
        expression.addFunction(new Expression.Function(expression2, "between", 3){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal parameter = parameters.get(0);
                BigDecimal minParameter = parameters.get(1);
                BigDecimal maxParameter = parameters.get(2);
                if (parameter.compareTo(minParameter) >= 0 && parameter.compareTo(maxParameter) <= 0) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        Expression expression3 = expression;
        expression3.getClass();
        expression.addFunction(new Expression.Function(expression3, "concat", -1){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                StringBundler sb = new StringBundler(parameters.size());
                for (BigDecimal parameter : parameters) {
                    if (DDMExpressionImpl.this.isStringBlank(parameter)) continue;
                    String string = DDMExpressionImpl.this.decodeString(parameter);
                    sb.append(string);
                }
                if (sb.index() == 0) {
                    return BigDecimal.ZERO;
                }
                return DDMExpressionImpl.this.encode(sb.toString());
            }
        });
        Expression expression4 = expression;
        expression4.getClass();
        expression.addFunction(new Expression.Function(expression4, "contains", 2){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                String string2;
                BigDecimal parameter1 = parameters.get(0);
                BigDecimal parameter2 = parameters.get(1);
                if (DDMExpressionImpl.this.isStringBlank(parameter1, parameter2)) {
                    return BigDecimal.ONE;
                }
                String string1 = DDMExpressionImpl.this.decodeString(parameter1);
                if (string1.contains(string2 = DDMExpressionImpl.this.decodeString(parameter2))) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        Expression expression5 = expression;
        expression5.getClass();
        expression.addFunction(new Expression.Function(expression5, "equals", 2){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                String string2;
                BigDecimal parameter1 = parameters.get(0);
                BigDecimal parameter2 = parameters.get(1);
                if (DDMExpressionImpl.this.isStringBlank(parameter1, parameter2)) {
                    return BigDecimal.ONE;
                }
                String string1 = DDMExpressionImpl.this.decodeString(parameter1);
                if (string1.equals(string2 = DDMExpressionImpl.this.decodeString(parameter2))) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        Expression expression6 = expression;
        expression6.getClass();
        expression.addFunction(new Expression.Function(expression6, "isEmailAddress", 1){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                String string = DDMExpressionImpl.this.decodeString(parameters.get(0));
                if (Validator.isEmailAddress((String)string)) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        Expression expression7 = expression;
        expression7.getClass();
        expression.addFunction(new Expression.Function(expression7, "isURL", 1){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                String string = DDMExpressionImpl.this.decodeString(parameters.get(0));
                if (Validator.isUrl((String)string)) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        Expression expression8 = expression;
        expression8.getClass();
        expression.addFunction(new Expression.Function(expression8, "sum", -1){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2);
            }

            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal sum = new BigDecimal(0);
                for (BigDecimal parameter : parameters) {
                    sum = sum.add(parameter);
                }
                return sum;
            }
        });
    }

    protected void setExpressionCustomOperators(Expression expression) {
        Expression expression2 = expression;
        expression2.getClass();
        expression.addOperator(new Expression.Operator(expression2, "+", 20, true){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2, x3);
            }

            public BigDecimal eval(BigDecimal parameter1, BigDecimal parameter2) {
                return new BigDecimal(parameter1.doubleValue() + parameter2.doubleValue());
            }
        });
        Expression expression3 = expression;
        expression3.getClass();
        expression.addOperator(new Expression.Operator(expression3, "-", 20, true){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2, x3);
            }

            public BigDecimal eval(BigDecimal parameter1, BigDecimal parameter2) {
                return new BigDecimal(parameter1.doubleValue() - parameter2.doubleValue());
            }
        });
        Expression expression4 = expression;
        expression4.getClass();
        expression.addOperator(new Expression.Operator(expression4, "*", 30, true){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2, x3);
            }

            public BigDecimal eval(BigDecimal parameter1, BigDecimal parameter2) {
                return new BigDecimal(parameter1.doubleValue() * parameter2.doubleValue());
            }
        });
        Expression expression5 = expression;
        expression5.getClass();
        expression.addOperator(new Expression.Operator(expression5, "/", 30, true){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2, x3);
            }

            public BigDecimal eval(BigDecimal parameter1, BigDecimal parameter2) {
                return new BigDecimal(parameter1.doubleValue() / parameter2.doubleValue());
            }
        });
        Expression expression6 = expression;
        expression6.getClass();
        expression.addOperator(new Expression.Operator(expression6, "%", 30, true){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2, x3);
            }

            public BigDecimal eval(BigDecimal parameter1, BigDecimal parameter2) {
                return new BigDecimal(parameter1.doubleValue() % parameter2.doubleValue());
            }
        });
        Expression expression7 = expression;
        expression7.getClass();
        expression.addOperator(new Expression.Operator(expression7, "^", 40, false){
            {
                Expression expression = x0;
                expression.getClass();
                super(expression, x1, x2, x3);
            }

            public BigDecimal eval(BigDecimal parameter1, BigDecimal parameter2) {
                double pow = Math.pow(parameter1.doubleValue(), parameter2.doubleValue());
                return new BigDecimal(pow);
            }
        });
    }

    protected void setExpressionMathContext(Expression expression) {
        expression.setPrecision(this._mathContext.getPrecision());
        expression.setRoundingMode(this._mathContext.getRoundingMode());
    }

    protected void setVariableValue(String variableName, BigDecimal variableValue) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setValue(variableValue);
    }

    protected Object toRetunType(BigDecimal result) {
        if (this._expressionClass.isAssignableFrom(Boolean.class)) {
            return this.decodeBoolean(result);
        }
        if (this._expressionClass.isAssignableFrom(Double.class)) {
            return result.doubleValue();
        }
        if (this._expressionClass.isAssignableFrom(Float.class)) {
            return Float.valueOf(result.floatValue());
        }
        if (this._expressionClass.isAssignableFrom(Integer.class)) {
            return result.intValue();
        }
        if (this._expressionClass.isAssignableFrom(Long.class)) {
            return result.longValue();
        }
        return this.decodeString(result);
    }
}

