/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.expression;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Miguel Angelo Caldas Gallindo
 */
public class VariableDependencies {

	public VariableDependencies(String variableName) {
		_variableName = variableName;
	}

	public void addAffectedVariable(String variableName) {
		_affectedVariableNames.add(variableName);
	}

	public void addRequiredVariable(String variableName) {
		_requiredVariableNames.add(variableName);
	}

	public List<String> getAffectedVariableNames() {
		return _affectedVariableNames;
	}

	public List<String> getRequiredVariableNames() {
		return _requiredVariableNames;
	}

	public String getVariableName() {
		return _variableName;
	}

	private final List<String> _affectedVariableNames = new ArrayList<>();
	private final List<String> _requiredVariableNames = new ArrayList<>();
	private final String _variableName;

}