/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.udojava.evalex.Expression;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenExtractor {
    private static final Set<String> _allowedFunctions = SetUtil.fromArray((Object[])new String[]{"between", "concat", "contains", "equals", "if", "isemailaddress", "isurl", "max", "min", "not", "sum", "isemailaddresses"});
    private static final Set<String> _availableFunctions = SetUtil.fromArray((Object[])new String[]{"abs", "acos", "asin", "atan", "between", "ceiling", "concat", "contains", "cos", "cosh", "deg", "equals", "floor", "if", "isemailaddress", "isurl", "log", "log10", "max", "min", "not", "rad", "random", "round", "sin", "sinh", "sqrt", "sum", "tan", "tanh", "isemailaddresses"});
    private static final Set<String> _booleanConstants = SetUtil.fromArray((Object[])new String[]{"false", "true"});
    private static final Pattern _operatorsPattern = Pattern.compile("[+-/\\*%\\^\\(\\)]|[<>=!]=?|&&|\\|\\|");
    private static final Pattern _stringPattern = Pattern.compile("\"([^\"]*)\"");
    private static final Pattern _variablePattern = Pattern.compile("\\b([^0-9_\\s]+[^\\s]*)(?!\\()\\b");
    private String _expression;
    private final Map<String, String> _variableMap = new HashMap<String, String>();

    public TokenExtractor(String expressionString) throws DDMExpressionException {
        if (Validator.isNull((String)expressionString)) {
            throw new IllegalArgumentException("Expression is null");
        }
        this._expression = expressionString;
        this.extract();
    }

    public String getExpression() {
        return this._expression;
    }

    public Map<String, String> getVariableMap() {
        return this._variableMap;
    }

    protected String createRandomVariableName() {
        return StringUtil.randomId();
    }

    protected void createStringVariable(String token) {
        String variableName = this.createRandomVariableName();
        this._variableMap.put(variableName, token);
        this._expression = StringUtil.replace((String)this._expression, (String)("\"" + token + "\""), (String)variableName);
    }

    protected void createVariable(String token) {
        String variableName = this.createRandomVariableName();
        this._variableMap.put(variableName, token);
        this._expression = this._expression.replaceAll("\\b" + token + "\\b", variableName);
    }

    protected void extract() throws DDMExpressionException {
        try {
            Matcher matcher = _stringPattern.matcher(this._expression);
            while (matcher.find()) {
                this.createStringVariable(matcher.group(1));
            }
            Iterator<String> tokenIterator = this.getExpressionTokens();
            while (tokenIterator.hasNext()) {
                String token = tokenIterator.next();
                if (this.isFunction(token) && !this.isFunctionAllowed(token)) {
                    throw new DDMExpressionException.FunctionNotAllowed(token);
                }
                if (this.isOperator(token) || this.isFunctionAllowed(token) || this.isBooleanConstant(token)) continue;
                Matcher variableMatcher = _variablePattern.matcher(token);
                if (variableMatcher.matches()) {
                    if (this._variableMap.containsKey(token)) continue;
                    this._variableMap.put(token, token);
                    continue;
                }
                this.createVariable(token);
            }
        }
        catch (Expression.ExpressionException ee) {
            throw new DDMExpressionException(ee);
        }
    }

    protected Iterator<String> getExpressionTokens() {
        Expression expression = new Expression(this._expression);
        return expression.getExpressionTokenizer();
    }

    protected boolean isBooleanConstant(String token) {
        return _booleanConstants.contains(StringUtil.toLowerCase((String)token));
    }

    protected boolean isFunction(String token) {
        return _availableFunctions.contains(StringUtil.toLowerCase((String)token));
    }

    protected boolean isFunctionAllowed(String token) {
        return _allowedFunctions.contains(StringUtil.toLowerCase((String)token));
    }

    protected boolean isOperator(String token) {
        Matcher tokenMatcher = _operatorsPattern.matcher(token);
        return tokenMatcher.matches();
    }
}

