/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.expression.internal;

import java.math.BigDecimal;

/**
 * @author Miguel Angelo Caldas Gallindo
 */
public class Variable {

	public Variable(String name) {
		_name = name;
	}

	public Variable(String name, BigDecimal value) {
		_name = name;
		_value = value;
	}

	public String getExpressionString() {
		return _expressionString;
	}

	public String getName() {
		return _name;
	}

	public BigDecimal getValue() {
		return _value;
	}

	public void setExpressionString(String expressionString) {
		_expressionString = expressionString;
	}

	public void setName(String name) {
		_name = name;
	}

	public void setValue(BigDecimal value) {
		_value = value;
	}

	private String _expressionString;
	private String _name;
	private BigDecimal _value;

}