/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterTracker;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.data.provider.instance.id=ddm-storage-types"}, service={DDMDataProvider.class})
public class DDMStorageTypesDataProvider
implements DDMDataProvider {
    @Reference
    protected DDMStorageAdapterTracker ddmStorageAdapterTracker;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        Set storageTypes = this.ddmStorageAdapterTracker.getDDMStorageAdapterTypes();
        Optional httpServletRequestOptional = ddmDataProviderRequest.getParameterOptional("httpServletRequest", HttpServletRequest.class);
        HttpServletRequest httpServletRequest = httpServletRequestOptional.orElse(null);
        for (String storageType : storageTypes) {
            if (httpServletRequest == null) {
                keyValuePairs.add(new KeyValuePair(storageType, storageType));
                continue;
            }
            keyValuePairs.add(new KeyValuePair(storageType, LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)(storageType + "[stands-for]"), (String)LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)storageType))));
        }
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        builder.withOutput("Default-Output", keyValuePairs);
        return builder.build();
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

