/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.change.tracking.internal.service;

import com.liferay.change.tracking.CTEngineManager;
import com.liferay.change.tracking.CTManager;
import com.liferay.change.tracking.exception.CTEntryException;
import com.liferay.change.tracking.exception.CTException;
import com.liferay.change.tracking.model.CTEntryModel;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceWrapper;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.Portal;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class CTDDMTemplateLocalServiceWrapper
extends DDMTemplateLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(CTDDMTemplateLocalServiceWrapper.class);
    @Reference
    private CTEngineManager _ctEngineManager;
    @Reference
    private CTManager _ctManager;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DDMTemplateVersionLocalService _ddmTemplateVersionLocalService;
    @Reference
    private Portal _portal;

    public CTDDMTemplateLocalServiceWrapper() {
        super(null);
    }

    public CTDDMTemplateLocalServiceWrapper(DDMTemplateLocalService ddmTemplateLocalService) {
        super(ddmTemplateLocalService);
    }

    public DDMTemplate addTemplate(long userId, long groupId, long classNameId, long classPK, long resourceClassNameId, String templateKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        DDMTemplate ddmTemplate = (DDMTemplate)this._ctManager.executeModelUpdate(() -> super.addTemplate(userId, groupId, classNameId, classPK, resourceClassNameId, templateKey, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext));
        DDMTemplateVersion ddmTemplateVersion = ddmTemplate.getTemplateVersion();
        this._registerChange(ddmTemplateVersion, 0, true);
        return ddmTemplate;
    }

    public DDMTemplate fetchDDMTemplate(long templateId) {
        DDMTemplate ddmTemplate = super.fetchDDMTemplate(templateId);
        if (this._isRetrievable(ddmTemplate)) {
            return this._populateDDMTemplate(ddmTemplate);
        }
        return null;
    }

    public DDMTemplate fetchTemplate(long templateId) {
        DDMTemplate ddmTemplate = super.fetchTemplate(templateId);
        if (this._isRetrievable(ddmTemplate)) {
            return this._populateDDMTemplate(ddmTemplate);
        }
        return null;
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey, boolean includeAncestorTemplates) {
        DDMTemplate ddmTemplate = super.fetchTemplate(groupId, classNameId, templateKey, includeAncestorTemplates);
        if (this._isRetrievable(ddmTemplate)) {
            return this._populateDDMTemplate(ddmTemplate);
        }
        return null;
    }

    public DDMTemplate updateTemplate(long userId, long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        DDMTemplate ddmTemplate = (DDMTemplate)this._ctManager.executeModelUpdate(() -> super.updateTemplate(userId, templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext));
        DDMTemplateVersion ddmTemplateVersion = ddmTemplate.getTemplateVersion();
        this._registerChange(ddmTemplateVersion, 2);
        return ddmTemplate;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
    }

    private boolean _isBasicWebContent(DDMTemplate ddmTemplate) {
        return Objects.equals(ddmTemplate.getTemplateKey(), "BASIC-WEB-CONTENT");
    }

    private boolean _isRetrievable(DDMTemplate ddmTemplate) {
        if (ddmTemplate == null) {
            return false;
        }
        if (!this._ctEngineManager.isChangeTrackingEnabled(ddmTemplate.getCompanyId()) || this._isBasicWebContent(ddmTemplate)) {
            return true;
        }
        Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(PrincipalThreadLocal.getUserId(), ddmTemplate.getTemplateId());
        return ctEntryOptional.isPresent();
    }

    private DDMTemplate _populateDDMTemplate(DDMTemplate ddmTemplate) {
        Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(PrincipalThreadLocal.getUserId(), ddmTemplate.getTemplateId());
        if (!ctEntryOptional.isPresent()) {
            return ddmTemplate;
        }
        Optional<DDMTemplateVersion> ddmTemplateVersionOptional = ctEntryOptional.map(CTEntryModel::getModelClassPK).map(arg_0 -> ((DDMTemplateVersionLocalService)this._ddmTemplateVersionLocalService).fetchDDMTemplateVersion(arg_0));
        if (!ddmTemplateVersionOptional.isPresent()) {
            return ddmTemplate;
        }
        DDMTemplateVersion ddmTemplateVersion = ddmTemplateVersionOptional.get();
        ddmTemplate.setVersionUserId(ddmTemplateVersion.getUserId());
        ddmTemplate.setVersionUserName(ddmTemplateVersion.getUserName());
        ddmTemplate.setClassNameId(ddmTemplateVersion.getClassNameId());
        ddmTemplate.setClassPK(ddmTemplateVersion.getClassPK());
        ddmTemplate.setVersion(ddmTemplateVersion.getVersion());
        ddmTemplate.setNameMap(ddmTemplateVersion.getNameMap());
        ddmTemplate.setDescriptionMap(ddmTemplateVersion.getDescriptionMap());
        ddmTemplate.setLanguage(ddmTemplateVersion.getLanguage());
        ddmTemplate.setScript(ddmTemplateVersion.getScript());
        return ddmTemplate;
    }

    private void _registerChange(DDMTemplateVersion ddmTemplateVersion, int changeType) throws CTException {
        this._registerChange(ddmTemplateVersion, changeType, false);
    }

    private void _registerChange(DDMTemplateVersion ddmTemplateVersion, int changeType, boolean force) throws CTException {
        if (ddmTemplateVersion == null) {
            return;
        }
        try {
            this._ctManager.registerModelChange(PrincipalThreadLocal.getUserId(), this._portal.getClassNameId(DDMTemplateVersion.class.getName()), ddmTemplateVersion.getTemplateVersionId(), ddmTemplateVersion.getTemplateId(), changeType, force);
        }
        catch (CTException cte) {
            if (cte instanceof CTEntryException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)cte.getMessage());
                }
            }
            throw cte;
        }
    }
}

