/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.change.tracking.internal.service;

import com.liferay.change.tracking.CTEngineManager;
import com.liferay.change.tracking.CTManager;
import com.liferay.change.tracking.exception.CTEntryException;
import com.liferay.change.tracking.exception.CTException;
import com.liferay.change.tracking.model.CTEntryModel;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceWrapper;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class CTDDMStructureLocalServiceWrapper
extends DDMStructureLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(CTDDMStructureLocalServiceWrapper.class);
    @Reference
    private CTEngineManager _ctEngineManager;
    @Reference
    private CTManager _ctManager;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private Portal _portal;

    public CTDDMStructureLocalServiceWrapper() {
        super(null);
    }

    public CTDDMStructureLocalServiceWrapper(DDMStructureLocalService ddmStructureLocalService) {
        super(ddmStructureLocalService);
    }

    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = (DDMStructure)this._ctManager.executeModelUpdate(() -> super.addStructure(userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext));
        DDMStructureVersion ddmStructureVersion = ddmStructure.getStructureVersion();
        this._registerChange(ddmStructureVersion, 0);
        return ddmStructure;
    }

    public DDMStructure fetchStructure(long structureId) {
        DDMStructure ddmStructure = super.fetchStructure(structureId);
        if (this._isRetrievable(ddmStructure)) {
            return this._populateDDMStructure(ddmStructure);
        }
        return null;
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) {
        DDMStructure ddmStructure = super.fetchStructure(groupId, classNameId, structureKey, includeAncestorStructures);
        if (this._isRetrievable(ddmStructure)) {
            return this._populateDDMStructure(ddmStructure);
        }
        return null;
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        if (!this._ctEngineManager.isChangeTrackingEnabled(companyId)) {
            return super.getStructures(companyId, groupIds, classNameId, start, end, orderByComparator);
        }
        List structures = super.getStructures(groupIds, classNameId, orderByComparator);
        Stream stream = structures.stream();
        return stream.filter(structure -> {
            Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(PrincipalThreadLocal.getUserId(), structure.getStructureId());
            return ctEntryOptional.isPresent();
        }).skip(start).limit(end).map(this::_populateDDMStructure).collect(Collectors.toList());
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) {
        DDMStructure ddmStructure;
        List structures = super.getStructures(groupIds, classNameId);
        if (ListUtil.isNotEmpty((List)structures) && !this._ctEngineManager.isChangeTrackingEnabled((ddmStructure = (DDMStructure)structures.get(0)).getCompanyId())) {
            return structures;
        }
        Stream stream = structures.stream();
        return stream.filter(structure -> {
            if (this._isBasicWebContent((DDMStructure)structure)) {
                return true;
            }
            Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(PrincipalThreadLocal.getUserId(), structure.getStructureId());
            return ctEntryOptional.isPresent();
        }).map(this::_populateDDMStructure).collect(Collectors.toList());
    }

    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = (DDMStructure)this._ctManager.executeModelUpdate(() -> super.updateStructure(userId, structureId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext));
        DDMStructureVersion ddmStructureVersion = ddmStructure.getStructureVersion();
        this._registerChange(ddmStructureVersion, 2);
        return ddmStructure;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
    }

    private boolean _isBasicWebContent(DDMStructure ddmStructure) {
        long journalClassNameId = this._portal.getClassNameId(JournalArticle.class);
        return ddmStructure.getClassNameId() == journalClassNameId && Objects.equals(ddmStructure.getStructureKey(), "BASIC-WEB-CONTENT");
    }

    private boolean _isRetrievable(DDMStructure ddmStructure) {
        if (ddmStructure == null) {
            return false;
        }
        if (!this._ctEngineManager.isChangeTrackingEnabled(ddmStructure.getCompanyId()) || this._isBasicWebContent(ddmStructure)) {
            return true;
        }
        Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(PrincipalThreadLocal.getUserId(), ddmStructure.getStructureId());
        return ctEntryOptional.isPresent();
    }

    private DDMStructure _populateDDMStructure(DDMStructure ddmStructure) {
        Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(PrincipalThreadLocal.getUserId(), ddmStructure.getStructureId());
        if (!ctEntryOptional.isPresent()) {
            return ddmStructure;
        }
        Optional<DDMStructureVersion> ddmStructureVersionOptional = ctEntryOptional.map(CTEntryModel::getModelClassPK).map(arg_0 -> ((DDMStructureVersionLocalService)this._ddmStructureVersionLocalService).fetchDDMStructureVersion(arg_0));
        if (!ddmStructureVersionOptional.isPresent()) {
            return ddmStructure;
        }
        DDMStructureVersion ddmStructureVersion = ddmStructureVersionOptional.get();
        ddmStructure.setStructureId(ddmStructureVersion.getStructureId());
        ddmStructure.setGroupId(ddmStructureVersion.getGroupId());
        ddmStructure.setCompanyId(ddmStructureVersion.getCompanyId());
        ddmStructure.setUserId(ddmStructureVersion.getUserId());
        ddmStructure.setUserName(ddmStructureVersion.getUserName());
        ddmStructure.setModifiedDate(ddmStructureVersion.getCreateDate());
        ddmStructure.setParentStructureId(ddmStructureVersion.getParentStructureId());
        ddmStructure.setVersion(ddmStructureVersion.getVersion());
        ddmStructure.setName(ddmStructureVersion.getName());
        ddmStructure.setDescription(ddmStructureVersion.getDescription());
        ddmStructure.setDefinition(ddmStructureVersion.getDefinition());
        ddmStructure.setStorageType(ddmStructureVersion.getStorageType());
        ddmStructure.setType(ddmStructureVersion.getType());
        return ddmStructure;
    }

    private void _registerChange(DDMStructureVersion ddmStructureVersion, int changeType) throws CTException {
        this._registerChange(ddmStructureVersion, changeType, false);
    }

    private void _registerChange(DDMStructureVersion ddmStructureVersion, int changeType, boolean force) throws CTException {
        if (ddmStructureVersion == null) {
            return;
        }
        try {
            this._ctManager.registerModelChange(PrincipalThreadLocal.getUserId(), this._portal.getClassNameId(DDMStructureVersion.class.getName()), ddmStructureVersion.getStructureVersionId(), ddmStructureVersion.getStructureId(), changeType, force);
        }
        catch (CTException cte) {
            if (cte instanceof CTEntryException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)cte.getMessage());
                }
            }
            throw cte;
        }
    }
}

