/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.change.tracking.internal.configuration;

import com.liferay.change.tracking.configuration.CTConfigurationRegistrar;
import com.liferay.change.tracking.configuration.builder.CTConfigurationBuilder;
import com.liferay.change.tracking.function.CTFunctions;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateModel;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersionModel;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(immediate=true, service={})
public class DDMTemplateCTConfigurationRegistrar {
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateCTConfigurationRegistrar.class);
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private CTConfigurationBuilder<DDMTemplate, DDMTemplateVersion> _builder;
    @Reference
    private CTConfigurationRegistrar _ctConfigurationRegistrar;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DDMTemplateVersionLocalService _ddmTemplateVersionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    @Activate
    public void activate() {
        this._ctConfigurationRegistrar.register(this._builder.setContentType("Dynamic Data Mapping Template").setContentTypeLanguageKey("dynamic-data-mapping-template").setEntityClasses(DDMTemplate.class, DDMTemplateVersion.class).setResourceEntitiesByCompanyIdFunction(this::_fetchDDMTemplates).setResourceEntityByResourceEntityIdFunction(arg_0 -> ((DDMTemplateLocalService)this._ddmTemplateLocalService).fetchTemplate(arg_0)).setEntityIdsFromResourceEntityFunctions(DDMTemplateModel::getTemplateId, this::_fetchLatestTemplateVersionId).setVersionEntitiesFromResourceEntityFunction(ddmTemplate -> this._ddmTemplateVersionLocalService.getTemplateVersions(ddmTemplate.getTemplateId())).setVersionEntityByVersionEntityIdFunction(arg_0 -> ((DDMTemplateVersionLocalService)this._ddmTemplateVersionLocalService).fetchDDMTemplateVersion(arg_0)).setVersionEntityDetails(null, CTFunctions.getFetchSiteNameFunction(), ddmStructureVersion -> ddmStructureVersion.getName(LocaleUtil.getMostRelevantLocale()), DDMTemplateVersionModel::getVersion).setEntityIdsFromVersionEntityFunctions(DDMTemplateVersionModel::getTemplateId, DDMTemplateVersionModel::getTemplateVersionId).setVersionEntityStatusInfo(new Integer[]{0}, ddmTemplateVersion -> 0).build());
    }

    private List<DDMTemplate> _fetchDDMTemplates(long companyId) {
        DynamicQuery dynamicQuery = this._ddmTemplateLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        return this._ddmTemplateLocalService.dynamicQuery(dynamicQuery);
    }

    private Serializable _fetchLatestTemplateVersionId(DDMTemplate ddmTemplate) {
        try {
            DDMTemplateVersion ddmTemplateVersion = ddmTemplate.getLatestTemplateVersion();
            return Long.valueOf(ddmTemplateVersion.getTemplateVersionId());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get template version ID", (Throwable)pe);
            }
            return Integer.valueOf(0);
        }
    }
}

