/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.lists.model.impl;

import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersionModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DDLRecordSetVersion service. Represents a row in the &quot;DDLRecordSetVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DDLRecordSetVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDLRecordSetVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDLRecordSetVersionImpl
 * @generated
 */
@JSON(strict = true)
public class DDLRecordSetVersionModelImpl
	extends BaseModelImpl<DDLRecordSetVersion>
	implements DDLRecordSetVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddl record set version model instance should use the <code>DDLRecordSetVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "DDLRecordSetVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"recordSetVersionId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"recordSetId", Types.BIGINT}, {"DDMStructureVersionId", Types.BIGINT},
		{"name", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"settings_", Types.CLOB}, {"version", Types.VARCHAR},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("recordSetVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("recordSetId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("DDMStructureVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("settings_", Types.CLOB);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DDLRecordSetVersion (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,recordSetVersionId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,recordSetId LONG,DDMStructureVersionId LONG,name STRING null,description STRING null,settings_ TEXT null,version VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (recordSetVersionId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table DDLRecordSetVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ddlRecordSetVersion.recordSetVersionId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DDLRecordSetVersion.recordSetVersionId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RECORDSETID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RECORDSETVERSIONID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public DDLRecordSetVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _recordSetVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setRecordSetVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _recordSetVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DDLRecordSetVersion.class;
	}

	@Override
	public String getModelClassName() {
		return DDLRecordSetVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DDLRecordSetVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DDLRecordSetVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDLRecordSetVersion, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DDLRecordSetVersion)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DDLRecordSetVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DDLRecordSetVersion, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DDLRecordSetVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DDLRecordSetVersion, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DDLRecordSetVersion, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<DDLRecordSetVersion, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<DDLRecordSetVersion, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<DDLRecordSetVersion, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", DDLRecordSetVersion::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", DDLRecordSetVersion::getCtCollectionId);
			attributeGetterFunctions.put(
				"recordSetVersionId",
				DDLRecordSetVersion::getRecordSetVersionId);
			attributeGetterFunctions.put(
				"groupId", DDLRecordSetVersion::getGroupId);
			attributeGetterFunctions.put(
				"companyId", DDLRecordSetVersion::getCompanyId);
			attributeGetterFunctions.put(
				"userId", DDLRecordSetVersion::getUserId);
			attributeGetterFunctions.put(
				"userName", DDLRecordSetVersion::getUserName);
			attributeGetterFunctions.put(
				"createDate", DDLRecordSetVersion::getCreateDate);
			attributeGetterFunctions.put(
				"recordSetId", DDLRecordSetVersion::getRecordSetId);
			attributeGetterFunctions.put(
				"DDMStructureVersionId",
				DDLRecordSetVersion::getDDMStructureVersionId);
			attributeGetterFunctions.put("name", DDLRecordSetVersion::getName);
			attributeGetterFunctions.put(
				"description", DDLRecordSetVersion::getDescription);
			attributeGetterFunctions.put(
				"settings", DDLRecordSetVersion::getSettings);
			attributeGetterFunctions.put(
				"version", DDLRecordSetVersion::getVersion);
			attributeGetterFunctions.put(
				"status", DDLRecordSetVersion::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", DDLRecordSetVersion::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", DDLRecordSetVersion::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", DDLRecordSetVersion::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<DDLRecordSetVersion, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<DDLRecordSetVersion, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<DDLRecordSetVersion, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"recordSetVersionId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setRecordSetVersionId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<DDLRecordSetVersion, String>)
					DDLRecordSetVersion::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<DDLRecordSetVersion, Date>)
					DDLRecordSetVersion::setCreateDate);
			attributeSetterBiConsumers.put(
				"recordSetId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setRecordSetId);
			attributeSetterBiConsumers.put(
				"DDMStructureVersionId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setDDMStructureVersionId);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<DDLRecordSetVersion, String>)
					DDLRecordSetVersion::setName);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<DDLRecordSetVersion, String>)
					DDLRecordSetVersion::setDescription);
			attributeSetterBiConsumers.put(
				"settings",
				(BiConsumer<DDLRecordSetVersion, String>)
					DDLRecordSetVersion::setSettings);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<DDLRecordSetVersion, String>)
					DDLRecordSetVersion::setVersion);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<DDLRecordSetVersion, Integer>)
					DDLRecordSetVersion::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<DDLRecordSetVersion, Long>)
					DDLRecordSetVersion::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<DDLRecordSetVersion, String>)
					DDLRecordSetVersion::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<DDLRecordSetVersion, Date>)
					DDLRecordSetVersion::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public long getRecordSetVersionId() {
		return _recordSetVersionId;
	}

	@Override
	public void setRecordSetVersionId(long recordSetVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_recordSetVersionId = recordSetVersionId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public long getRecordSetId() {
		return _recordSetId;
	}

	@Override
	public void setRecordSetId(long recordSetId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_recordSetId = recordSetId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalRecordSetId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("recordSetId"));
	}

	@JSON
	@Override
	public long getDDMStructureVersionId() {
		return _DDMStructureVersionId;
	}

	@Override
	public void setDDMStructureVersionId(long DDMStructureVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_DDMStructureVersionId = DDMStructureVersionId;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSettings() {
		if (_settings == null) {
			return "";
		}
		else {
			return _settings;
		}
	}

	@Override
	public void setSettings(String settings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_settings = settings;
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalVersion() {
		return getColumnOriginalValue("version");
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DDLRecordSetVersion.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			DDLRecordSetVersion.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public DDLRecordSetVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DDLRecordSetVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DDLRecordSetVersionImpl ddlRecordSetVersionImpl =
			new DDLRecordSetVersionImpl();

		ddlRecordSetVersionImpl.setMvccVersion(getMvccVersion());
		ddlRecordSetVersionImpl.setCtCollectionId(getCtCollectionId());
		ddlRecordSetVersionImpl.setRecordSetVersionId(getRecordSetVersionId());
		ddlRecordSetVersionImpl.setGroupId(getGroupId());
		ddlRecordSetVersionImpl.setCompanyId(getCompanyId());
		ddlRecordSetVersionImpl.setUserId(getUserId());
		ddlRecordSetVersionImpl.setUserName(getUserName());
		ddlRecordSetVersionImpl.setCreateDate(getCreateDate());
		ddlRecordSetVersionImpl.setRecordSetId(getRecordSetId());
		ddlRecordSetVersionImpl.setDDMStructureVersionId(
			getDDMStructureVersionId());
		ddlRecordSetVersionImpl.setName(getName());
		ddlRecordSetVersionImpl.setDescription(getDescription());
		ddlRecordSetVersionImpl.setSettings(getSettings());
		ddlRecordSetVersionImpl.setVersion(getVersion());
		ddlRecordSetVersionImpl.setStatus(getStatus());
		ddlRecordSetVersionImpl.setStatusByUserId(getStatusByUserId());
		ddlRecordSetVersionImpl.setStatusByUserName(getStatusByUserName());
		ddlRecordSetVersionImpl.setStatusDate(getStatusDate());

		ddlRecordSetVersionImpl.resetOriginalValues();

		return ddlRecordSetVersionImpl;
	}

	@Override
	public DDLRecordSetVersion cloneWithOriginalValues() {
		DDLRecordSetVersionImpl ddlRecordSetVersionImpl =
			new DDLRecordSetVersionImpl();

		ddlRecordSetVersionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ddlRecordSetVersionImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		ddlRecordSetVersionImpl.setRecordSetVersionId(
			this.<Long>getColumnOriginalValue("recordSetVersionId"));
		ddlRecordSetVersionImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		ddlRecordSetVersionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ddlRecordSetVersionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		ddlRecordSetVersionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		ddlRecordSetVersionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		ddlRecordSetVersionImpl.setRecordSetId(
			this.<Long>getColumnOriginalValue("recordSetId"));
		ddlRecordSetVersionImpl.setDDMStructureVersionId(
			this.<Long>getColumnOriginalValue("DDMStructureVersionId"));
		ddlRecordSetVersionImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		ddlRecordSetVersionImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		ddlRecordSetVersionImpl.setSettings(
			this.<String>getColumnOriginalValue("settings_"));
		ddlRecordSetVersionImpl.setVersion(
			this.<String>getColumnOriginalValue("version"));
		ddlRecordSetVersionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		ddlRecordSetVersionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		ddlRecordSetVersionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		ddlRecordSetVersionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return ddlRecordSetVersionImpl;
	}

	@Override
	public int compareTo(DDLRecordSetVersion ddlRecordSetVersion) {
		long primaryKey = ddlRecordSetVersion.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DDLRecordSetVersion)) {
			return false;
		}

		DDLRecordSetVersion ddlRecordSetVersion = (DDLRecordSetVersion)object;

		long primaryKey = ddlRecordSetVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DDLRecordSetVersion> toCacheModel() {
		DDLRecordSetVersionCacheModel ddlRecordSetVersionCacheModel =
			new DDLRecordSetVersionCacheModel();

		ddlRecordSetVersionCacheModel.mvccVersion = getMvccVersion();

		ddlRecordSetVersionCacheModel.ctCollectionId = getCtCollectionId();

		ddlRecordSetVersionCacheModel.recordSetVersionId =
			getRecordSetVersionId();

		ddlRecordSetVersionCacheModel.groupId = getGroupId();

		ddlRecordSetVersionCacheModel.companyId = getCompanyId();

		ddlRecordSetVersionCacheModel.userId = getUserId();

		ddlRecordSetVersionCacheModel.userName = getUserName();

		String userName = ddlRecordSetVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			ddlRecordSetVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			ddlRecordSetVersionCacheModel.createDate = createDate.getTime();
		}
		else {
			ddlRecordSetVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		ddlRecordSetVersionCacheModel.recordSetId = getRecordSetId();

		ddlRecordSetVersionCacheModel.DDMStructureVersionId =
			getDDMStructureVersionId();

		ddlRecordSetVersionCacheModel.name = getName();

		String name = ddlRecordSetVersionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			ddlRecordSetVersionCacheModel.name = null;
		}

		ddlRecordSetVersionCacheModel.description = getDescription();

		String description = ddlRecordSetVersionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			ddlRecordSetVersionCacheModel.description = null;
		}

		ddlRecordSetVersionCacheModel.settings = getSettings();

		String settings = ddlRecordSetVersionCacheModel.settings;

		if ((settings != null) && (settings.length() == 0)) {
			ddlRecordSetVersionCacheModel.settings = null;
		}

		ddlRecordSetVersionCacheModel.version = getVersion();

		String version = ddlRecordSetVersionCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			ddlRecordSetVersionCacheModel.version = null;
		}

		ddlRecordSetVersionCacheModel.status = getStatus();

		ddlRecordSetVersionCacheModel.statusByUserId = getStatusByUserId();

		ddlRecordSetVersionCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName =
			ddlRecordSetVersionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			ddlRecordSetVersionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			ddlRecordSetVersionCacheModel.statusDate = statusDate.getTime();
		}
		else {
			ddlRecordSetVersionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return ddlRecordSetVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DDLRecordSetVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DDLRecordSetVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DDLRecordSetVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(DDLRecordSetVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DDLRecordSetVersion>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DDLRecordSetVersion.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _recordSetVersionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private long _recordSetId;
	private long _DDMStructureVersionId;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _settings;
	private String _version;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<DDLRecordSetVersion, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DDLRecordSetVersion)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("recordSetVersionId", _recordSetVersionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("recordSetId", _recordSetId);
		_columnOriginalValues.put(
			"DDMStructureVersionId", _DDMStructureVersionId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("settings_", _settings);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("settings_", "settings");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("recordSetVersionId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("recordSetId", 256L);

		columnBitmasks.put("DDMStructureVersionId", 512L);

		columnBitmasks.put("name", 1024L);

		columnBitmasks.put("description", 2048L);

		columnBitmasks.put("settings_", 4096L);

		columnBitmasks.put("version", 8192L);

		columnBitmasks.put("status", 16384L);

		columnBitmasks.put("statusByUserId", 32768L);

		columnBitmasks.put("statusByUserName", 65536L);

		columnBitmasks.put("statusDate", 131072L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DDLRecordSetVersion _escapedModel;

}