/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.internal.exporter.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDLExporter.class})
public class DDLXLSExporter
extends BaseDDLExporter {
    private static final Log _log = LogFactoryUtil.getLog(DDLXLSExporter.class);
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private DDLRecordSetService _ddlRecordSetService;
    @Reference
    private DDLRecordSetVersionService _ddlRecordSetVersionService;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference
    private DDMFormFieldValueRendererRegistry _ddmFormFieldValueRendererRegistry;
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;

    public String getFormat() {
        return "xls";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(recordSetId);
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (HSSFWorkbook workbook = new HSSFWorkbook();){
                Sheet sheet = workbook.createSheet();
                this._createHeaderRow(ddmFormFields.values(), sheet, (Workbook)workbook);
                List records = this._ddlRecordLocalService.getRecords(recordSetId, status, start, end, orderByComparator);
                Iterator iterator = records.iterator();
                int rowIndex = 1;
                CellStyle cellStyle = this._createCellStyle((Workbook)workbook, false, "Courier New", (short)12);
                while (iterator.hasNext()) {
                    DDLRecord record = (DDLRecord)iterator.next();
                    DDLRecordVersion recordVersion = record.getRecordVersion();
                    DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(recordVersion.getDDMStorageId());
                    DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStorageLink.getStructureVersionId());
                    Map<String, BaseDDLExporter.DDMFormFieldRenderedValue> values = this.getRenderedValues(recordSet.getScope(), ddmFormFields.values(), this._ddmStorageEngineManager.getDDMFormValues(recordVersion.getDDMStorageId(), ddmStructureVersion.getDDMForm()), this._htmlParser);
                    this._createDataRow(rowIndex++, sheet, dateTimeFormatter, recordVersion.getUserName(), this.getStatusMessage(recordVersion.getStatus()), recordVersion.getStatusDate(), cellStyle, ddmFormFields, values);
                }
                workbook.write((OutputStream)byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return new byte[0];
        }
    }

    @Override
    protected DDLRecordSetVersionService getDDLRecordSetVersionService() {
        return this._ddlRecordSetVersionService;
    }

    @Override
    protected DDMFormFieldTypeServicesRegistry getDDMFormFieldTypeServicesRegistry() {
        return this._ddmFormFieldTypeServicesRegistry;
    }

    @Override
    protected DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry() {
        return this._ddmFormFieldValueRendererRegistry;
    }

    private CellStyle _createCellStyle(Workbook workbook, boolean bold, String fontName, short heightInPoints) {
        Font font = workbook.createFont();
        font.setBold(bold);
        font.setFontHeightInPoints(heightInPoints);
        font.setFontName(fontName);
        CellStyle style = workbook.createCellStyle();
        style.setFont(font);
        return style;
    }

    private void _createDataRow(int rowIndex, Sheet sheet, DateTimeFormatter dateTimeFormatter, String author, String status, Date statusDate, CellStyle style, Map<String, DDMFormField> ddmFormFields, Map<String, BaseDDLExporter.DDMFormFieldRenderedValue> values) {
        Cell cell;
        Row row = sheet.createRow(rowIndex);
        int cellIndex = 0;
        for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
            cell = row.createCell(cellIndex++, CellType.STRING);
            cell.setCellStyle(style);
            if (values.containsKey(entry.getKey())) {
                BaseDDLExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                cell.setCellValue(GetterUtil.getString((String)ddmFormFieldRenderedValue.getValue()));
                continue;
            }
            cell.setCellValue("");
        }
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(status);
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(this.formatDate(statusDate, dateTimeFormatter));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(author);
    }

    private void _createHeaderRow(Collection<DDMFormField> ddmFormFields, Sheet sheet, Workbook workbook) {
        Cell cell;
        Row row = sheet.createRow(0);
        CellStyle cellStyle = this._createCellStyle(workbook, true, "Courier New", (short)14);
        int cellIndex = 0;
        Locale locale = this.getLocale();
        for (DDMFormField ddmFormField : ddmFormFields) {
            LocalizedValue label = ddmFormField.getLabel();
            cell = row.createCell(cellIndex++, CellType.STRING);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(label.getString(locale));
        }
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(this._language.get(locale, "status"));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(this._language.get(locale, "modified-date"));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(this._language.get(locale, "author"));
    }
}

