/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDL.class})
public class DDLImpl
implements DDL {
    private static final Log _log = LogFactoryUtil.getLog(DDLImpl.class);
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private DDLRecordService _ddlRecordService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private StorageEngine _storageEngine;

    public JSONObject getRecordJSONObject(DDLRecord record, boolean latestRecordVersion, Locale locale) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (String fieldName : ddmStructure.getFieldNames()) {
            jsonObject.put(fieldName, "");
        }
        jsonObject.put("displayIndex", record.getDisplayIndex()).put("recordId", record.getRecordId());
        DDLRecordVersion recordVersion = record.getRecordVersion();
        if (latestRecordVersion) {
            recordVersion = record.getLatestRecordVersion();
        }
        Fields fields = this._ddmFormValuesToFieldsConverter.convert(ddmStructure, this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId()));
        for (Field field : fields) {
            JSONObject fieldJSONObject;
            Stream<String> fieldValuesStringStream;
            Object[] fieldValues = this._getFieldValues(field, locale);
            if (fieldValues.length == 0) continue;
            String fieldName = field.getName();
            String fieldType = field.getType();
            Stream<Object> fieldValuesStream = Arrays.stream(fieldValues);
            if (fieldType.equals("ddm-documentlibrary")) {
                fieldValuesStringStream = fieldValuesStream.map(fieldValue -> this._getDocumentLibraryFieldValue(fieldValue));
                fieldJSONObject = JSONUtil.put((String)"title", (Object)fieldValuesStringStream.collect(Collectors.joining(", ")));
                jsonObject.put(fieldName, fieldJSONObject.toString());
                continue;
            }
            if (fieldType.equals("ddm-link-to-page")) {
                fieldValuesStringStream = fieldValuesStream.map(fieldValue -> this._getLinkToPageFieldValue(fieldValue, locale));
                fieldJSONObject = JSONUtil.put((String)"name", (Object)fieldValuesStringStream.collect(Collectors.joining(", ")));
                jsonObject.put(fieldName, fieldJSONObject.toString());
                continue;
            }
            if (fieldType.equals("select")) {
                JSONArray fieldJSONArray = this._jsonFactory.createJSONArray();
                fieldValuesStream.forEach(fieldValue -> {
                    JSONArray valueJSONArray = this._getJSONArrayValue(fieldValue);
                    for (Object object : valueJSONArray) {
                        fieldJSONArray.put(object);
                    }
                });
                jsonObject.put(fieldName, fieldJSONArray);
                continue;
            }
            fieldValuesStringStream = fieldValuesStream.map(fieldValue -> {
                if (fieldValue instanceof Date) {
                    Date fieldValueDate = (Date)fieldValue;
                    return String.valueOf(fieldValueDate.getTime());
                }
                return String.valueOf(fieldValue);
            });
            jsonObject.put(fieldName, fieldValuesStringStream.collect(Collectors.joining(", ")));
        }
        return jsonObject;
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet, Locale locale) throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        List ddmFormFields = ddmStructure.getDDMFormFields(false);
        for (DDMFormField ddmFormField : ddmFormFields) {
            jsonArray.put(JSONUtil.put((String)"dataType", (Object)ddmFormField.getDataType()).put("editable", !ddmFormField.isReadOnly()).put("label", () -> {
                LocalizedValue label = ddmFormField.getLabel();
                return label.getString(locale);
            }).put("name", ddmFormField.getName()).put("required", ddmFormField.isRequired()).put("sortable", true).put("type", ddmFormField.getType()));
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion, Locale locale) throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record, latestRecordVersion, locale);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, boolean checkPermission, ServiceContext serviceContext) throws Exception {
        DDLRecord record = this._ddlRecordLocalService.fetchRecord(recordId);
        boolean majorVersion = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"majorVersion");
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.getDDLRecordSet(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this._ddm.getFields(ddmStructure.getStructureId(), serviceContext);
        if (record != null) {
            if (mergeFields) {
                DDLRecordVersion recordVersion = record.getLatestRecordVersion();
                DDMFormValues existingDDMFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
                Fields existingFields = this._ddmFormValuesToFieldsConverter.convert(recordSet.getDDMStructure(), existingDDMFormValues);
                fields = this._ddm.mergeFields(fields, existingFields);
            }
            record = checkPermission ? this._ddlRecordService.updateRecord(recordId, majorVersion, 0, this._fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields), serviceContext) : this._ddlRecordLocalService.updateRecord(serviceContext.getUserId(), recordId, majorVersion, 0, this._fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields), serviceContext);
        } else {
            record = checkPermission ? this._ddlRecordService.addRecord(serviceContext.getScopeGroupId(), recordSetId, 0, this._fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields), serviceContext) : this._ddlRecordLocalService.addRecord(serviceContext.getUserId(), serviceContext.getScopeGroupId(), recordSetId, 0, this._fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields), serviceContext);
        }
        return record;
    }

    private String _getDocumentLibraryFieldValue(Object fieldValue) {
        try {
            JSONObject fieldValueJSONObject = this._jsonFactory.createJSONObject(String.valueOf(fieldValue));
            String uuid = fieldValueJSONObject.getString("uuid");
            long groupId = fieldValueJSONObject.getLong("groupId");
            return this._getFileEntryTitle(uuid, groupId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    private Object[] _getFieldValues(Field field, Locale locale) {
        Serializable fieldValue = field.getValue(locale);
        if (fieldValue == null) {
            return new Object[0];
        }
        if (this._isArray(fieldValue)) {
            return (Object[])fieldValue;
        }
        return new Object[]{fieldValue};
    }

    private String _getFileEntryTitle(String uuid, long groupId) {
        try {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
            return fileEntry.getTitle();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this._language.format(LocaleUtil.getSiteDefault(), "is-temporarily-unavailable", (Object)"content");
        }
    }

    private JSONArray _getJSONArrayValue(Object fieldValue) {
        try {
            return this._jsonFactory.createJSONArray(String.valueOf(fieldValue));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this._jsonFactory.createJSONArray();
        }
    }

    private String _getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) {
        try {
            return this._layoutService.getLayoutName(groupId, privateLayout, layoutId, languageId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this._language.format(LocaleUtil.getSiteDefault(), "is-temporarily-unavailable", (Object)"content");
        }
    }

    private String _getLinkToPageFieldValue(Object fieldValue, Locale locale) {
        try {
            JSONObject fieldValueJSONObject = this._jsonFactory.createJSONObject(String.valueOf(fieldValue));
            long groupId = fieldValueJSONObject.getLong("groupId");
            boolean privateLayout = fieldValueJSONObject.getBoolean("privateLayout");
            long layoutId = fieldValueJSONObject.getLong("layoutId");
            return this._getLayoutName(groupId, privateLayout, layoutId, this._language.getLanguageId(locale));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    private boolean _isArray(Object parameter) {
        Class<?> clazz = parameter.getClass();
        return clazz.isArray();
    }
}

