/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.search.spi.model.result.contributor;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={ModelSummaryContributor.class})
public class DDLRecordModelSummaryContributor
implements ModelSummaryContributor {
    @Reference
    protected DDLRecordSetLocalService ddlRecordSetLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordModelSummaryContributor.class);

    public Summary getSummary(Document document, Locale locale, String snippet) {
        long ddlRecordId = GetterUtil.getLong((String)document.get("recordId"));
        String prefix = "snippet_";
        String description = document.get(locale, prefix + "description", "description");
        Summary summary = new Summary(this.getTitle(ddlRecordId, locale), description);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return resourceBundleLoader.loadResourceBundle(locale);
    }

    protected String getTitle(long ddlRecordSetId, Locale locale) {
        try {
            DDLRecordSet ddlRecordSet = this.ddlRecordSetLocalService.getRecordSet(ddlRecordSetId);
            String recordSetName = ddlRecordSet.getName(locale);
            return LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"new-entry-for-form-x", (Object)recordSetName, (boolean)false);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return "";
        }
    }
}

