/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.persistence.impl;

import com.liferay.dynamic.data.lists.exception.NoSuchRecordException;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.impl.DDLRecordImpl;
import com.liferay.dynamic.data.lists.model.impl.DDLRecordModelImpl;
import com.liferay.dynamic.data.lists.service.persistence.DDLRecordPersistence;
import com.liferay.dynamic.data.lists.service.persistence.impl.constants.DDLPersistenceConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDLRecordPersistence.class})
public class DDLRecordPersistenceImpl
extends BasePersistenceImpl<DDLRecord>
implements DDLRecordPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDLRecordImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "ddlRecord.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "ddlRecord.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "ddlRecord.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "ddlRecord.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "ddlRecord.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "ddlRecord.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByRecordSetId;
    private FinderPath _finderPathWithoutPaginationFindByRecordSetId;
    private FinderPath _finderPathCountByRecordSetId;
    private static final String _FINDER_COLUMN_RECORDSETID_RECORDSETID_2 = "ddlRecord.recordSetId = ?";
    private FinderPath _finderPathWithPaginationFindByR_U;
    private FinderPath _finderPathWithoutPaginationFindByR_U;
    private FinderPath _finderPathCountByR_U;
    private static final String _FINDER_COLUMN_R_U_RECORDSETID_2 = "ddlRecord.recordSetId = ? AND ";
    private static final String _FINDER_COLUMN_R_U_USERID_2 = "ddlRecord.userId = ?";
    private FinderPath _finderPathWithPaginationFindByR_R;
    private FinderPath _finderPathWithoutPaginationFindByR_R;
    private FinderPath _finderPathCountByR_R;
    private static final String _FINDER_COLUMN_R_R_RECORDSETID_2 = "ddlRecord.recordSetId = ? AND ";
    private static final String _FINDER_COLUMN_R_R_RECORDSETVERSION_2 = "ddlRecord.recordSetVersion = ?";
    private static final String _FINDER_COLUMN_R_R_RECORDSETVERSION_3 = "(ddlRecord.recordSetVersion IS NULL OR ddlRecord.recordSetVersion = '')";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDLRECORD = "SELECT ddlRecord FROM DDLRecord ddlRecord";
    private static final String _SQL_SELECT_DDLRECORD_WHERE = "SELECT ddlRecord FROM DDLRecord ddlRecord WHERE ";
    private static final String _SQL_COUNT_DDLRECORD = "SELECT COUNT(ddlRecord) FROM DDLRecord ddlRecord";
    private static final String _SQL_COUNT_DDLRECORD_WHERE = "SELECT COUNT(ddlRecord) FROM DDLRecord ddlRecord WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddlRecord.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDLRecord exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDLRecord exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<DDLRecord> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<DDLRecord> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<DDLRecord> findByUuid(String uuid, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<DDLRecord> findByUuid(String uuid, int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecord ddlRecord : list) {
                if (uuid.equals(ddlRecord.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddlRecord.recordId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecord findByUuid_First(String uuid, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByUuid_First(uuid, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByUuid_First(String uuid, OrderByComparator<DDLRecord> orderByComparator) {
        List<DDLRecord> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord findByUuid_Last(String uuid, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByUuid_Last(uuid, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByUuid_Last(String uuid, OrderByComparator<DDLRecord> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<DDLRecord> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord[] findByUuid_PrevAndNext(long recordId, String uuid, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        uuid = Objects.toString(uuid, "");
        DDLRecord ddlRecord = this.findByPrimaryKey(recordId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord[] array = new DDLRecordImpl[]{this.getByUuid_PrevAndNext(session, ddlRecord, uuid, orderByComparator, true), ddlRecord, this.getByUuid_PrevAndNext(session, ddlRecord, uuid, orderByComparator, false)};
            DDLRecord[] dDLRecordArray = array;
            return dDLRecordArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord getByUuid_PrevAndNext(Session session, DDLRecord ddlRecord, String uuid, OrderByComparator<DDLRecord> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDLRECORD_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecord.recordId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecord)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecord)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (DDLRecord ddlRecord : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDLRecord findByUUID_G(String uuid, long groupId) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByUUID_G(uuid, groupId);
        if (ddlRecord == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchRecordException(msg.toString());
        }
        return ddlRecord;
    }

    public DDLRecord fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public DDLRecord fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        DDLRecord ddlRecord;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof DDLRecord && (!Objects.equals(uuid, (ddlRecord = (DDLRecord)result).getUuid()) || groupId != ddlRecord.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("ddlRecord.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    DDLRecord ddlRecord2 = (DDLRecord)list.get(0);
                    result = ddlRecord2;
                    this.cacheResult(ddlRecord2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDLRecord)result;
    }

    public DDLRecord removeByUUID_G(String uuid, long groupId) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.findByUUID_G(uuid, groupId);
        return (DDLRecord)this.remove((BaseModel)ddlRecord);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("ddlRecord.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDLRecord> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<DDLRecord> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<DDLRecord> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<DDLRecord> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecord ddlRecord : list) {
                if (uuid.equals(ddlRecord.getUuid()) && companyId == ddlRecord.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("ddlRecord.uuid = ? AND ");
            }
            query.append("ddlRecord.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddlRecord.recordId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecord findByUuid_C_First(String uuid, long companyId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<DDLRecord> orderByComparator) {
        List<DDLRecord> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord findByUuid_C_Last(String uuid, long companyId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<DDLRecord> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<DDLRecord> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord[] findByUuid_C_PrevAndNext(long recordId, String uuid, long companyId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        uuid = Objects.toString(uuid, "");
        DDLRecord ddlRecord = this.findByPrimaryKey(recordId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord[] array = new DDLRecordImpl[]{this.getByUuid_C_PrevAndNext(session, ddlRecord, uuid, companyId, orderByComparator, true), ddlRecord, this.getByUuid_C_PrevAndNext(session, ddlRecord, uuid, companyId, orderByComparator, false)};
            DDLRecord[] dDLRecordArray = array;
            return dDLRecordArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord getByUuid_C_PrevAndNext(Session session, DDLRecord ddlRecord, String uuid, long companyId, OrderByComparator<DDLRecord> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DDLRECORD_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append("(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("ddlRecord.uuid = ? AND ");
        }
        query.append("ddlRecord.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecord.recordId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecord)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecord)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (DDLRecord ddlRecord : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(ddlRecord.uuid IS NULL OR ddlRecord.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("ddlRecord.uuid = ? AND ");
            }
            query.append("ddlRecord.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDLRecord> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<DDLRecord> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<DDLRecord> findByCompanyId(long companyId, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<DDLRecord> findByCompanyId(long companyId, int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecord ddlRecord : list) {
                if (companyId == ddlRecord.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            query.append("ddlRecord.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddlRecord.recordId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecord findByCompanyId_First(long companyId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByCompanyId_First(long companyId, OrderByComparator<DDLRecord> orderByComparator) {
        List<DDLRecord> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord findByCompanyId_Last(long companyId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByCompanyId_Last(long companyId, OrderByComparator<DDLRecord> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<DDLRecord> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord[] findByCompanyId_PrevAndNext(long recordId, long companyId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.findByPrimaryKey(recordId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord[] array = new DDLRecordImpl[]{this.getByCompanyId_PrevAndNext(session, ddlRecord, companyId, orderByComparator, true), ddlRecord, this.getByCompanyId_PrevAndNext(session, ddlRecord, companyId, orderByComparator, false)};
            DDLRecord[] dDLRecordArray = array;
            return dDLRecordArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord getByCompanyId_PrevAndNext(Session session, DDLRecord ddlRecord, long companyId, OrderByComparator<DDLRecord> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDLRECORD_WHERE);
        query.append("ddlRecord.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecord.recordId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecord)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecord)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (DDLRecord ddlRecord : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            query.append("ddlRecord.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDLRecord> findByRecordSetId(long recordSetId) {
        return this.findByRecordSetId(recordSetId, -1, -1, null);
    }

    public List<DDLRecord> findByRecordSetId(long recordSetId, int start, int end) {
        return this.findByRecordSetId(recordSetId, start, end, null);
    }

    public List<DDLRecord> findByRecordSetId(long recordSetId, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findByRecordSetId(recordSetId, start, end, orderByComparator, true);
    }

    public List<DDLRecord> findByRecordSetId(long recordSetId, int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByRecordSetId;
                finderArgs = new Object[]{recordSetId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByRecordSetId;
            finderArgs = new Object[]{recordSetId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecord ddlRecord : list) {
                if (recordSetId == ddlRecord.getRecordSetId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            query.append(_FINDER_COLUMN_RECORDSETID_RECORDSETID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddlRecord.recordId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordSetId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecord findByRecordSetId_First(long recordSetId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByRecordSetId_First(recordSetId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordSetId=");
        msg.append(recordSetId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByRecordSetId_First(long recordSetId, OrderByComparator<DDLRecord> orderByComparator) {
        List<DDLRecord> list = this.findByRecordSetId(recordSetId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord findByRecordSetId_Last(long recordSetId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByRecordSetId_Last(recordSetId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordSetId=");
        msg.append(recordSetId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByRecordSetId_Last(long recordSetId, OrderByComparator<DDLRecord> orderByComparator) {
        int count = this.countByRecordSetId(recordSetId);
        if (count == 0) {
            return null;
        }
        List<DDLRecord> list = this.findByRecordSetId(recordSetId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord[] findByRecordSetId_PrevAndNext(long recordId, long recordSetId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.findByPrimaryKey(recordId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord[] array = new DDLRecordImpl[]{this.getByRecordSetId_PrevAndNext(session, ddlRecord, recordSetId, orderByComparator, true), ddlRecord, this.getByRecordSetId_PrevAndNext(session, ddlRecord, recordSetId, orderByComparator, false)};
            DDLRecord[] dDLRecordArray = array;
            return dDLRecordArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord getByRecordSetId_PrevAndNext(Session session, DDLRecord ddlRecord, long recordSetId, OrderByComparator<DDLRecord> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDLRECORD_WHERE);
        query.append(_FINDER_COLUMN_RECORDSETID_RECORDSETID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecord.recordId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(recordSetId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecord)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecord)list.get(1);
        }
        return null;
    }

    public void removeByRecordSetId(long recordSetId) {
        for (DDLRecord ddlRecord : this.findByRecordSetId(recordSetId, -1, -1, null)) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countByRecordSetId(long recordSetId) {
        FinderPath finderPath = this._finderPathCountByRecordSetId;
        Object[] finderArgs = new Object[]{recordSetId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            query.append(_FINDER_COLUMN_RECORDSETID_RECORDSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordSetId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDLRecord> findByR_U(long recordSetId, long userId) {
        return this.findByR_U(recordSetId, userId, -1, -1, null);
    }

    public List<DDLRecord> findByR_U(long recordSetId, long userId, int start, int end) {
        return this.findByR_U(recordSetId, userId, start, end, null);
    }

    public List<DDLRecord> findByR_U(long recordSetId, long userId, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findByR_U(recordSetId, userId, start, end, orderByComparator, true);
    }

    public List<DDLRecord> findByR_U(long recordSetId, long userId, int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByR_U;
                finderArgs = new Object[]{recordSetId, userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByR_U;
            finderArgs = new Object[]{recordSetId, userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecord ddlRecord : list) {
                if (recordSetId == ddlRecord.getRecordSetId() && userId == ddlRecord.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            query.append("ddlRecord.recordSetId = ? AND ");
            query.append(_FINDER_COLUMN_R_U_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddlRecord.recordId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordSetId);
                qPos.add(userId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecord findByR_U_First(long recordSetId, long userId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByR_U_First(recordSetId, userId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordSetId=");
        msg.append(recordSetId);
        msg.append(", userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByR_U_First(long recordSetId, long userId, OrderByComparator<DDLRecord> orderByComparator) {
        List<DDLRecord> list = this.findByR_U(recordSetId, userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord findByR_U_Last(long recordSetId, long userId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByR_U_Last(recordSetId, userId, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordSetId=");
        msg.append(recordSetId);
        msg.append(", userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByR_U_Last(long recordSetId, long userId, OrderByComparator<DDLRecord> orderByComparator) {
        int count = this.countByR_U(recordSetId, userId);
        if (count == 0) {
            return null;
        }
        List<DDLRecord> list = this.findByR_U(recordSetId, userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord[] findByR_U_PrevAndNext(long recordId, long recordSetId, long userId, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.findByPrimaryKey(recordId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord[] array = new DDLRecordImpl[]{this.getByR_U_PrevAndNext(session, ddlRecord, recordSetId, userId, orderByComparator, true), ddlRecord, this.getByR_U_PrevAndNext(session, ddlRecord, recordSetId, userId, orderByComparator, false)};
            DDLRecord[] dDLRecordArray = array;
            return dDLRecordArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord getByR_U_PrevAndNext(Session session, DDLRecord ddlRecord, long recordSetId, long userId, OrderByComparator<DDLRecord> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DDLRECORD_WHERE);
        query.append("ddlRecord.recordSetId = ? AND ");
        query.append(_FINDER_COLUMN_R_U_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecord.recordId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(recordSetId);
        qPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecord)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecord)list.get(1);
        }
        return null;
    }

    public void removeByR_U(long recordSetId, long userId) {
        for (DDLRecord ddlRecord : this.findByR_U(recordSetId, userId, -1, -1, null)) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countByR_U(long recordSetId, long userId) {
        FinderPath finderPath = this._finderPathCountByR_U;
        Object[] finderArgs = new Object[]{recordSetId, userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            query.append("ddlRecord.recordSetId = ? AND ");
            query.append(_FINDER_COLUMN_R_U_USERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordSetId);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDLRecord> findByR_R(long recordSetId, String recordSetVersion) {
        return this.findByR_R(recordSetId, recordSetVersion, -1, -1, null);
    }

    public List<DDLRecord> findByR_R(long recordSetId, String recordSetVersion, int start, int end) {
        return this.findByR_R(recordSetId, recordSetVersion, start, end, null);
    }

    public List<DDLRecord> findByR_R(long recordSetId, String recordSetVersion, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findByR_R(recordSetId, recordSetVersion, start, end, orderByComparator, true);
    }

    public List<DDLRecord> findByR_R(long recordSetId, String recordSetVersion, int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        recordSetVersion = Objects.toString(recordSetVersion, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByR_R;
                finderArgs = new Object[]{recordSetId, recordSetVersion};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByR_R;
            finderArgs = new Object[]{recordSetId, recordSetVersion, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecord ddlRecord : list) {
                if (recordSetId == ddlRecord.getRecordSetId() && recordSetVersion.equals(ddlRecord.getRecordSetVersion())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DDLRECORD_WHERE);
            query.append("ddlRecord.recordSetId = ? AND ");
            boolean bindRecordSetVersion = false;
            if (recordSetVersion.isEmpty()) {
                query.append(_FINDER_COLUMN_R_R_RECORDSETVERSION_3);
            } else {
                bindRecordSetVersion = true;
                query.append(_FINDER_COLUMN_R_R_RECORDSETVERSION_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY ddlRecord.recordId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordSetId);
                if (bindRecordSetVersion) {
                    qPos.add(recordSetVersion);
                }
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecord findByR_R_First(long recordSetId, String recordSetVersion, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByR_R_First(recordSetId, recordSetVersion, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordSetId=");
        msg.append(recordSetId);
        msg.append(", recordSetVersion=");
        msg.append(recordSetVersion);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByR_R_First(long recordSetId, String recordSetVersion, OrderByComparator<DDLRecord> orderByComparator) {
        List<DDLRecord> list = this.findByR_R(recordSetId, recordSetVersion, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord findByR_R_Last(long recordSetId, String recordSetVersion, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        DDLRecord ddlRecord = this.fetchByR_R_Last(recordSetId, recordSetVersion, orderByComparator);
        if (ddlRecord != null) {
            return ddlRecord;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordSetId=");
        msg.append(recordSetId);
        msg.append(", recordSetVersion=");
        msg.append(recordSetVersion);
        msg.append("}");
        throw new NoSuchRecordException(msg.toString());
    }

    public DDLRecord fetchByR_R_Last(long recordSetId, String recordSetVersion, OrderByComparator<DDLRecord> orderByComparator) {
        int count = this.countByR_R(recordSetId, recordSetVersion);
        if (count == 0) {
            return null;
        }
        List<DDLRecord> list = this.findByR_R(recordSetId, recordSetVersion, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecord[] findByR_R_PrevAndNext(long recordId, long recordSetId, String recordSetVersion, OrderByComparator<DDLRecord> orderByComparator) throws NoSuchRecordException {
        recordSetVersion = Objects.toString(recordSetVersion, "");
        DDLRecord ddlRecord = this.findByPrimaryKey(recordId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord[] array = new DDLRecordImpl[]{this.getByR_R_PrevAndNext(session, ddlRecord, recordSetId, recordSetVersion, orderByComparator, true), ddlRecord, this.getByR_R_PrevAndNext(session, ddlRecord, recordSetId, recordSetVersion, orderByComparator, false)};
            DDLRecord[] dDLRecordArray = array;
            return dDLRecordArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord getByR_R_PrevAndNext(Session session, DDLRecord ddlRecord, long recordSetId, String recordSetVersion, OrderByComparator<DDLRecord> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DDLRECORD_WHERE);
        query.append("ddlRecord.recordSetId = ? AND ");
        boolean bindRecordSetVersion = false;
        if (recordSetVersion.isEmpty()) {
            query.append(_FINDER_COLUMN_R_R_RECORDSETVERSION_3);
        } else {
            bindRecordSetVersion = true;
            query.append(_FINDER_COLUMN_R_R_RECORDSETVERSION_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecord.recordId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(recordSetId);
        if (bindRecordSetVersion) {
            qPos.add(recordSetVersion);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecord)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecord)list.get(1);
        }
        return null;
    }

    public void removeByR_R(long recordSetId, String recordSetVersion) {
        for (DDLRecord ddlRecord : this.findByR_R(recordSetId, recordSetVersion, -1, -1, null)) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countByR_R(long recordSetId, String recordSetVersion) {
        recordSetVersion = Objects.toString(recordSetVersion, "");
        FinderPath finderPath = this._finderPathCountByR_R;
        Object[] finderArgs = new Object[]{recordSetId, recordSetVersion};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDLRECORD_WHERE);
            query.append("ddlRecord.recordSetId = ? AND ");
            boolean bindRecordSetVersion = false;
            if (recordSetVersion.isEmpty()) {
                query.append(_FINDER_COLUMN_R_R_RECORDSETVERSION_3);
            } else {
                bindRecordSetVersion = true;
                query.append(_FINDER_COLUMN_R_R_RECORDSETVERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordSetId);
                if (bindRecordSetVersion) {
                    qPos.add(recordSetVersion);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDLRecordPersistenceImpl() {
        this.setModelClass(DDLRecord.class);
        this.setModelImplClass(DDLRecordImpl.class);
        this.setModelPKClass(Long.TYPE);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
    }

    public void cacheResult(DDLRecord ddlRecord) {
        this.entityCache.putResult(this.entityCacheEnabled, DDLRecordImpl.class, (Serializable)Long.valueOf(ddlRecord.getPrimaryKey()), (Serializable)ddlRecord);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{ddlRecord.getUuid(), ddlRecord.getGroupId()}, (Object)ddlRecord);
        ddlRecord.resetOriginalValues();
    }

    public void cacheResult(List<DDLRecord> ddlRecords) {
        for (DDLRecord ddlRecord : ddlRecords) {
            if (this.entityCache.getResult(this.entityCacheEnabled, DDLRecordImpl.class, (Serializable)Long.valueOf(ddlRecord.getPrimaryKey())) == null) {
                this.cacheResult(ddlRecord);
                continue;
            }
            ddlRecord.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDLRecordImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DDLRecord ddlRecord) {
        this.entityCache.removeResult(this.entityCacheEnabled, DDLRecordImpl.class, (Serializable)Long.valueOf(ddlRecord.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DDLRecordModelImpl)ddlRecord, true);
    }

    public void clearCache(List<DDLRecord> ddlRecords) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DDLRecord ddlRecord : ddlRecords) {
            this.entityCache.removeResult(this.entityCacheEnabled, DDLRecordImpl.class, (Serializable)Long.valueOf(ddlRecord.getPrimaryKey()));
            this.clearUniqueFindersCache((DDLRecordModelImpl)ddlRecord, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, DDLRecordImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DDLRecordModelImpl ddlRecordModelImpl) {
        Object[] args = new Object[]{ddlRecordModelImpl.getUuid(), ddlRecordModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)ddlRecordModelImpl, false);
    }

    protected void clearUniqueFindersCache(DDLRecordModelImpl ddlRecordModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ddlRecordModelImpl.getUuid(), ddlRecordModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{ddlRecordModelImpl.getOriginalUuid(), ddlRecordModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
    }

    public DDLRecord create(long recordId) {
        DDLRecordImpl ddlRecord = new DDLRecordImpl();
        ddlRecord.setNew(true);
        ddlRecord.setPrimaryKey(recordId);
        String uuid = PortalUUIDUtil.generate();
        ddlRecord.setUuid(uuid);
        ddlRecord.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ddlRecord;
    }

    public DDLRecord remove(long recordId) throws NoSuchRecordException {
        return this.remove(Long.valueOf(recordId));
    }

    public DDLRecord remove(Serializable primaryKey) throws NoSuchRecordException {
        Session session = null;
        try {
            session = this.openSession();
            DDLRecord ddlRecord = (DDLRecord)session.get(DDLRecordImpl.class, primaryKey);
            if (ddlRecord == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRecordException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDLRecord dDLRecord = (DDLRecord)this.remove((BaseModel)ddlRecord);
            return dDLRecord;
        }
        catch (NoSuchRecordException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecord removeImpl(DDLRecord ddlRecord) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddlRecord)) {
                ddlRecord = (DDLRecord)session.get(DDLRecordImpl.class, ddlRecord.getPrimaryKeyObj());
            }
            if (ddlRecord != null) {
                session.delete((Object)ddlRecord);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ddlRecord != null) {
            this.clearCache(ddlRecord);
        }
        return ddlRecord;
    }

    public DDLRecord updateImpl(DDLRecord ddlRecord) {
        boolean isNew = ddlRecord.isNew();
        if (!(ddlRecord instanceof DDLRecordModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddlRecord.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddlRecord);
                throw new IllegalArgumentException("Implement ModelWrapper in ddlRecord proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDLRecord implementation " + ddlRecord.getClass());
        }
        DDLRecordModelImpl ddlRecordModelImpl = (DDLRecordModelImpl)ddlRecord;
        if (Validator.isNull((String)ddlRecord.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            ddlRecord.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && ddlRecord.getCreateDate() == null) {
            if (serviceContext == null) {
                ddlRecord.setCreateDate(now);
            } else {
                ddlRecord.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!ddlRecordModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                ddlRecord.setModifiedDate(now);
            } else {
                ddlRecord.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (ddlRecord.isNew()) {
                session.save((Object)ddlRecord);
                ddlRecord.setNew(false);
            } else {
                ddlRecord = (DDLRecord)session.merge((Object)ddlRecord);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ddlRecordModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{ddlRecordModelImpl.getUuid(), ddlRecordModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{ddlRecordModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{ddlRecordModelImpl.getRecordSetId()};
            this.finderCache.removeResult(this._finderPathCountByRecordSetId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRecordSetId, args);
            args = new Object[]{ddlRecordModelImpl.getRecordSetId(), ddlRecordModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByR_U, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_U, args);
            args = new Object[]{ddlRecordModelImpl.getRecordSetId(), ddlRecordModelImpl.getRecordSetVersion()};
            this.finderCache.removeResult(this._finderPathCountByR_R, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_R, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{ddlRecordModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordModelImpl.getOriginalUuid(), ddlRecordModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{ddlRecordModelImpl.getUuid(), ddlRecordModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{ddlRecordModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByRecordSetId.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordModelImpl.getOriginalRecordSetId()};
                this.finderCache.removeResult(this._finderPathCountByRecordSetId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRecordSetId, args);
                args = new Object[]{ddlRecordModelImpl.getRecordSetId()};
                this.finderCache.removeResult(this._finderPathCountByRecordSetId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRecordSetId, args);
            }
            if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByR_U.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordModelImpl.getOriginalRecordSetId(), ddlRecordModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByR_U, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_U, args);
                args = new Object[]{ddlRecordModelImpl.getRecordSetId(), ddlRecordModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByR_U, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_U, args);
            }
            if ((ddlRecordModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByR_R.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordModelImpl.getOriginalRecordSetId(), ddlRecordModelImpl.getOriginalRecordSetVersion()};
                this.finderCache.removeResult(this._finderPathCountByR_R, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_R, args);
                args = new Object[]{ddlRecordModelImpl.getRecordSetId(), ddlRecordModelImpl.getRecordSetVersion()};
                this.finderCache.removeResult(this._finderPathCountByR_R, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_R, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, DDLRecordImpl.class, (Serializable)Long.valueOf(ddlRecord.getPrimaryKey()), (Serializable)ddlRecord, false);
        this.clearUniqueFindersCache(ddlRecordModelImpl, false);
        this.cacheUniqueFindersCache(ddlRecordModelImpl);
        ddlRecord.resetOriginalValues();
        return ddlRecord;
    }

    public DDLRecord findByPrimaryKey(Serializable primaryKey) throws NoSuchRecordException {
        DDLRecord ddlRecord = (DDLRecord)this.fetchByPrimaryKey(primaryKey);
        if (ddlRecord == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRecordException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddlRecord;
    }

    public DDLRecord findByPrimaryKey(long recordId) throws NoSuchRecordException {
        return this.findByPrimaryKey(Long.valueOf(recordId));
    }

    public DDLRecord fetchByPrimaryKey(long recordId) {
        return (DDLRecord)this.fetchByPrimaryKey(Long.valueOf(recordId));
    }

    public List<DDLRecord> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDLRecord> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDLRecord> findAll(int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDLRecord> findAll(int start, int end, OrderByComparator<DDLRecord> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_DDLRECORD);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DDLRECORD;
                sql = sql.concat(" ORDER BY ddlRecord.recordId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDLRecord ddlRecord : this.findAll()) {
            this.remove((BaseModel)ddlRecord);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_DDLRECORD);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "recordId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DDLRECORD;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DDLRecordModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        DDLRecordModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        DDLRecordModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 32L);
        this._finderPathCountByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 34L);
        this._finderPathCountByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 33L);
        this._finderPathCountByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByRecordSetId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByRecordSetId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByRecordSetId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByRecordSetId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByRecordSetId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRecordSetId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByR_U = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByR_U", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByR_U = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByR_U", new String[]{Long.class.getName(), Long.class.getName()}, 20L);
        this._finderPathCountByR_U = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByR_U", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByR_R = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByR_R", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByR_R = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DDLRecordImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByR_R", new String[]{Long.class.getName(), String.class.getName()}, 12L);
        this._finderPathCountByR_R = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByR_R", new String[]{Long.class.getName(), String.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(DDLRecordImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.dynamic.data.lists.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.dynamic.data.lists.model.DDLRecord"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.lists.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.dynamic.data.lists.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    static {
        try {
            Class.forName(DDLPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }
}

