/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.exception.NoSuchRecordSetVersionException;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordSetVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetVersionVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;

public class DDLRecordSetVersionLocalServiceImpl
extends DDLRecordSetVersionLocalServiceBaseImpl {
    public void deleteByRecordSetId(long recordSetId) {
        this.ddlRecordSetVersionPersistence.removeByRecordSetId(recordSetId);
    }

    public DDLRecordSetVersion getLatestRecordSetVersion(long recordSetId) throws PortalException {
        List recordSetVersions = this.ddlRecordSetVersionPersistence.findByRecordSetId(recordSetId);
        if (recordSetVersions.isEmpty()) {
            throw new NoSuchRecordSetVersionException("No record set versions found for record set ID " + recordSetId);
        }
        recordSetVersions = ListUtil.copy((List)recordSetVersions);
        Collections.sort(recordSetVersions, new DDLRecordSetVersionVersionComparator());
        return (DDLRecordSetVersion)recordSetVersions.get(0);
    }

    public DDLRecordSetVersion getRecordSetVersion(long recordSetVersionId) throws PortalException {
        return this.ddlRecordSetVersionPersistence.findByPrimaryKey(recordSetVersionId);
    }

    public DDLRecordSetVersion getRecordSetVersion(long recordSetId, String version) throws PortalException {
        return this.ddlRecordSetVersionPersistence.findByRS_V(recordSetId, version);
    }

    public List<DDLRecordSetVersion> getRecordSetVersions(long recordSetId) {
        return this.ddlRecordSetVersionPersistence.findByRecordSetId(recordSetId);
    }

    public List<DDLRecordSetVersion> getRecordSetVersions(long recordSetId, int start, int end, OrderByComparator<DDLRecordSetVersion> orderByComparator) {
        return this.ddlRecordSetVersionPersistence.findByRecordSetId(recordSetId, start, end, orderByComparator);
    }

    public int getRecordSetVersionsCount(long recordSetId) {
        return this.ddlRecordSetVersionPersistence.countByRecordSetId(recordSetId);
    }
}

