/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.internal.exporter.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDLExporter.class})
public class DDLCSVExporter
extends BaseDDLExporter {
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordSetService _ddlRecordSetService;
    private DDLRecordSetVersionService _ddlRecordSetVersionService;
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private DDMFormFieldValueRendererRegistry _ddmFormFieldValueRendererRegistry;
    private StorageEngine _storageEngine;

    public String getFormat() {
        return "csv";
    }

    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        StringBundler sb = new StringBundler();
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(recordSetId);
        Locale locale = this.getLocale();
        for (DDMFormField ddmFormField : ddmFormFields.values()) {
            LocalizedValue label = ddmFormField.getLabel();
            sb.append(CSVUtil.encode((String)label.getString(locale)));
            sb.append(',');
        }
        sb.append(LanguageUtil.get((Locale)locale, (String)"status"));
        sb.append(',');
        sb.append(LanguageUtil.get((Locale)locale, (String)"modified-date"));
        sb.append(',');
        sb.append(LanguageUtil.get((Locale)locale, (String)"author"));
        sb.append("\n");
        List records = this._ddlRecordLocalService.getRecords(recordSetId, status, start, end, orderByComparator);
        Iterator iterator = records.iterator();
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        while (iterator.hasNext()) {
            DDLRecord record = (DDLRecord)iterator.next();
            DDLRecordVersion recordVersion = record.getRecordVersion();
            DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
            Map<String, BaseDDLExporter.DDMFormFieldRenderedValue> values = this.getRenderedValues(recordSet.getScope(), ddmFormFields.values(), ddmFormValues);
            for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
                if (values.containsKey(entry.getKey())) {
                    BaseDDLExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                    sb.append(CSVUtil.encode((String)ddmFormFieldRenderedValue.getValue()));
                } else {
                    sb.append("");
                }
                sb.append(',');
            }
            sb.append(this.getStatusMessage(recordVersion.getStatus()));
            sb.append(',');
            sb.append(this.formatDate(recordVersion.getStatusDate(), dateTimeFormatter));
            sb.append(',');
            sb.append(CSVUtil.encode((String)recordVersion.getUserName()));
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }

    @Override
    protected DDLRecordSetVersionService getDDLRecordSetVersionService() {
        return this._ddlRecordSetVersionService;
    }

    @Override
    protected DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker() {
        return this._ddmFormFieldTypeServicesTracker;
    }

    @Override
    protected DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry() {
        return this._ddmFormFieldValueRendererRegistry;
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetVersionService(DDLRecordSetVersionService ddlRecordSetVersionService) {
        this._ddlRecordSetVersionService = ddlRecordSetVersionService;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldValueRendererRegistry(DDMFormFieldValueRendererRegistry ddmFormFieldValueRendererRegistry) {
        this._ddmFormFieldValueRendererRegistry = ddmFormFieldValueRendererRegistry;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

