/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.permission;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseResourcePermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"resource.name=com.liferay.dynamic.data.lists"}, service={ResourcePermissionChecker.class})
public class DDLPermission
extends BaseResourcePermissionChecker {
    public static final String RESOURCE_NAME = "com.liferay.dynamic.data.lists";

    public static void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!DDLPermission.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, RESOURCE_NAME, groupId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)DDLRecord.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        return DDLPermission.contains((PermissionChecker)permissionChecker, (String)RESOURCE_NAME, (String)portletId, (long)groupId, (String)actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String portletId, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)RESOURCE_NAME, (long)groupId, (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return permissionChecker.hasPermission(groupId, RESOURCE_NAME, groupId, actionId);
    }

    public Boolean checkResource(PermissionChecker permissionChecker, long classPK, String actionId) {
        return DDLPermission.contains(permissionChecker, classPK, actionId);
    }
}

