/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordVersionServiceBaseImpl;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class DDLRecordVersionServiceImpl
extends DDLRecordVersionServiceBaseImpl {
    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException {
        DDLRecordVersion recordVersion = this.ddlRecordVersionLocalService.getRecordVersion(recordVersionId);
        DDLRecordPermission.check(this.getPermissionChecker(), recordVersion.getRecordId(), "VIEW");
        return recordVersion;
    }

    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException {
        DDLRecordPermission.check(this.getPermissionChecker(), recordId, "VIEW");
        return this.ddlRecordVersionPersistence.findByR_V(recordId, version);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId) throws PortalException {
        DDLRecordPermission.check(this.getPermissionChecker(), recordId, "VIEW");
        return this.ddlRecordVersionPersistence.findByRecordId(recordId);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) throws PortalException {
        DDLRecordPermission.check(this.getPermissionChecker(), recordId, "VIEW");
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    public int getRecordVersionsCount(long recordId) throws PortalException {
        DDLRecordPermission.check(this.getPermissionChecker(), recordId, "VIEW");
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }
}

