/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDLImpl
implements DDL {
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordService _ddlRecordService;
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDM _ddm;
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private DLAppLocalService _dlAppLocalService;
    private LayoutService _layoutService;
    private StorageEngine _storageEngine;

    @Deprecated
    public JSONObject getRecordJSONObject(DDLRecord record) throws Exception {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        return this.getRecordJSONObject(record, false, locale);
    }

    public JSONObject getRecordJSONObject(DDLRecord record, boolean latestRecordVersion, Locale locale) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (String fieldName : ddmStructure.getFieldNames()) {
            jsonObject.put(fieldName, "");
        }
        jsonObject.put("displayIndex", record.getDisplayIndex());
        jsonObject.put("recordId", record.getRecordId());
        DDLRecordVersion recordVersion = record.getRecordVersion();
        if (latestRecordVersion) {
            recordVersion = record.getLatestRecordVersion();
        }
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
        Fields fields = this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
        for (Field field : fields) {
            JSONObject fieldJSONObject;
            Stream<String> fieldValuesStringStream;
            String fieldName = field.getName();
            String fieldType = field.getType();
            Object[] fieldValues = this.getFieldValues(field, locale);
            if (fieldValues.length == 0) continue;
            Stream<Object> fieldValuesStream = Arrays.stream(fieldValues);
            if (fieldType.equals("ddm-documentlibrary")) {
                fieldValuesStringStream = fieldValuesStream.map(fieldValue -> this.getDocumentLibraryFieldValue(fieldValue));
                fieldJSONObject = JSONFactoryUtil.createJSONObject();
                fieldJSONObject.put("title", fieldValuesStringStream.collect(Collectors.joining(", ")));
                jsonObject.put(fieldName, fieldJSONObject.toString());
                continue;
            }
            if (fieldType.equals("ddm-link-to-page")) {
                fieldValuesStringStream = fieldValuesStream.map(fieldValue -> this.getLinkToPageFieldValue(fieldValue, locale));
                fieldJSONObject = JSONFactoryUtil.createJSONObject();
                fieldJSONObject.put("name", fieldValuesStringStream.collect(Collectors.joining(", ")));
                jsonObject.put(fieldName, fieldJSONObject.toString());
                continue;
            }
            if (fieldType.equals("radio") || fieldType.equals("select")) {
                JSONArray fieldJSONArray = JSONFactoryUtil.createJSONArray();
                fieldValuesStream.forEach(fieldValue -> {
                    JSONArray jsonArrayValue = this.getJSONArrayValue(fieldValue);
                    fieldJSONArray.put(jsonArrayValue.get(0));
                });
                jsonObject.put(fieldName, fieldJSONArray);
                continue;
            }
            fieldValuesStringStream = fieldValuesStream.map(fieldValue -> {
                if (fieldValue instanceof Date) {
                    Date fieldValueDate = (Date)fieldValue;
                    return String.valueOf(fieldValueDate.getTime());
                }
                return String.valueOf(fieldValue);
            });
            jsonObject.put(fieldName, fieldValuesStringStream.collect(Collectors.joining(", ")));
        }
        return jsonObject;
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet, Locale locale) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        List ddmFormFields = ddmStructure.getDDMFormFields(false);
        for (DDMFormField ddmFormField : ddmFormFields) {
            String name = ddmFormField.getName();
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            String dataType = ddmFormField.getDataType();
            jsonObject.put("dataType", dataType);
            boolean readOnly = ddmFormField.isReadOnly();
            jsonObject.put("editable", !readOnly);
            LocalizedValue label = ddmFormField.getLabel();
            jsonObject.put("label", label.getString(locale));
            jsonObject.put("name", name);
            boolean required = ddmFormField.isRequired();
            jsonObject.put("required", required);
            jsonObject.put("sortable", true);
            String type = ddmFormField.getType();
            jsonObject.put("type", type);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Deprecated
    public JSONArray getRecordsJSONArray(DDLRecordSet recordSet) throws Exception {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        return this.getRecordsJSONArray(recordSet.getRecords(), false, locale);
    }

    @Deprecated
    public JSONArray getRecordsJSONArray(List<DDLRecord> records) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion, Locale locale) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record, latestRecordVersion, locale);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Deprecated
    public boolean isEditable(HttpServletRequest request, String portletId, long groupId) throws Exception {
        return true;
    }

    @Deprecated
    public boolean isEditable(PortletPreferences preferences, String portletId, long groupId) throws Exception {
        return true;
    }

    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, boolean checkPermission, ServiceContext serviceContext) throws Exception {
        DDLRecord record = this._ddlRecordLocalService.fetchRecord(recordId);
        boolean majorVersion = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"majorVersion");
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.getDDLRecordSet(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this._ddm.getFields(ddmStructure.getStructureId(), serviceContext);
        record = record != null ? (checkPermission ? this._ddlRecordService.updateRecord(recordId, majorVersion, 0, fields, mergeFields, serviceContext) : this._ddlRecordLocalService.updateRecord(serviceContext.getUserId(), recordId, majorVersion, 0, fields, mergeFields, serviceContext)) : (checkPermission ? this._ddlRecordService.addRecord(serviceContext.getScopeGroupId(), recordSetId, 0, fields, serviceContext) : this._ddlRecordLocalService.addRecord(serviceContext.getUserId(), serviceContext.getScopeGroupId(), recordSetId, 0, fields, serviceContext));
        return record;
    }

    @Deprecated
    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, ServiceContext serviceContext) throws Exception {
        return this.updateRecord(recordId, recordSetId, mergeFields, true, serviceContext);
    }

    protected String getDocumentLibraryFieldValue(Object fieldValue) {
        try {
            JSONObject fieldValueJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
            String uuid = fieldValueJSONObject.getString("uuid");
            long groupId = fieldValueJSONObject.getLong("groupId");
            return this.getFileEntryTitle(uuid, groupId);
        }
        catch (Exception e) {
            return "";
        }
    }

    protected Object[] getFieldValues(Field field, Locale locale) {
        Serializable fieldValue = field.getValue(locale);
        if (Validator.isNull((Object)fieldValue)) {
            return new Object[0];
        }
        if (this.isArray(fieldValue)) {
            return (Object[])fieldValue;
        }
        return new Object[]{fieldValue};
    }

    protected String getFileEntryTitle(String uuid, long groupId) {
        try {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
            return fileEntry.getTitle();
        }
        catch (Exception e) {
            return LanguageUtil.format((Locale)LocaleUtil.getSiteDefault(), (String)"is-temporarily-unavailable", (Object)"content");
        }
    }

    protected JSONArray getJSONArrayValue(Object fieldValue) {
        try {
            return JSONFactoryUtil.createJSONArray((String)String.valueOf(fieldValue));
        }
        catch (Exception e) {
            return JSONFactoryUtil.createJSONArray();
        }
    }

    protected String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) {
        try {
            return this._layoutService.getLayoutName(groupId, privateLayout, layoutId, languageId);
        }
        catch (Exception e) {
            return LanguageUtil.format((Locale)LocaleUtil.getSiteDefault(), (String)"is-temporarily-unavailable", (Object)"content");
        }
    }

    protected String getLinkToPageFieldValue(Object fieldValue, Locale locale) {
        try {
            JSONObject fieldValueJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
            long groupId = fieldValueJSONObject.getLong("groupId");
            boolean privateLayout = fieldValueJSONObject.getBoolean("privateLayout");
            long layoutId = fieldValueJSONObject.getLong("layoutId");
            return this.getLayoutName(groupId, privateLayout, layoutId, LanguageUtil.getLanguageId((Locale)locale));
        }
        catch (Exception e) {
            return "";
        }
    }

    protected boolean isArray(Object parameter) {
        Class<?> clazz = parameter.getClass();
        return clazz.isArray();
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordService(DDLRecordService ddlRecordService) {
        this._ddlRecordService = ddlRecordService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutService(LayoutService layoutService) {
        this._layoutService = layoutService;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

