/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.exportimport.staged.model.repository;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.base.BaseStagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={DDLRecordStagedModelRepository.class, StagedModelRepository.class})
public class DDLRecordStagedModelRepository
extends BaseStagedModelRepository<DDLRecord> {
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;

    public DDLRecord addStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public DDLRecord addStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddlRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddlRecord);
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddlRecord.getUuid());
        }
        return this._ddlRecordLocalService.addRecord(userId, ddlRecord.getGroupId(), ddlRecord.getRecordSetId(), ddlRecord.getDisplayIndex(), ddmFormValues, serviceContext);
    }

    public void deleteStagedModel(DDLRecord ddlRecord) throws PortalException {
        this._ddlRecordLocalService.deleteRecord(ddlRecord);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDLRecord ddlRecord = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddlRecord != null) {
            this.deleteStagedModel(ddlRecord);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public DDLRecord fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddlRecordLocalService.fetchDDLRecordByUuidAndGroupId(uuid, groupId);
    }

    public List<DDLRecord> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddlRecordLocalService.getDDLRecordsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this.getExportActionableDynamicQuery(portletDataContext, 0);
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext, final int scope) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddlRecordLocalService.getExportActionableDynamicQuery(portletDataContext);
        final ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                addCriteriaMethod.addCriteria(dynamicQuery);
                Property recordIdProperty = PropertyFactoryUtil.forName((String)"recordId");
                DynamicQuery recordVersionDynamicQuery = DDLRecordStagedModelRepository.this.getRecordVersionDynamicQuery();
                dynamicQuery.add(recordIdProperty.in(recordVersionDynamicQuery));
                Property recordSetIdProperty = PropertyFactoryUtil.forName((String)"recordSetId");
                DynamicQuery recordSetDynamicQuery = DDLRecordStagedModelRepository.this.getRecordSetDynamicQuery(scope);
                dynamicQuery.add(recordSetIdProperty.in(recordSetDynamicQuery));
            }
        });
        return exportActionableDynamicQuery;
    }

    public DDLRecord saveStagedModel(DDLRecord ddlRecord) throws PortalException {
        return this._ddlRecordLocalService.updateDDLRecord(ddlRecord);
    }

    public DDLRecord updateStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public DDLRecord updateStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddlRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddlRecord);
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        return this._ddlRecordLocalService.updateRecord(userId, ddlRecord.getRecordId(), false, ddlRecord.getDisplayIndex(), ddmFormValues, serviceContext);
    }

    protected DynamicQuery getRecordSetDynamicQuery(int scope) {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDLRecord.class.getName());
        Class<?> clazz = stagedModelDataHandler.getClass();
        DynamicQuery recordSetDynamicQuery = DynamicQueryFactoryUtil.forClass(DDLRecordSet.class, (String)"recordSet", (ClassLoader)clazz.getClassLoader());
        recordSetDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordSetId"));
        recordSetDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordSet.recordSetId", (String)"recordSetId"));
        Property scopeProperty = PropertyFactoryUtil.forName((String)"scope");
        recordSetDynamicQuery.add(scopeProperty.eq((Object)scope));
        return recordSetDynamicQuery;
    }

    protected DynamicQuery getRecordVersionDynamicQuery() {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDLRecord.class.getName());
        Class<?> clazz = stagedModelDataHandler.getClass();
        DynamicQuery recordVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DDLRecordVersion.class, (String)"recordVersion", (ClassLoader)clazz.getClassLoader());
        recordVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"recordId"));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        recordVersionDynamicQuery.add(statusProperty.in(stagedModelDataHandler.getExportableStatuses()));
        recordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordVersion.version", (String)"version"));
        recordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"recordVersion.recordId", (String)"recordId"));
        return recordVersionDynamicQuery;
    }
}

