/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.document.library.internal.configuration.DLIndexerConfiguration;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.security.io.InputStreamSanitizer;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextExtractor;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.search.ml.embedding.text.TextEmbeddingDocumentContributor;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.trash.TrashHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.internal.configuration.DLIndexerConfiguration"}, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelDocumentContributor.class})
public class DLFileEntryModelDocumentContributor
implements ModelDocumentContributor<DLFileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelDocumentContributor.class);
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    private volatile DLIndexerConfiguration _dlIndexerConfiguration;
    @Reference
    private DLStore _dlStore;
    @Reference
    private InputStreamSanitizer _inputStreamSanitizer;
    @Reference
    private Portal _portal;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private RelatedEntryIndexerRegistry _relatedEntryIndexerRegistry;
    @Reference
    private TextEmbeddingDocumentContributor _textEmbeddingDocumentContributor;
    @Reference
    private TextExtractor _textExtractor;
    @Reference
    private TrashHelper _trashHelper;

    public void contribute(Document document, DLFileEntry dlFileEntry) {
        try {
            List relatedEntryIndexers;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing document file entry " + String.valueOf(dlFileEntry)));
            }
            Locale defaultLocale = this._portal.getSiteDefaultLocale(dlFileEntry.getGroupId());
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            this._addFile(document, Field.getLocalizedName((Locale)defaultLocale, (String)"content"), dlFileEntry);
            document.addKeyword("classTypeId", dlFileEntry.getFileEntryTypeId());
            document.addText("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
            document.addText("description", dlFileEntry.getDescription());
            document.addText(Field.getLocalizedName((Locale)defaultLocale, (String)"description"), dlFileEntry.getDescription());
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addKeyword("status", dlFileVersion.getStatus());
            String title = dlFileEntry.getTitle();
            if (dlFileEntry.isInTrash()) {
                title = this._trashHelper.getOriginalTitle(title);
            }
            document.addText("title", title);
            document.addText(Field.getLocalizedName((Locale)defaultLocale, (String)"title"), title);
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
            document.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
            document.addKeyword("extension", dlFileEntry.getExtension());
            document.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
            document.addTextSortable("fileExtension", dlFileEntry.getExtension());
            document.addText("fileName", dlFileEntry.getFileName());
            document.addTextSortable("mimeType", StringUtil.replace((String)dlFileEntry.getMimeType(), (char)'/', (char)'_'));
            document.addKeyword("readCount", dlFileEntry.getReadCount());
            document.addDate("reviewDate", dlFileEntry.getReviewDate());
            document.addNumber("size", dlFileEntry.getSize());
            document.addNumber("versionCount", GetterUtil.getDouble((String)dlFileEntry.getVersion()));
            this._processDDMIndexer(document, dlFileVersion);
            if (dlFileEntry.isInHiddenFolder() && ListUtil.isNotEmpty((List)(relatedEntryIndexers = this._relatedEntryIndexerRegistry.getRelatedEntryIndexers(dlFileEntry.getClassName())))) {
                for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                    relatedEntryIndexer.addRelatedEntryFields(document, (Object)new LiferayFileEntry(dlFileEntry));
                    DocumentHelper documentHelper = new DocumentHelper(document);
                    documentHelper.setAttachmentOwnerKey(this._portal.getClassNameId(dlFileEntry.getClassName()), dlFileEntry.getClassPK());
                    document.addKeyword("relatedEntry", true);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document file entry " + String.valueOf(dlFileEntry) + " indexed successfully"));
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlIndexerConfiguration = (DLIndexerConfiguration)ConfigurableUtil.createConfigurable(DLIndexerConfiguration.class, properties);
    }

    private void _addFile(Document document, String fieldName, DLFileEntry dlFileEntry) {
        block3: {
            try {
                String text = this._extractText(dlFileEntry);
                if (text != null) {
                    document.addText(fieldName, text);
                    this._textEmbeddingDocumentContributor.contribute(document, (BaseModel)dlFileEntry, StringBundler.concat((String[])new String[]{dlFileEntry.getTitle(), ".", " ", text}));
                }
            }
            catch (PortalException | IOException exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(exception);
            }
        }
    }

    private String _extractText(DLFileEntry dlFileEntry) throws IOException, PortalException {
        InputStream inputStream;
        int dlFileIndexingMaxSize = GetterUtil.getInteger((String)PropsUtil.get((String)"dl.file.indexing.max.size"));
        String indexVersionLabel = this._getIndexVersionLabel(dlFileEntry);
        if (this._dlIndexerConfiguration.cacheTextExtraction() && this._dlStore.hasFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), indexVersionLabel)) {
            String string = StreamUtil.toString((InputStream)this._dlStore.getFileAsStream(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), indexVersionLabel));
            if (string.length() <= dlFileIndexingMaxSize) {
                return string;
            }
            this._dlStore.deleteFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), indexVersionLabel);
        }
        if ((inputStream = this._getInputStream(dlFileEntry)) == null) {
            return null;
        }
        String text = this._textExtractor.extractText(inputStream, dlFileIndexingMaxSize);
        if (this._dlIndexerConfiguration.cacheTextExtraction() && Validator.isNotNull((String)text) && !this._isReadOnlyCtCollection()) {
            this._dlStore.addFile(DLStoreRequest.builder((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName()).versionLabel(indexVersionLabel).build(), text.getBytes(StandardCharsets.UTF_8));
        }
        return text;
    }

    private String _getIndexVersionLabel(DLFileEntry dlFileEntry) throws PortalException {
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        return dlFileVersion.getStoreFileName() + ".index";
    }

    private InputStream _getInputStream(DLFileEntry dlFileEntry) {
        try {
            if (!this._isIndexContent(dlFileEntry)) {
                return null;
            }
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            return this._inputStreamSanitizer.sanitize(dlFileVersion.getContentStream(false));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get input stream", (Throwable)portalException);
            }
            return null;
        }
    }

    private boolean _isIndexContent(DLFileEntry dlFileEntry) {
        Object[] ignoreExtensions = this._prefsProps.getStringArray("dl.file.indexing.ignore.extensions", ",");
        return !ArrayUtil.contains((Object[])ignoreExtensions, (Object)("." + dlFileEntry.getExtension()));
    }

    private boolean _isReadOnlyCtCollection() throws PortalException {
        if (CTCollectionThreadLocal.isProductionMode()) {
            return false;
        }
        CTCollection ctCollection = this._ctCollectionLocalService.getCTCollection(CTCollectionThreadLocal.getCTCollectionId());
        return ctCollection.isReadOnly();
    }

    private void _processDDMIndexer(Document document, DLFileVersion dlFileVersion) {
        List dlFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(dlFileVersion.getFileVersionId());
        Locale locale = LocaleUtil.getSiteDefault();
        StringBundler sb = new StringBundler(dlFileEntryMetadatas.size() * 2);
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            try {
                DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dlFileEntryMetadata.getDDMStructureId());
                DDMFormValues ddmFormValues = this._ddmStorageEngineManager.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId(), ddmStructure.getDDMForm());
                if (ddmFormValues == null) continue;
                sb.append(this._ddmIndexer.extractIndexableAttributes(ddmStructure, ddmFormValues, locale));
                sb.append(" ");
                this._ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to retrieve metadata values", (Throwable)exception);
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        document.addText("ddmContent", sb.toString());
    }
}

