/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.processor.DLProcessor;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.model.DLFileVersionPreview;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DLFileVersionModelListener
extends BaseModelListener<DLFileVersion> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionModelListener.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    private ServiceTrackerMap<String, DLProcessor> _serviceTrackerMap;

    public void onAfterRemove(DLFileVersion dlFileVersion) throws ModelListenerException {
        try {
            DLFileVersionPreview dlFileVersionPreview;
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
            if (dlFileEntry != null) {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)dlFileVersion.getStoreFileName());
            }
            if ((dlFileVersionPreview = this._dlFileVersionPreviewLocalService.fetchDLFileVersionPreview(dlFileVersion.getFileEntryId(), dlFileVersion.getFileVersionId())) != null) {
                this._dlFileVersionPreviewLocalService.deleteDLFileVersionPreview(dlFileVersionPreview);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    public void onAfterUpdate(DLFileVersion originalModel, DLFileVersion model) throws ModelListenerException {
        if (Objects.equals(originalModel.getVersion(), model.getVersion()) && !Objects.equals("PWC", originalModel.getVersion()) && !Objects.equals(originalModel.getStoreFileName(), model.getStoreFileName())) {
            try {
                DLFileEntry fileEntry = originalModel.getFileEntry();
                DLStoreUtil.deleteFile((long)originalModel.getCompanyId(), (long)originalModel.getRepositoryId(), (String)fileEntry.getName(), (String)originalModel.getStoreFileName());
                DLStoreUtil.deleteFile((long)originalModel.getCompanyId(), (long)originalModel.getRepositoryId(), (String)fileEntry.getName(), (String)(originalModel.getStoreFileName() + ".index"));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    public void onBeforeRemove(DLFileVersion dlFileVersion) throws ModelListenerException {
        try {
            DLFileVersion latestFileVersion;
            dlFileVersion = this._dlFileVersionLocalService.fetchDLFileVersion(dlFileVersion.getFileVersionId());
            if (dlFileVersion == null) {
                return;
            }
            if (Objects.equals("PWC", dlFileVersion.getVersion()) && (latestFileVersion = this._dlFileVersionLocalService.fetchLatestFileVersion(dlFileVersion.getFileEntryId(), true)) != null) {
                this._cleanUpFileVersion(latestFileVersion.getFileVersionId());
            }
            this._cleanUpFileVersion(dlFileVersion.getFileVersionId());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DLProcessor.class, (String)"type");
    }

    private void _cleanUpFileVersion(long fileVersionId) throws PortalException {
        FileVersion fileVersion = this._dlAppLocalService.getFileVersion(fileVersionId);
        for (DLProcessor dlProcessor : this._serviceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.cleanUp(fileVersion);
        }
    }
}

