/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.internal.repository.capabilities.ConfigurationCapabilityImpl;
import com.liferay.document.library.internal.repository.capabilities.LiferayBulkOperationCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayCommentCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayDynamicCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayFileEntryTypeCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayProcessorCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayRelatedModelCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayRepositoryEventTriggerCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayThumbnailCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayTrashCapability;
import com.liferay.document.library.internal.repository.capabilities.LiferayWorkflowCapability;
import com.liferay.document.library.internal.repository.capabilities.MinimalWorkflowCapability;
import com.liferay.document.library.internal.repository.capabilities.TemporaryFileEntriesCapabilityImpl;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFolderService;
import com.liferay.document.library.security.io.InputStreamSanitizer;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.CommentCapability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.DynamicCapability;
import com.liferay.portal.kernel.repository.capabilities.FileEntryTypeCapability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.repository.capabilities.util.DLAppServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFileEntryServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFileVersionServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFolderServiceAdapter;
import com.liferay.portal.repository.capabilities.util.RepositoryEntryChecker;
import com.liferay.portal.repository.capabilities.util.RepositoryEntryConverter;
import com.liferay.portal.repository.capabilities.util.RepositoryServiceAdapter;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalCapabilityLocator.class})
public class PortalCapabilityLocatorImpl
implements PortalCapabilityLocator {
    private ProcessorCapability _alwaysGeneratingProcessorCapability;
    private BundleContext _bundleContext;
    private final CommentCapability _commentCapability = new LiferayCommentCapability();
    @Reference
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @Reference
    private DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    @Reference
    private DLFolderService _dlFolderService;
    @Reference
    private InputStreamSanitizer _inputStreamSanitizer;
    private final Map<DocumentRepository, LiferayDynamicCapability> _liferayDynamicCapabilities = new ConcurrentHashMap<DocumentRepository, LiferayDynamicCapability>();
    private final RepositoryEntryConverter _repositoryEntryConverter = new RepositoryEntryConverter();
    private ProcessorCapability _reusingProcessorCapability;
    private ServiceRegistration<CacheRegistryItem> _serviceRegistration;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;

    public BulkOperationCapability getBulkOperationCapability(DocumentRepository documentRepository) {
        return new LiferayBulkOperationCapability(documentRepository, DLFileEntryServiceAdapter.create((DocumentRepository)documentRepository), DLFolderServiceAdapter.create((DocumentRepository)documentRepository));
    }

    public CommentCapability getCommentCapability(DocumentRepository documentRepository) {
        return this._commentCapability;
    }

    public ConfigurationCapability getConfigurationCapability(DocumentRepository documentRepository) {
        return new ConfigurationCapabilityImpl(documentRepository, RepositoryServiceAdapter.create((DocumentRepository)documentRepository));
    }

    public DynamicCapability getDynamicCapability(DocumentRepository documentRepository, String repositoryClassName) {
        return this._liferayDynamicCapabilities.computeIfAbsent(documentRepository, key -> new LiferayDynamicCapability(this._bundleContext, repositoryClassName));
    }

    public FileEntryTypeCapability getFileEntryTypeCapability() {
        return new LiferayFileEntryTypeCapability(this._dlFolderService);
    }

    public ProcessorCapability getProcessorCapability(DocumentRepository documentRepository, ProcessorCapability.ResourceGenerationStrategy resourceGenerationStrategy) {
        if (resourceGenerationStrategy == ProcessorCapability.ResourceGenerationStrategy.ALWAYS_GENERATE) {
            return this._alwaysGeneratingProcessorCapability;
        }
        return this._reusingProcessorCapability;
    }

    public RelatedModelCapability getRelatedModelCapability(DocumentRepository documentRepository) {
        RepositoryEntryChecker repositoryEntryChecker = new RepositoryEntryChecker(documentRepository);
        return new LiferayRelatedModelCapability(this._repositoryEntryConverter, repositoryEntryChecker);
    }

    public RepositoryEventTriggerCapability getRepositoryEventTriggerCapability(DocumentRepository documentRepository, RepositoryEventTrigger repositoryEventTrigger) {
        return new LiferayRepositoryEventTriggerCapability(repositoryEventTrigger);
    }

    public TemporaryFileEntriesCapability getTemporaryFileEntriesCapability(DocumentRepository documentRepository) {
        return new TemporaryFileEntriesCapabilityImpl(documentRepository);
    }

    public ThumbnailCapability getThumbnailCapability(DocumentRepository documentRepository) {
        RepositoryEntryChecker repositoryEntryChecker = new RepositoryEntryChecker(documentRepository);
        return new LiferayThumbnailCapability(this._repositoryEntryConverter, repositoryEntryChecker);
    }

    public TrashCapability getTrashCapability(DocumentRepository documentRepository) {
        return new LiferayTrashCapability(this._dlAppHelperLocalService, DLAppServiceAdapter.create((DocumentRepository)documentRepository), DLFileEntryServiceAdapter.create((DocumentRepository)documentRepository), DLFolderServiceAdapter.create((DocumentRepository)documentRepository), RepositoryServiceAdapter.create((DocumentRepository)documentRepository), this._trashEntryLocalService, this._trashHelper, this._trashVersionLocalService);
    }

    public WorkflowCapability getWorkflowCapability(DocumentRepository documentRepository, WorkflowCapability.OperationMode operationMode) {
        if (operationMode == WorkflowCapability.OperationMode.MINIMAL) {
            return new MinimalWorkflowCapability(DLFileEntryServiceAdapter.create((DocumentRepository)documentRepository));
        }
        return new LiferayWorkflowCapability(DLFileEntryServiceAdapter.create((DocumentRepository)documentRepository), DLFileVersionServiceAdapter.create((DocumentRepository)documentRepository));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._alwaysGeneratingProcessorCapability = new LiferayProcessorCapability(ProcessorCapability.ResourceGenerationStrategy.ALWAYS_GENERATE, this._dlFileVersionPreviewLocalService, this._inputStreamSanitizer);
        this._reusingProcessorCapability = new LiferayProcessorCapability(ProcessorCapability.ResourceGenerationStrategy.REUSE, this._dlFileVersionPreviewLocalService, this._inputStreamSanitizer);
        this._serviceRegistration = bundleContext.registerService(CacheRegistryItem.class, (Object)new PortalCapabilityCacheRegistryItem(), null);
    }

    @Deactivate
    protected void deactivate() {
        this._clearLiferayDynamicCapabilities();
        this._serviceRegistration.unregister();
    }

    private void _clearLiferayDynamicCapabilities() {
        for (LiferayDynamicCapability liferayDynamicCapability : this._liferayDynamicCapabilities.values()) {
            liferayDynamicCapability.clear();
        }
        this._liferayDynamicCapabilities.clear();
    }

    private class PortalCapabilityCacheRegistryItem
    implements CacheRegistryItem {
        private PortalCapabilityCacheRegistryItem() {
        }

        public String getRegistryName() {
            return PortalCapabilityLocatorImpl.class.getName();
        }

        public void invalidate() {
            PortalCapabilityLocatorImpl.this._clearLiferayDynamicCapabilities();
        }
    }
}

