/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.service;

import com.liferay.asset.display.page.portlet.AssetDisplayPageEntryFormProcessor;
import com.liferay.document.library.internal.util.DLSubscriptionSender;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceWrapper;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.portal.json.jabsorb.serializer.LiferayJSONDeserializationWhitelist;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.DLGroupServiceSettings;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class SubscriptionDLAppHelperLocalServiceWrapper
extends DLAppHelperLocalServiceWrapper {
    @Reference
    private AssetDisplayPageEntryFormProcessor _assetDisplayPageEntryFormProcessor;
    private Closeable _closeable;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private Language _language;
    @Reference
    private LiferayJSONDeserializationWhitelist _liferayJSONDeserializationWhitelist;
    @Reference
    private Localization _localization;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        if (!this._isEnabled(fileEntry)) {
            return;
        }
        super.deleteFileEntry(fileEntry);
        this._subscriptionLocalService.deleteSubscriptions(fileEntry.getCompanyId(), DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
    }

    public void deleteFolder(Folder folder) throws PortalException {
        if (!this._isEnabled(folder)) {
            return;
        }
        super.deleteFolder(folder);
        this._subscriptionLocalService.deleteSubscriptions(folder.getCompanyId(), DLFolderConstants.getClassName(), folder.getFolderId());
    }

    public void updateStatus(long userId, FileEntry fileEntry, FileVersion latestFileVersion, int oldStatus, int newStatus, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (!this._isEnabled(fileEntry)) {
            return;
        }
        super.updateStatus(userId, fileEntry, latestFileVersion, oldStatus, newStatus, serviceContext, workflowContext);
        this._assetDisplayPageEntryFormProcessor.process(FileEntry.class.getName(), fileEntry.getFileEntryId(), serviceContext);
        if (newStatus == 0 && oldStatus != 8 && !fileEntry.isInTrash()) {
            this._notifySubscribers(userId, latestFileVersion, (String)((Object)workflowContext.get("url")), serviceContext);
        }
    }

    @Activate
    protected void activate() {
        this._closeable = this._liferayJSONDeserializationWhitelist.register(new String[]{DLSubscriptionSender.class.getName()});
    }

    @Deactivate
    protected void deactivate() {
        try {
            this._closeable.close();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private boolean _isEnabled(FileEntry fileEntry) {
        return DLAppHelperThreadLocal.isEnabled() && !RepositoryUtil.isExternalRepository((long)fileEntry.getRepositoryId());
    }

    private boolean _isEnabled(Folder folder) {
        return DLAppHelperThreadLocal.isEnabled() && (folder.isMountPoint() || !RepositoryUtil.isExternalRepository((long)folder.getRepositoryId()));
    }

    private void _notifySubscribers(long userId, FileVersion fileVersion, String entryURL, ServiceContext serviceContext) throws PortalException {
        if (!fileVersion.isApproved()) {
            return;
        }
        String friendlyURL = GetterUtil.getString((Object)serviceContext.getAttribute("friendlyURL"));
        if (Validator.isNotNull((String)friendlyURL)) {
            entryURL = friendlyURL;
        }
        if (Validator.isNull((String)entryURL)) {
            return;
        }
        DLGroupServiceSettings dlGroupServiceSettings = DLGroupServiceSettings.getInstance((long)fileVersion.getGroupId());
        boolean commandUpdate = false;
        if (serviceContext.isCommandUpdate() || "checkin".equals(serviceContext.getCommand())) {
            commandUpdate = true;
        }
        if (!(serviceContext.isCommandAdd() && dlGroupServiceSettings.isEmailFileEntryAddedEnabled() || commandUpdate && dlGroupServiceSettings.isEmailFileEntryUpdatedEnabled())) {
            return;
        }
        String entryTitle = fileVersion.getTitle();
        String fromName = dlGroupServiceSettings.getEmailFromName();
        String fromAddress = dlGroupServiceSettings.getEmailFromAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (commandUpdate) {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryUpdatedSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryUpdatedBody();
        } else {
            subjectLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryAddedSubject();
            bodyLocalizedValuesMap = dlGroupServiceSettings.getEmailFileEntryAddedBody();
        }
        FileEntry fileEntry = fileVersion.getFileEntry();
        Folder folder = null;
        long folderId = fileEntry.getFolderId();
        if (folderId != 0L) {
            folder = this._dlAppLocalService.getFolder(folderId);
        }
        DLSubscriptionSender subscriptionSender = new DLSubscriptionSender("com.liferay.document.library", folderId);
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getDLFileEntryType(dlFileEntry.getFileEntryTypeId());
        subscriptionSender.setClassPK(fileVersion.getFileEntryId());
        subscriptionSender.setClassName(DLFileEntryConstants.getClassName());
        if (folder != null) {
            subscriptionSender.setContextAttribute("[$FOLDER_NAME$]", folder.getName(), true);
        } else {
            subscriptionSender.setLocalizedContextAttribute("[$FOLDER_NAME$]", new EscapableLocalizableFunction(locale -> this._language.get(locale, "home")));
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$DOCUMENT_STATUS_BY_USER_NAME$]", fileVersion.getStatusByUserName(), "[$DOCUMENT_TITLE$]", entryTitle, "[$DOCUMENT_URL$]", entryURL});
        subscriptionSender.setContextCreatorUserPrefix("DOCUMENT");
        subscriptionSender.setCreatorUserId(fileVersion.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(this._localization.getMap(bodyLocalizedValuesMap));
        subscriptionSender.setLocalizedContextAttribute("[$DOCUMENT_TYPE$]", new EscapableLocalizableFunction(locale -> dlFileEntryType.getName(locale)));
        subscriptionSender.setLocalizedSubjectMap(this._localization.getMap(subjectLocalizedValuesMap));
        subscriptionSender.setMailId("file_entry", new Object[]{fileVersion.getFileEntryId()});
        int notificationType = 0;
        if (commandUpdate) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId(PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW));
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(fileVersion.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addAssetEntryPersistedSubscribers(DLFileEntry.class.getName(), dlFileEntry.getPrimaryKey());
        subscriptionSender.addPersistedSubscribers(DLFolder.class.getName(), fileVersion.getGroupId());
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(DLFolder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(DLFolder.class.getName(), ancestorFolderId);
            }
        }
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), fileVersion.getGroupId());
        } else {
            subscriptionSender.addPersistedSubscribers(DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId());
        }
        subscriptionSender.addPersistedSubscribers(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        subscriptionSender.flushNotificationsAsync();
    }
}

