/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DDMStructureModelListener
extends BaseModelListener<DDMStructure> {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private Portal _portal;

    public void onBeforeRemove(DDMStructure ddmStructure) throws ModelListenerException {
        try {
            this._onBeforeRemove(ddmStructure);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _onBeforeRemove(DDMStructure ddmStructure) throws PortalException {
        long classNameId = ddmStructure.getClassNameId();
        if (classNameId != this._portal.getClassNameId(DLFileEntryMetadata.class)) {
            return;
        }
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), ddmStructure.getStructureId());
        List ddmStructureVersions = this._ddmStructureVersionLocalService.getStructureVersions(ddmStructure.getStructureId());
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            List ddmStructureLayouts = this._ddmStructureLayoutLocalService.getStructureLayouts(ddmStructure.getGroupId(), classNameId, ddmStructureVersion.getStructureVersionId());
            for (DDMStructureLayout ddmStructureLayout : ddmStructureLayouts) {
                this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), ddmStructureLayout.getStructureLayoutId());
            }
        }
        this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(ddmStructure.getStructureId());
    }
}

