/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.util;

import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MimeTypeSizeLimitUtil {
    private static final Log _log = LogFactoryUtil.getLog(MimeTypeSizeLimitUtil.class);
    private static final Pattern _pattern = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9$!#&.,;=^_+-]*");

    public static <E extends Throwable> void parseMimeTypeSizeLimit(String mimeTypeSizeLimit, UnsafeBiConsumer<String, Long, E> unsafeBiConsumer) throws E {
        String[] parts = StringUtil.split((String)mimeTypeSizeLimit, (char)':');
        if (parts.length != 2) {
            unsafeBiConsumer.accept(null, null);
        } else {
            unsafeBiConsumer.accept((Object)MimeTypeSizeLimitUtil._parseMimeTypeName(StringUtil.trim((String)parts[0])), (Object)MimeTypeSizeLimitUtil._parseSizeLimit(StringUtil.trim((String)parts[1])));
        }
    }

    private static String _parseMimeTypeName(String mimeType) {
        String[] parts = StringUtil.split((String)mimeType, (char)'/');
        if (parts.length != 2) {
            return null;
        }
        Matcher typeMatcher = _pattern.matcher(parts[0]);
        if (!typeMatcher.matches()) {
            return null;
        }
        if (Objects.equals(parts[1], "*")) {
            return mimeType;
        }
        Matcher subtypeMatcher = _pattern.matcher(parts[1]);
        if (!subtypeMatcher.matches()) {
            return null;
        }
        return mimeType;
    }

    private static Long _parseSizeLimit(String sizeLimit) {
        try {
            long value = Long.parseLong(sizeLimit);
            if (value < 0L) {
                return null;
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)numberFormatException);
            }
            return null;
        }
    }
}

